<?php
function generate_pdf($data, $filename) {
?>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js"></script>
    
    <div id="planning" style="width: 297mm; height: 210mm; overflow: hidden; background: white; font-family: 'Inter', system-ui, -apple-system, sans-serif;">
        <!-- Header élégant -->
        <div style="background: linear-gradient(to right, #000000, #1a1a1a); color: white; padding: 20px; display: flex; justify-content: space-between; align-items: center; box-shadow: 0 4px 6px rgba(0,0,0,0.1);">
            <div>
                <h1 style="margin: 0; font-size: 24px; font-weight: 600; letter-spacing: -0.5px;">Hey Izhak !</h1>
           <p style="margin: 5px 0 0; color: #94a3b8; font-size: 13px;">School week schedule</p>
                <p style="margin: 5px 0 0; color: #94a3b8; font-size: 13px;">Created at <?= date('d/m/Y') ?></p>
            </div>
            <div id="qrcode" style="padding: 8px; background: white; border-radius: 8px;"></div>
        </div>

        <!-- Table du planning -->
        <div style="padding: 15px;">
            <table style="width: 100%; border-collapse: collapse; border: 1px solid #e5e7eb;">
                <tr>
                    <?php
                    $colors = [
                        'LUNDI' => '#2563eb',
                        'MARDI' => '#7c3aed',
                        'MERCREDI' => '#db2777',
                        'JEUDI' => '#059669',
                        'VENDREDI' => '#d97706'
                    ];

                    foreach ($colors as $day => $color): ?>
                        <th style="background: <?= $color ?>; color: white; padding: 12px; text-align: center; font-size: 15px; font-weight: 600; letter-spacing: 0.5px;">
                            <?= $day ?>
                        </th>
                    <?php endforeach; ?>
                </tr>

                <?php foreach ($data['program'][array_key_first($data['program'])] as $time => $_): ?>
                    <tr>
                        <?php foreach ($data['program'] as $day => $slots):
                            $activity = $slots[$time] ?? '';
                            $isPause = strpos($time, '[Pause]') !== false;
                            $isLunch = strpos($time, '[Déjeuner]') !== false;
                        ?>
                            <td style="border: 1px solid #e5e7eb; padding: 0;">
                                <div style="font-size: 11px; color: #64748b; padding: 4px 8px; background: #f8fafc; border-bottom: 1px solid #e5e7eb; font-weight: 500;">
                                    <?= str_replace(['[Pause]', '[Déjeuner]'], '', $time) ?>
                                </div>
                                <?php if ($isPause || $isLunch): ?>
                                    <div style="text-align: center; padding: 6px; background: #f1f5f9; font-size: 12px; color: #475569; font-weight: 500;">
                                        <?= $isLunch ? '🍽️ Pause déjeuner' : '☕ Pause' ?>
                                    </div>
                                <?php else: ?>
                                    <div style="padding: 6px 8px; font-size: 12px; color: #334155; min-height: 18px;">
                                        <?= htmlspecialchars($activity) ?>
                                    </div>
                                <?php endif; ?>
                            </td>
                        <?php endforeach; ?>
                    </tr>
                <?php endforeach; ?>
            </table>
        </div>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/qrcodejs/1.0.0/qrcode.min.js"></script>
    <script>
        window.onload = function() {
            new QRCode(document.getElementById("qrcode"), {
                text: window.location.origin + "/programs/<?= $filename ?>",
                width: 64,
                height: 64,
                colorDark: "#000000",
                colorLight: "#ffffff",
                correctLevel : QRCode.CorrectLevel.H
            });

            const element = document.getElementById('planning');
            const opt = {
                filename: '<?= $filename ?>',
                image: { type: 'jpeg', quality: 1 },
                html2canvas: { 
                    scale: 2,
                    useCORS: true,
                    letterRendering: true,
                    backgroundColor: '#ffffff'
                },
                jsPDF: { 
                    unit: 'mm', 
                    format: 'a4', 
                    orientation: 'landscape' 
                }
            };

            html2pdf().set(opt).from(element).save().then(() => {
                window.location.href = 'programs/<?= $filename ?>';
            });
        }
    </script>
<?php
    return 'programs/' . $filename;
}
?>