import * as react_jsx_runtime from 'react/jsx-runtime';
import { ToastQueue, ToastOptions } from '@react-stately/toast';
import { RegionProps } from './toast-region.mjs';
import { ToastProps, ToastPlacement } from './use-toast.mjs';
import '@heroui/theme';
import '@react-aria/toast';
import 'tailwind-variants';
import 'react';
import '@heroui/system';
import '@heroui/react-utils';
import 'framer-motion';

interface ToastProviderProps {
    maxVisibleToasts?: number;
    placement?: ToastPlacement;
    disableAnimation?: boolean;
    toastProps?: ToastProps;
    toastOffset?: number;
    regionProps?: RegionProps;
}
declare const getToastQueue: () => ToastQueue<ToastProps>;
declare const ToastProvider: ({ placement, disableAnimation: disableAnimationProp, maxVisibleToasts, toastOffset, toastProps, regionProps, }: ToastProviderProps) => react_jsx_runtime.JSX.Element;
declare const addToast: ({ ...props }: ToastProps & ToastOptions) => void;
declare const closeAll: () => void;

export { ToastProvider, addToast, closeAll, getToastQueue };
