"use client";
import {
  ToastRegion
} from "./chunk-QKGTOPVW.mjs";

// src/toast-provider.tsx
import { ToastQueue, useToastQueue } from "@react-stately/toast";
import { useProviderContext } from "@heroui/system";
import { AnimatePresence, LazyMotion } from "framer-motion";
import { jsx } from "react/jsx-runtime";
var loadFeatures = () => import("framer-motion").then((res) => res.domMax);
var globalToastQueue = null;
var getToastQueue = () => {
  if (!globalToastQueue) {
    globalToastQueue = new ToastQueue({
      maxVisibleToasts: Infinity
    });
  }
  return globalToastQueue;
};
var ToastProvider = ({
  placement = "bottom-right",
  disableAnimation: disableAnimationProp = false,
  maxVisibleToasts = 3,
  toastOffset = 0,
  toastProps = {},
  regionProps
}) => {
  var _a;
  const toastQueue = useToastQueue(getToastQueue());
  const globalContext = useProviderContext();
  const disableAnimation = (_a = disableAnimationProp != null ? disableAnimationProp : globalContext == null ? void 0 : globalContext.disableAnimation) != null ? _a : false;
  return /* @__PURE__ */ jsx(LazyMotion, { features: loadFeatures, children: /* @__PURE__ */ jsx(AnimatePresence, { children: toastQueue.visibleToasts.length > 0 ? /* @__PURE__ */ jsx(
    ToastRegion,
    {
      disableAnimation,
      maxVisibleToasts,
      placement,
      toastOffset,
      toastProps,
      toastQueue,
      ...regionProps
    }
  ) : null }) });
};
var addToast = ({ ...props }) => {
  if (!globalToastQueue) {
    return;
  }
  globalToastQueue.add(props);
};
var closeAll = () => {
  if (!globalToastQueue) {
    return;
  }
  const keys = globalToastQueue.visibleToasts.map((toast) => toast.key);
  keys.map((key) => {
    globalToastQueue == null ? void 0 : globalToastQueue.close(key);
  });
};

export {
  getToastQueue,
  ToastProvider,
  addToast,
  closeAll
};
