"use client";
import {
  useRadioGroup
} from "./chunk-X5HLY72N.mjs";
import {
  RadioGroupProvider
} from "./chunk-A5ZCUROT.mjs";

// src/radio-group.tsx
import { forwardRef } from "@heroui/system";
import { jsx, jsxs } from "react/jsx-runtime";
var RadioGroup = forwardRef((props, ref) => {
  const {
    Component,
    children,
    label,
    context,
    description,
    isInvalid,
    errorMessage,
    getGroupProps,
    getLabelProps,
    getWrapperProps,
    getDescriptionProps,
    getErrorMessageProps
  } = useRadioGroup({ ...props, ref });
  return /* @__PURE__ */ jsxs(Component, { ...getGroupProps(), children: [
    label && /* @__PURE__ */ jsx("span", { ...getLabelProps(), children: label }),
    /* @__PURE__ */ jsx("div", { ...getWrapperProps(), children: /* @__PURE__ */ jsx(RadioGroupProvider, { value: context, children }) }),
    isInvalid && errorMessage ? /* @__PURE__ */ jsx("div", { ...getErrorMessageProps(), children: errorMessage }) : description ? /* @__PURE__ */ jsx("div", { ...getDescriptionProps(), children: description }) : null
  ] });
});
RadioGroup.displayName = "HeroUI.RadioGroup";
var radio_group_default = RadioGroup;

export {
  radio_group_default
};
