import * as react from 'react';
import { ReactNode } from 'react';
import * as tailwind_variants from 'tailwind-variants';
import * as _heroui_system from '@heroui/system';
import { PropGetter, HTMLHeroUIProps } from '@heroui/system';
import { ModalVariantProps, SlotsToClasses, ModalSlots } from '@heroui/theme';
import { HTMLMotionProps } from 'framer-motion';
import { AriaModalOverlayProps } from '@react-aria/overlays';
import { ReactRef } from '@heroui/react-utils';
import { OverlayTriggerProps } from '@react-stately/overlays';

interface Props extends HTMLHeroUIProps<"section"> {
    /**
     * Ref to the DOM node.
     */
    ref?: ReactRef<HTMLElement | null>;
    /**
     * The props to modify the framer motion animation. Use the `variants` API to create your own animation.
     */
    motionProps?: HTMLMotionProps<"section">;
    /**
     * Determines whether to hide the modal close button.
     * @default false
     */
    hideCloseButton?: boolean;
    /**
     * Custom modal close button element.
     */
    closeButton?: ReactNode;
    /**
     * Whether the animation should be disabled.
     * @default false
     */
    disableAnimation?: boolean;
    /**
     * The container element in which the overlay portal will be placed.
     * @default document.body
     */
    portalContainer?: Element;
    /**
     * Whether the scroll should be blocked when the modal is open.
     * @default true
     */
    shouldBlockScroll?: boolean;
    /**
     *  Callback fired when the modal is closed.
     */
    onClose?: () => void;
    /**
     * Classname or List of classes to change the classNames of the element.
     * if `className` is passed, it will be added to the base slot.
     *
     * @example
     * ```ts
     * <Modal classNames={{
     *    wrapper: "wrapper-classes", // main modal wrapper
     *    backdrop: "backdrop-classes",
     *    base:"base-classes", // modal content wrapper
     *    header: "header-classes", // modal header
     *    body: "body-classes", // modal body
     *    footer: "footer-classes", // modal footer
     *    closeButton: "close-button-classes", // modal close button
     * }} />
     * ```
     */
    classNames?: SlotsToClasses<ModalSlots>;
    /**
     * Whether to close the overlay when the user interacts outside it.
     * @default true
     */
    isDismissable?: boolean;
}
type UseModalProps = Props & OverlayTriggerProps & Omit<AriaModalOverlayProps, "isDismissable"> & ModalVariantProps;
declare function useModal(originalProps: UseModalProps): {
    Component: _heroui_system.As<any>;
    slots: {
        wrapper: (slotProps?: ({
            size?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | "xs" | "3xl" | "4xl" | "5xl" | undefined;
            disableAnimation?: boolean | undefined;
            shadow?: "none" | "sm" | "md" | "lg" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | undefined;
            backdrop?: "blur" | "transparent" | "opaque" | undefined;
            placement?: "center" | "bottom" | "top" | "auto" | "top-center" | "bottom-center" | undefined;
            scrollBehavior?: "inside" | "outside" | "normal" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        base: (slotProps?: ({
            size?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | "xs" | "3xl" | "4xl" | "5xl" | undefined;
            disableAnimation?: boolean | undefined;
            shadow?: "none" | "sm" | "md" | "lg" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | undefined;
            backdrop?: "blur" | "transparent" | "opaque" | undefined;
            placement?: "center" | "bottom" | "top" | "auto" | "top-center" | "bottom-center" | undefined;
            scrollBehavior?: "inside" | "outside" | "normal" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        backdrop: (slotProps?: ({
            size?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | "xs" | "3xl" | "4xl" | "5xl" | undefined;
            disableAnimation?: boolean | undefined;
            shadow?: "none" | "sm" | "md" | "lg" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | undefined;
            backdrop?: "blur" | "transparent" | "opaque" | undefined;
            placement?: "center" | "bottom" | "top" | "auto" | "top-center" | "bottom-center" | undefined;
            scrollBehavior?: "inside" | "outside" | "normal" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        header: (slotProps?: ({
            size?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | "xs" | "3xl" | "4xl" | "5xl" | undefined;
            disableAnimation?: boolean | undefined;
            shadow?: "none" | "sm" | "md" | "lg" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | undefined;
            backdrop?: "blur" | "transparent" | "opaque" | undefined;
            placement?: "center" | "bottom" | "top" | "auto" | "top-center" | "bottom-center" | undefined;
            scrollBehavior?: "inside" | "outside" | "normal" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        body: (slotProps?: ({
            size?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | "xs" | "3xl" | "4xl" | "5xl" | undefined;
            disableAnimation?: boolean | undefined;
            shadow?: "none" | "sm" | "md" | "lg" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | undefined;
            backdrop?: "blur" | "transparent" | "opaque" | undefined;
            placement?: "center" | "bottom" | "top" | "auto" | "top-center" | "bottom-center" | undefined;
            scrollBehavior?: "inside" | "outside" | "normal" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        footer: (slotProps?: ({
            size?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | "xs" | "3xl" | "4xl" | "5xl" | undefined;
            disableAnimation?: boolean | undefined;
            shadow?: "none" | "sm" | "md" | "lg" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | undefined;
            backdrop?: "blur" | "transparent" | "opaque" | undefined;
            placement?: "center" | "bottom" | "top" | "auto" | "top-center" | "bottom-center" | undefined;
            scrollBehavior?: "inside" | "outside" | "normal" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        closeButton: (slotProps?: ({
            size?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | "xs" | "3xl" | "4xl" | "5xl" | undefined;
            disableAnimation?: boolean | undefined;
            shadow?: "none" | "sm" | "md" | "lg" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | undefined;
            backdrop?: "blur" | "transparent" | "opaque" | undefined;
            placement?: "center" | "bottom" | "top" | "auto" | "top-center" | "bottom-center" | undefined;
            scrollBehavior?: "inside" | "outside" | "normal" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
    } & {
        wrapper: (slotProps?: ({
            size?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | "xs" | "3xl" | "4xl" | "5xl" | undefined;
            disableAnimation?: boolean | undefined;
            shadow?: "none" | "sm" | "md" | "lg" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | undefined;
            backdrop?: "blur" | "transparent" | "opaque" | undefined;
            placement?: "center" | "bottom" | "top" | "auto" | "top-center" | "bottom-center" | undefined;
            scrollBehavior?: "inside" | "outside" | "normal" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        base: (slotProps?: ({
            size?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | "xs" | "3xl" | "4xl" | "5xl" | undefined;
            disableAnimation?: boolean | undefined;
            shadow?: "none" | "sm" | "md" | "lg" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | undefined;
            backdrop?: "blur" | "transparent" | "opaque" | undefined;
            placement?: "center" | "bottom" | "top" | "auto" | "top-center" | "bottom-center" | undefined;
            scrollBehavior?: "inside" | "outside" | "normal" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        backdrop: (slotProps?: ({
            size?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | "xs" | "3xl" | "4xl" | "5xl" | undefined;
            disableAnimation?: boolean | undefined;
            shadow?: "none" | "sm" | "md" | "lg" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | undefined;
            backdrop?: "blur" | "transparent" | "opaque" | undefined;
            placement?: "center" | "bottom" | "top" | "auto" | "top-center" | "bottom-center" | undefined;
            scrollBehavior?: "inside" | "outside" | "normal" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        header: (slotProps?: ({
            size?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | "xs" | "3xl" | "4xl" | "5xl" | undefined;
            disableAnimation?: boolean | undefined;
            shadow?: "none" | "sm" | "md" | "lg" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | undefined;
            backdrop?: "blur" | "transparent" | "opaque" | undefined;
            placement?: "center" | "bottom" | "top" | "auto" | "top-center" | "bottom-center" | undefined;
            scrollBehavior?: "inside" | "outside" | "normal" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        body: (slotProps?: ({
            size?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | "xs" | "3xl" | "4xl" | "5xl" | undefined;
            disableAnimation?: boolean | undefined;
            shadow?: "none" | "sm" | "md" | "lg" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | undefined;
            backdrop?: "blur" | "transparent" | "opaque" | undefined;
            placement?: "center" | "bottom" | "top" | "auto" | "top-center" | "bottom-center" | undefined;
            scrollBehavior?: "inside" | "outside" | "normal" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        footer: (slotProps?: ({
            size?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | "xs" | "3xl" | "4xl" | "5xl" | undefined;
            disableAnimation?: boolean | undefined;
            shadow?: "none" | "sm" | "md" | "lg" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | undefined;
            backdrop?: "blur" | "transparent" | "opaque" | undefined;
            placement?: "center" | "bottom" | "top" | "auto" | "top-center" | "bottom-center" | undefined;
            scrollBehavior?: "inside" | "outside" | "normal" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        closeButton: (slotProps?: ({
            size?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | "xs" | "3xl" | "4xl" | "5xl" | undefined;
            disableAnimation?: boolean | undefined;
            shadow?: "none" | "sm" | "md" | "lg" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | undefined;
            backdrop?: "blur" | "transparent" | "opaque" | undefined;
            placement?: "center" | "bottom" | "top" | "auto" | "top-center" | "bottom-center" | undefined;
            scrollBehavior?: "inside" | "outside" | "normal" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
    } & {};
    domRef: react.RefObject<HTMLElement>;
    headerId: string;
    bodyId: string;
    motionProps: HTMLMotionProps<"section"> | undefined;
    classNames: SlotsToClasses<"base" | "body" | "footer" | "header" | "wrapper" | "backdrop" | "closeButton"> | undefined;
    isDismissable: boolean;
    closeButton: ReactNode;
    hideCloseButton: boolean;
    portalContainer: Element | undefined;
    shouldBlockScroll: boolean;
    backdrop: "blur" | "transparent" | "opaque";
    isOpen: boolean;
    onClose: () => void;
    disableAnimation: boolean;
    setBodyMounted: react.Dispatch<react.SetStateAction<boolean>>;
    setHeaderMounted: react.Dispatch<react.SetStateAction<boolean>>;
    getDialogProps: PropGetter;
    getBackdropProps: PropGetter;
    getCloseButtonProps: PropGetter;
};
type UseModalReturn = ReturnType<typeof useModal>;

export { type UseModalProps, type UseModalReturn, useModal };
