import { DateValue } from '@internationalized/date';
import { ReactElement } from 'react';
import { UseDateRangePickerProps } from './use-date-range-picker.mjs';
import 'tailwind-variants';
import '@heroui/date-input';
import '@heroui/button';
import '@heroui/calendar';
import '@heroui/popover';
import '@react-types/shared';
import '@react-types/datepicker';
import '@react-stately/datepicker';
import './use-date-picker-base.mjs';
import '@heroui/system';
import '@heroui/theme';
import './date-range-picker-field.mjs';

interface Props<T extends DateValue> extends UseDateRangePickerProps<T> {
    /**
     * The placement of the selector button.
     * @default "end"
     */
    selectorButtonPlacement?: "start" | "end";
}
type DateRangePickerProps<T extends DateValue = DateValue> = Props<T>;
declare const DateRangePicker: <T extends DateValue>(props: DateRangePickerProps<T>) => ReactElement;

export { type DateRangePickerProps, type Props, DateRangePicker as default };
