"use client";
"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var index_exports = {};
__export(index_exports, {
  HeroUIProvider: () => HeroUIProvider,
  ProviderContext: () => ProviderContext,
  extendVariants: () => import_system_rsc.extendVariants,
  forwardRef: () => import_system_rsc.forwardRef,
  isHeroUIEl: () => import_system_rsc.isHeroUIEl,
  mapPropsVariants: () => import_system_rsc.mapPropsVariants,
  mapPropsVariantsWithCommon: () => import_system_rsc.mapPropsVariantsWithCommon,
  toIterator: () => import_system_rsc.toIterator,
  useLabelPlacement: () => useLabelPlacement,
  useProviderContext: () => useProviderContext
});
module.exports = __toCommonJS(index_exports);
var import_system_rsc = require("@heroui/system-rsc");

// src/provider.tsx
var import_i18n = require("@react-aria/i18n");
var import_utils = require("@react-aria/utils");
var import_overlays = require("@react-aria/overlays");
var import_react = require("react");
var import_framer_motion = require("framer-motion");

// src/provider-context.ts
var import_react_utils = require("@heroui/react-utils");
var [ProviderContext, useProviderContext] = (0, import_react_utils.createContext)({
  name: "ProviderContext",
  strict: false
});

// src/provider.tsx
var import_jsx_runtime = require("react/jsx-runtime");
var HeroUIProvider = ({
  children,
  navigate,
  disableAnimation,
  useHref,
  disableRipple = false,
  skipFramerMotionAnimations = disableAnimation,
  reducedMotion = "never",
  validationBehavior,
  locale = "en-US",
  labelPlacement,
  // if minDate / maxDate are not specified in `defaultDates`
  // then they will be set in `use-date-input.ts` or `use-calendar-base.ts`
  defaultDates,
  createCalendar,
  spinnerVariant,
  ...otherProps
}) => {
  let contents = children;
  if (navigate) {
    contents = /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_utils.RouterProvider, { navigate, useHref, children: contents });
  }
  const context = (0, import_react.useMemo)(() => {
    if (disableAnimation && skipFramerMotionAnimations) {
      import_framer_motion.MotionGlobalConfig.skipAnimations = true;
    }
    return {
      createCalendar,
      defaultDates,
      disableAnimation,
      disableRipple,
      validationBehavior,
      labelPlacement,
      spinnerVariant
    };
  }, [
    createCalendar,
    defaultDates == null ? void 0 : defaultDates.maxDate,
    defaultDates == null ? void 0 : defaultDates.minDate,
    disableAnimation,
    disableRipple,
    validationBehavior,
    labelPlacement,
    spinnerVariant
  ]);
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(ProviderContext, { value: context, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_i18n.I18nProvider, { locale, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_framer_motion.MotionConfig, { reducedMotion, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_overlays.OverlayProvider, { ...otherProps, children: contents }) }) }) });
};

// src/hooks/use-label-placement.ts
var import_react2 = require("react");
function useLabelPlacement(props) {
  const globalContext = useProviderContext();
  const globalLabelPlacement = globalContext == null ? void 0 : globalContext.labelPlacement;
  return (0, import_react2.useMemo)(() => {
    var _a, _b;
    const labelPlacement = (_b = (_a = props.labelPlacement) != null ? _a : globalLabelPlacement) != null ? _b : "inside";
    if (labelPlacement === "inside" && !props.label) {
      return "outside";
    }
    return labelPlacement;
  }, [props.labelPlacement, globalLabelPlacement, props.label]);
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  HeroUIProvider,
  ProviderContext,
  extendVariants,
  forwardRef,
  isHeroUIEl,
  mapPropsVariants,
  mapPropsVariantsWithCommon,
  toIterator,
  useLabelPlacement,
  useProviderContext
});
