"use client";

// src/use-switch.ts
import { useCallback, useId, useRef } from "react";
import { mapPropsVariants, useProviderContext } from "@heroui/system";
import { mergeRefs } from "@heroui/react-utils";
import { useSafeLayoutEffect } from "@heroui/use-safe-layout-effect";
import { useHover } from "@react-aria/interactions";
import { toggle } from "@heroui/theme";
import { chain, mergeProps } from "@react-aria/utils";
import { clsx, dataAttr, objectToDeps } from "@heroui/shared-utils";
import { useSwitch as useReactAriaSwitch } from "@react-aria/switch";
import { useMemo } from "react";
import { useToggleState } from "@react-stately/toggle";
import { useFocusRing } from "@react-aria/focus";
function useSwitch(originalProps = {}) {
  var _a, _b;
  const globalContext = useProviderContext();
  const [props, variantProps] = mapPropsVariants(originalProps, toggle.variantKeys);
  const {
    ref,
    as,
    name,
    value = "",
    isReadOnly: isReadOnlyProp = false,
    autoFocus = false,
    startContent,
    endContent,
    defaultSelected,
    isSelected: isSelectedProp,
    children,
    thumbIcon,
    className,
    classNames,
    onChange,
    onValueChange,
    ...otherProps
  } = props;
  const Component = as || "label";
  const domRef = useRef(null);
  const inputRef = useRef(null);
  const disableAnimation = (_b = (_a = originalProps.disableAnimation) != null ? _a : globalContext == null ? void 0 : globalContext.disableAnimation) != null ? _b : false;
  const labelId = useId();
  const ariaSwitchProps = useMemo(() => {
    const ariaLabel = otherProps["aria-label"] || typeof children === "string" ? children : void 0;
    return {
      name,
      value,
      children,
      autoFocus,
      defaultSelected,
      isSelected: isSelectedProp,
      isDisabled: !!originalProps.isDisabled,
      isReadOnly: isReadOnlyProp,
      "aria-label": ariaLabel,
      "aria-labelledby": otherProps["aria-labelledby"] || labelId,
      onChange: onValueChange
    };
  }, [
    value,
    name,
    labelId,
    children,
    autoFocus,
    isReadOnlyProp,
    isSelectedProp,
    defaultSelected,
    originalProps.isDisabled,
    otherProps["aria-label"],
    otherProps["aria-labelledby"],
    onValueChange
  ]);
  const state = useToggleState(ariaSwitchProps);
  useSafeLayoutEffect(() => {
    if (!inputRef.current) return;
    const isInputRefChecked = !!inputRef.current.checked;
    state.setSelected(isInputRefChecked);
  }, [inputRef.current]);
  const { inputProps, isPressed, isReadOnly } = useReactAriaSwitch(ariaSwitchProps, state, inputRef);
  const { focusProps, isFocused, isFocusVisible } = useFocusRing({ autoFocus: inputProps.autoFocus });
  const { hoverProps, isHovered } = useHover({
    isDisabled: inputProps.disabled
  });
  const isInteractionDisabled = ariaSwitchProps.isDisabled || isReadOnly;
  const pressed = isInteractionDisabled ? false : isPressed;
  const isSelected = inputProps.checked;
  const isDisabled = inputProps.disabled;
  const slots = useMemo(
    () => toggle({
      ...variantProps,
      disableAnimation
    }),
    [objectToDeps(variantProps), disableAnimation]
  );
  const baseStyles = clsx(classNames == null ? void 0 : classNames.base, className);
  const getBaseProps = (props2) => {
    return {
      ...mergeProps(hoverProps, otherProps, props2),
      ref: domRef,
      className: slots.base({ class: clsx(baseStyles, props2 == null ? void 0 : props2.className) }),
      "data-disabled": dataAttr(isDisabled),
      "data-selected": dataAttr(isSelected),
      "data-readonly": dataAttr(isReadOnly),
      "data-focus": dataAttr(isFocused),
      "data-focus-visible": dataAttr(isFocusVisible),
      "data-hover": dataAttr(isHovered),
      "data-pressed": dataAttr(pressed)
    };
  };
  const getWrapperProps = useCallback(
    (props2 = {}) => {
      return {
        ...props2,
        "aria-hidden": true,
        className: clsx(slots.wrapper({ class: clsx(classNames == null ? void 0 : classNames.wrapper, props2 == null ? void 0 : props2.className) }))
      };
    },
    [slots, classNames == null ? void 0 : classNames.wrapper]
  );
  const getInputProps = (props2 = {}) => {
    return {
      ...mergeProps(inputProps, focusProps, props2),
      ref: mergeRefs(inputRef, ref),
      id: inputProps.id,
      className: slots.hiddenInput({ class: classNames == null ? void 0 : classNames.hiddenInput }),
      onChange: chain(onChange, inputProps.onChange)
    };
  };
  const getThumbProps = useCallback(
    (props2 = {}) => ({
      ...props2,
      className: slots.thumb({ class: clsx(classNames == null ? void 0 : classNames.thumb, props2 == null ? void 0 : props2.className) })
    }),
    [slots, classNames == null ? void 0 : classNames.thumb]
  );
  const getLabelProps = useCallback(
    (props2 = {}) => ({
      ...props2,
      id: labelId,
      className: slots.label({ class: clsx(classNames == null ? void 0 : classNames.label, props2 == null ? void 0 : props2.className) })
    }),
    [slots, classNames == null ? void 0 : classNames.label, isDisabled, isSelected]
  );
  const getThumbIconProps = useCallback(
    (props2 = {
      includeStateProps: false
    }) => mergeProps(
      {
        width: "1em",
        height: "1em",
        className: slots.thumbIcon({ class: clsx(classNames == null ? void 0 : classNames.thumbIcon) })
      },
      props2.includeStateProps ? {
        isSelected
      } : {}
    ),
    [slots, classNames == null ? void 0 : classNames.thumbIcon, isSelected]
  );
  const getStartContentProps = useCallback(
    (props2 = {}) => ({
      width: "1em",
      height: "1em",
      ...props2,
      className: slots.startContent({ class: clsx(classNames == null ? void 0 : classNames.startContent, props2 == null ? void 0 : props2.className) })
    }),
    [slots, classNames == null ? void 0 : classNames.startContent, isSelected]
  );
  const getEndContentProps = useCallback(
    (props2 = {}) => ({
      width: "1em",
      height: "1em",
      ...props2,
      className: slots.endContent({ class: clsx(classNames == null ? void 0 : classNames.endContent, props2 == null ? void 0 : props2.className) })
    }),
    [slots, classNames == null ? void 0 : classNames.endContent, isSelected]
  );
  return {
    Component,
    slots,
    classNames,
    domRef,
    children,
    thumbIcon,
    startContent,
    endContent,
    isHovered,
    isSelected,
    isPressed: pressed,
    isFocused,
    isFocusVisible,
    isDisabled,
    getBaseProps,
    getWrapperProps,
    getInputProps,
    getLabelProps,
    getThumbProps,
    getThumbIconProps,
    getStartContentProps,
    getEndContentProps
  };
}

export {
  useSwitch
};
