import * as react from 'react';
import { Ref } from 'react';
import { PropGetter, HTMLHeroUIProps } from '@heroui/system';
import { LinkDOMProps, PressEvent } from '@react-types/shared';
import { PaginationItemValue } from '@heroui/use-pagination';

interface Props extends Omit<HTMLHeroUIProps<"li">, "onClick"> {
    /**
     * Ref to the DOM node.
     */
    ref?: Ref<HTMLElement>;
    /**
     * Value of the item.
     */
    value?: PaginationItemValue;
    /**
     * Whether the item is active.
     * @default false
     */
    isActive?: boolean;
    /**
     * Whether the item is disabled.
     * @default false
     */
    isDisabled?: boolean;
    /**
     * Callback fired when the item is clicked.
     * @param e MouseEvent
     * @deprecated Use `onPress` instead.
     */
    onClick?: HTMLHeroUIProps<"li">["onClick"];
    /**
     * Callback fired when the item is clicked.
     * @param e PressEvent
     */
    onPress?: (e: PressEvent) => void;
    /**
     * Function to get the aria-label of the item.
     */
    getAriaLabel?: (page?: PaginationItemValue) => string | undefined;
}
type UsePaginationItemProps = Props & LinkDOMProps;
declare function usePaginationItem(props: UsePaginationItemProps): {
    Component: string;
    children: react.ReactNode;
    ariaLabel: string | undefined;
    isFocused: boolean;
    isFocusVisible: boolean;
    getItemProps: PropGetter;
};
type UsePaginationItemReturn = ReturnType<typeof usePaginationItem>;

export { type UsePaginationItemProps, type UsePaginationItemReturn, usePaginationItem };
