"use client";
import {
  date_range_picker_field_default
} from "./chunk-ZKYK7FU7.mjs";
import {
  useDateRangePicker
} from "./chunk-RDN44QR7.mjs";

// src/date-range-picker.tsx
import { useMemo } from "react";
import { cloneElement, isValidElement } from "react";
import { forwardRef } from "@heroui/system";
import { Button } from "@heroui/button";
import { TimeInput, DateInputGroup } from "@heroui/date-input";
import { FreeSoloPopover } from "@heroui/popover";
import { RangeCalendar } from "@heroui/calendar";
import { AnimatePresence } from "framer-motion";
import { CalendarBoldIcon } from "@heroui/shared-icons";
import { Fragment, jsx, jsxs } from "react/jsx-runtime";
var DateRangePicker = forwardRef(function DateRangePicker2(props, ref) {
  const { selectorButtonPlacement = "end", ...otherProps } = props;
  const {
    state,
    slots,
    startContent,
    endContent,
    selectorIcon,
    showTimeField,
    classNames,
    disableAnimation,
    isCalendarHeaderExpanded,
    getDateInputGroupProps,
    getStartDateInputProps,
    getEndDateInputProps,
    getPopoverProps,
    getSeparatorProps,
    getStartTimeInputProps,
    getEndTimeInputProps,
    getSelectorButtonProps,
    getSelectorIconProps,
    getCalendarProps,
    CalendarTopContent,
    CalendarBottomContent
  } = useDateRangePicker({ ...otherProps, ref });
  const selectorContent = isValidElement(selectorIcon) ? cloneElement(selectorIcon, getSelectorIconProps()) : /* @__PURE__ */ jsx(CalendarBoldIcon, { ...getSelectorIconProps() });
  const calendarBottomContent = useMemo(() => {
    if (isCalendarHeaderExpanded) return null;
    return showTimeField ? /* @__PURE__ */ jsxs("div", { className: slots == null ? void 0 : slots.bottomContent({ class: classNames == null ? void 0 : classNames.bottomContent }), children: [
      /* @__PURE__ */ jsxs("div", { className: slots == null ? void 0 : slots.timeInputWrapper({ class: classNames == null ? void 0 : classNames.timeInputWrapper }), children: [
        /* @__PURE__ */ jsx(TimeInput, { ...getStartTimeInputProps() }),
        /* @__PURE__ */ jsx(TimeInput, { ...getEndTimeInputProps() })
      ] }),
      CalendarBottomContent
    ] }) : CalendarBottomContent;
  }, [state, showTimeField, CalendarBottomContent, isCalendarHeaderExpanded]);
  const calendarTopContent = useMemo(() => {
    if (isCalendarHeaderExpanded) return null;
    return CalendarTopContent;
  }, [showTimeField, CalendarTopContent, isCalendarHeaderExpanded]);
  const popoverContent = state.isOpen ? /* @__PURE__ */ jsx(FreeSoloPopover, { ...getPopoverProps(), offset: 20, children: /* @__PURE__ */ jsx(
    RangeCalendar,
    {
      ...getCalendarProps(),
      bottomContent: calendarBottomContent,
      topContent: calendarTopContent
    }
  ) }) : null;
  const dateInputGroupProps = {
    ...getDateInputGroupProps(),
    endContent: selectorButtonPlacement === "end" ? /* @__PURE__ */ jsx(Button, { ...getSelectorButtonProps(), children: endContent || selectorContent }) : endContent,
    startContent: selectorButtonPlacement === "start" ? /* @__PURE__ */ jsx(Button, { ...getSelectorButtonProps(), children: startContent || selectorContent }) : startContent
  };
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsxs(DateInputGroup, { ...dateInputGroupProps, children: [
      /* @__PURE__ */ jsx(date_range_picker_field_default, { ...getStartDateInputProps() }),
      /* @__PURE__ */ jsx("span", { ...getSeparatorProps(), "aria-hidden": "true", role: "separator", children: "-" }),
      /* @__PURE__ */ jsx(date_range_picker_field_default, { ...getEndDateInputProps() })
    ] }),
    disableAnimation ? popoverContent : /* @__PURE__ */ jsx(AnimatePresence, { children: popoverContent })
  ] });
});
var date_range_picker_default = DateRangePicker;

export {
  date_range_picker_default
};
