"use client";
import {
  ChevronLeftIcon
} from "./chunk-HUKPVIZ5.mjs";
import {
  ChevronRightIcon
} from "./chunk-MUYVZHWM.mjs";
import {
  CalendarHeader
} from "./chunk-OLO3H5VL.mjs";
import {
  CalendarMonth
} from "./chunk-MO5QQVL3.mjs";
import {
  CalendarPicker
} from "./chunk-BIG4XZOE.mjs";
import {
  useCalendarContext
} from "./chunk-PEV3D27N.mjs";
import {
  transition
} from "./chunk-5CY7DCRB.mjs";

// src/calendar-base.tsx
import { forwardRef, Fragment, useState } from "react";
import { VisuallyHidden } from "@react-aria/visually-hidden";
import { Button } from "@heroui/button";
import { chain, mergeProps } from "@react-aria/utils";
import { AnimatePresence, LazyMotion, MotionConfig } from "framer-motion";
import { useLocale } from "@react-aria/i18n";
import { ResizablePanel } from "@heroui/framer-utils";
import { Fragment as Fragment2, jsx, jsxs } from "react/jsx-runtime";
import { createElement } from "react";
var domAnimation = () => import("@heroui/dom-animation").then((res) => res.default);
var PopLayoutWrapper = forwardRef(
  (props, ref) => {
    return /* @__PURE__ */ jsx("div", { ref, ...props });
  }
);
PopLayoutWrapper.displayName = "HeroUI - PopLayoutWrapper";
function CalendarBase(props) {
  const {
    Component = "div",
    showHelper,
    topContent,
    bottomContent,
    calendarProps,
    nextButtonProps,
    prevButtonProps,
    buttonPickerProps,
    errorMessageProps,
    calendarRef: ref,
    errorMessage,
    firstDayOfWeek,
    ...otherProps
  } = props;
  const { state, slots, visibleMonths, showMonthAndYearPickers, disableAnimation, classNames } = useCalendarContext();
  const [direction, setDirection] = useState(0);
  const { direction: localeDirection } = useLocale();
  const currentMonth = state.visibleRange.start;
  const headers = [];
  const calendars = [];
  const isRTL = localeDirection === "rtl";
  for (let i = 0; i < visibleMonths; i++) {
    let d = currentMonth.add({ months: i });
    headers.push(
      /* @__PURE__ */ jsxs(Fragment, { children: [
        i === 0 && /* @__PURE__ */ jsx(
          Button,
          {
            ...isRTL ? nextButtonProps : prevButtonProps,
            onPress: chain(
              isRTL ? nextButtonProps.onPress : prevButtonProps.onPress,
              () => setDirection(-1)
            ),
            children: /* @__PURE__ */ jsx(ChevronLeftIcon, {})
          }
        ),
        /* @__PURE__ */ jsx(
          CalendarHeader,
          {
            buttonPickerProps,
            currentMonth,
            date: d,
            direction
          }
        ),
        i === visibleMonths - 1 && /* @__PURE__ */ jsx(
          Button,
          {
            ...isRTL ? prevButtonProps : nextButtonProps,
            onPress: chain(
              isRTL ? prevButtonProps.onPress : nextButtonProps.onPress,
              () => setDirection(1)
            ),
            children: /* @__PURE__ */ jsx(ChevronRightIcon, {})
          }
        )
      ] }, `calendar-header-${i}`)
    );
    const calendarMonthContent = /* @__PURE__ */ createElement(
      CalendarMonth,
      {
        ...props,
        key: `calendar-month-${i}`,
        currentMonth: currentMonth.month,
        direction,
        firstDayOfWeek,
        startDate: d
      }
    );
    calendars.push(
      showMonthAndYearPickers ? /* @__PURE__ */ jsxs(Fragment, { children: [
        calendarMonthContent,
        /* @__PURE__ */ jsx(CalendarPicker, { currentMonth, date: d })
      ] }, `calendar-month-with-pickers-${i}`) : calendarMonthContent
    );
  }
  const calendarContent = /* @__PURE__ */ jsxs(Fragment2, { children: [
    /* @__PURE__ */ jsx(
      "div",
      {
        className: slots == null ? void 0 : slots.headerWrapper({ class: classNames == null ? void 0 : classNames.headerWrapper }),
        "data-slot": "header-wrapper",
        children: headers
      },
      "header-wrapper"
    ),
    /* @__PURE__ */ jsx(
      "div",
      {
        className: slots == null ? void 0 : slots.gridWrapper({ class: classNames == null ? void 0 : classNames.gridWrapper }),
        "data-slot": "grid-wrapper",
        children: calendars
      },
      "grid-wrapper"
    )
  ] });
  return /* @__PURE__ */ jsxs(Component, { ...mergeProps(calendarProps, otherProps), ref, children: [
    topContent,
    /* @__PURE__ */ jsx(VisuallyHidden, { children: /* @__PURE__ */ jsx("h2", { children: calendarProps["aria-label"] }) }),
    disableAnimation ? /* @__PURE__ */ jsx("div", { className: slots == null ? void 0 : slots.content({ class: classNames == null ? void 0 : classNames.content }), "data-slot": "content", children: calendarContent }) : /* @__PURE__ */ jsx(
      ResizablePanel,
      {
        className: slots == null ? void 0 : slots.content({ class: classNames == null ? void 0 : classNames.content }),
        "data-slot": "content",
        children: /* @__PURE__ */ jsx(AnimatePresence, { custom: direction, initial: false, mode: "popLayout", children: /* @__PURE__ */ jsx(PopLayoutWrapper, { children: /* @__PURE__ */ jsx(MotionConfig, { transition, children: /* @__PURE__ */ jsx(LazyMotion, { features: domAnimation, children: calendarContent }) }) }) })
      }
    ),
    /* @__PURE__ */ jsx(VisuallyHidden, { children: /* @__PURE__ */ jsx(
      "button",
      {
        "aria-label": nextButtonProps["aria-label"],
        disabled: nextButtonProps.isDisabled,
        tabIndex: -1,
        onClick: () => state.focusNextPage()
      }
    ) }),
    state.isValueInvalid && showHelper && /* @__PURE__ */ jsx(
      "div",
      {
        className: slots == null ? void 0 : slots.helperWrapper({ class: classNames == null ? void 0 : classNames.helperWrapper }),
        "data-slot": "helper-wrapper",
        children: /* @__PURE__ */ jsx(
          "span",
          {
            ...errorMessageProps,
            className: slots == null ? void 0 : slots.errorMessage({ class: classNames == null ? void 0 : classNames.errorMessage }),
            "data-slot": "error-message",
            children: errorMessage || "Selected date unavailable."
          }
        )
      }
    ),
    bottomContent
  ] });
}

export {
  CalendarBase
};
