"use client";
import {
  useButton
} from "./chunk-AJAU6WEQ.mjs";

// src/button.tsx
import { Spinner } from "@heroui/spinner";
import { Ripple } from "@heroui/ripple";
import { forwardRef } from "@heroui/system";
import { jsx, jsxs } from "react/jsx-runtime";
var Button = forwardRef((props, ref) => {
  const {
    Component,
    domRef,
    children,
    spinnerSize,
    spinner = /* @__PURE__ */ jsx(Spinner, { color: "current", size: spinnerSize }),
    spinnerPlacement,
    startContent,
    endContent,
    isLoading,
    disableRipple,
    getButtonProps,
    getRippleProps,
    isIconOnly
  } = useButton({ ...props, ref });
  return /* @__PURE__ */ jsxs(Component, { ref: domRef, ...getButtonProps(), children: [
    startContent,
    isLoading && spinnerPlacement === "start" && spinner,
    isLoading && isIconOnly ? null : children,
    isLoading && spinnerPlacement === "end" && spinner,
    endContent,
    !disableRipple && /* @__PURE__ */ jsx(Ripple, { ...getRippleProps() })
  ] });
});
Button.displayName = "HeroUI.Button";
var button_default = Button;

export {
  button_default
};
