"use client";
"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var index_exports = {};
__export(index_exports, {
  Avatar: () => avatar_default,
  AvatarGroup: () => avatar_group_default,
  AvatarGroupProvider: () => AvatarGroupProvider,
  AvatarIcon: () => AvatarIcon,
  useAvatar: () => useAvatar,
  useAvatarGroup: () => useAvatarGroup,
  useAvatarGroupContext: () => useAvatarGroupContext
});
module.exports = __toCommonJS(index_exports);

// src/avatar.tsx
var import_react2 = require("react");
var import_system2 = require("@heroui/system");

// src/avatar-icon.tsx
var import_jsx_runtime = require("react/jsx-runtime");
var AvatarIcon = () => /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(
  "svg",
  {
    "aria-hidden": "true",
    fill: "none",
    height: "80%",
    role: "presentation",
    viewBox: "0 0 24 24",
    width: "80%",
    children: [
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
        "path",
        {
          d: "M12 2C9.38 2 7.25 4.13 7.25 6.75C7.25 9.32 9.26 11.4 11.88 11.49C11.96 11.48 12.04 11.48 12.1 11.49C12.12 11.49 12.13 11.49 12.15 11.49C12.16 11.49 12.16 11.49 12.17 11.49C14.73 11.4 16.74 9.32 16.75 6.75C16.75 4.13 14.62 2 12 2Z",
          fill: "currentColor"
        }
      ),
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
        "path",
        {
          d: "M17.0809 14.1489C14.2909 12.2889 9.74094 12.2889 6.93094 14.1489C5.66094 14.9989 4.96094 16.1489 4.96094 17.3789C4.96094 18.6089 5.66094 19.7489 6.92094 20.5889C8.32094 21.5289 10.1609 21.9989 12.0009 21.9989C13.8409 21.9989 15.6809 21.5289 17.0809 20.5889C18.3409 19.7389 19.0409 18.5989 19.0409 17.3589C19.0309 16.1289 18.3409 14.9889 17.0809 14.1489Z",
          fill: "currentColor"
        }
      )
    ]
  }
);

// src/use-avatar.ts
var import_theme = require("@heroui/theme");
var import_system = require("@heroui/system");
var import_utils = require("@react-aria/utils");
var import_react_utils2 = require("@heroui/react-utils");
var import_shared_utils = require("@heroui/shared-utils");
var import_focus = require("@react-aria/focus");
var import_react = require("react");
var import_use_image = require("@heroui/use-image");
var import_interactions = require("@react-aria/interactions");

// src/avatar-group-context.ts
var import_react_utils = require("@heroui/react-utils");
var [AvatarGroupProvider, useAvatarGroupContext] = (0, import_react_utils.createContext)({
  name: "AvatarGroupContext",
  strict: false
});

// src/use-avatar.ts
function useAvatar(originalProps = {}) {
  var _a, _b, _c, _d, _e, _f;
  const globalContext = (0, import_system.useProviderContext)();
  const groupContext = useAvatarGroupContext();
  const isInGroup = !!groupContext;
  const {
    as,
    ref,
    src,
    name,
    icon,
    classNames,
    fallback,
    alt = name || "avatar",
    imgRef: imgRefProp,
    color = (_a = groupContext == null ? void 0 : groupContext.color) != null ? _a : "default",
    radius = (_b = groupContext == null ? void 0 : groupContext.radius) != null ? _b : "full",
    size = (_c = groupContext == null ? void 0 : groupContext.size) != null ? _c : "md",
    isBordered = (_d = groupContext == null ? void 0 : groupContext.isBordered) != null ? _d : false,
    isDisabled = (_e = groupContext == null ? void 0 : groupContext.isDisabled) != null ? _e : false,
    isFocusable = false,
    getInitials = import_shared_utils.safeText,
    ignoreFallback = false,
    showFallback: showFallbackProp = false,
    ImgComponent = "img",
    imgProps,
    className,
    onError,
    disableAnimation: disableAnimationProp,
    ...otherProps
  } = originalProps;
  const Component = as || "span";
  const domRef = (0, import_react_utils2.useDOMRef)(ref);
  const imgRef = (0, import_react_utils2.useDOMRef)(imgRefProp);
  const { isFocusVisible, isFocused, focusProps } = (0, import_focus.useFocusRing)();
  const { isHovered, hoverProps } = (0, import_interactions.useHover)({ isDisabled });
  const disableAnimation = (_f = disableAnimationProp != null ? disableAnimationProp : globalContext == null ? void 0 : globalContext.disableAnimation) != null ? _f : false;
  const imageStatus = (0, import_use_image.useImage)({ src, onError, ignoreFallback });
  const isImgLoaded = imageStatus === "loaded";
  const shouldFilterDOMProps = typeof ImgComponent === "string";
  const showFallback = (!src || !isImgLoaded) && showFallbackProp;
  const slots = (0, import_react.useMemo)(
    () => {
      var _a2;
      return (0, import_theme.avatar)({
        color,
        radius,
        size,
        isBordered,
        isDisabled,
        isInGroup,
        disableAnimation,
        isInGridGroup: (_a2 = groupContext == null ? void 0 : groupContext.isGrid) != null ? _a2 : false
      });
    },
    [
      color,
      radius,
      size,
      isBordered,
      isDisabled,
      disableAnimation,
      isInGroup,
      groupContext == null ? void 0 : groupContext.isGrid
    ]
  );
  const baseStyles = (0, import_shared_utils.clsx)(classNames == null ? void 0 : classNames.base, className);
  const canBeFocused = (0, import_react.useMemo)(() => {
    return isFocusable || as === "button";
  }, [isFocusable, as]);
  const getAvatarProps = (0, import_react.useCallback)(
    (props = {}) => ({
      ref: domRef,
      tabIndex: canBeFocused ? 0 : -1,
      "data-hover": (0, import_shared_utils.dataAttr)(isHovered),
      "data-focus": (0, import_shared_utils.dataAttr)(isFocused),
      "data-focus-visible": (0, import_shared_utils.dataAttr)(isFocusVisible),
      className: slots.base({
        class: (0, import_shared_utils.clsx)(baseStyles, props == null ? void 0 : props.className)
      }),
      ...(0, import_utils.mergeProps)(otherProps, hoverProps, canBeFocused ? focusProps : {})
    }),
    [canBeFocused, slots, baseStyles, focusProps, otherProps]
  );
  const getImageProps = (0, import_react.useCallback)(
    (props = {}) => ({
      ref: imgRef,
      src,
      "data-loaded": (0, import_shared_utils.dataAttr)(isImgLoaded),
      className: slots.img({ class: classNames == null ? void 0 : classNames.img }),
      ...(0, import_utils.mergeProps)(
        imgProps,
        props,
        (0, import_react_utils2.filterDOMProps)({ disableAnimation }, {
          enabled: shouldFilterDOMProps
        })
      )
    }),
    [slots, isImgLoaded, imgProps, disableAnimation, src, imgRef, shouldFilterDOMProps]
  );
  return {
    Component,
    ImgComponent,
    src,
    alt,
    icon,
    name,
    imgRef,
    slots,
    classNames,
    fallback,
    isImgLoaded,
    showFallback,
    ignoreFallback,
    getInitials,
    getAvatarProps,
    getImageProps
  };
}

// src/avatar.tsx
var import_jsx_runtime2 = require("react/jsx-runtime");
var Avatar = (0, import_system2.forwardRef)((props, ref) => {
  const {
    Component,
    ImgComponent,
    src,
    icon = /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(AvatarIcon, {}),
    alt,
    classNames,
    slots,
    name,
    showFallback,
    fallback: fallbackComponent,
    getInitials,
    getAvatarProps,
    getImageProps
  } = useAvatar({
    ...props,
    ref
  });
  const fallback = (0, import_react2.useMemo)(() => {
    if (!showFallback && src) return null;
    if (fallbackComponent) {
      return /* @__PURE__ */ (0, import_jsx_runtime2.jsx)("div", { "aria-label": alt, className: slots.fallback({ class: classNames == null ? void 0 : classNames.fallback }), role: "img", children: fallbackComponent });
    }
    return name ? /* @__PURE__ */ (0, import_jsx_runtime2.jsx)("span", { "aria-label": alt, className: slots.name({ class: classNames == null ? void 0 : classNames.name }), role: "img", children: getInitials(name) }) : /* @__PURE__ */ (0, import_jsx_runtime2.jsx)("span", { "aria-label": alt, className: slots.icon({ class: classNames == null ? void 0 : classNames.icon }), role: "img", children: icon });
  }, [showFallback, src, fallbackComponent, name, classNames]);
  return /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)(Component, { ...getAvatarProps(), children: [
    src && /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(ImgComponent, { ...getImageProps(), alt }),
    fallback
  ] });
});
Avatar.displayName = "HeroUI.Avatar";
var avatar_default = Avatar;

// src/avatar-group.tsx
var import_system3 = require("@heroui/system");

// src/use-avatar-group.ts
var import_theme2 = require("@heroui/theme");
var import_react_utils3 = require("@heroui/react-utils");
var import_shared_utils2 = require("@heroui/shared-utils");
var import_react_utils4 = require("@heroui/react-utils");
var import_react3 = require("react");
function useAvatarGroup(props = {}) {
  const {
    as,
    ref,
    max = 5,
    total,
    size,
    color,
    radius,
    children,
    isBordered,
    isDisabled,
    isGrid,
    renderCount,
    className,
    classNames,
    ...otherProps
  } = props;
  const domRef = (0, import_react_utils3.useDOMRef)(ref);
  const Component = as || "div";
  const context = (0, import_react3.useMemo)(
    () => ({
      size,
      color,
      radius,
      isGrid,
      isBordered,
      isDisabled
    }),
    [size, color, radius, isGrid, isBordered, isDisabled]
  );
  const slots = (0, import_react3.useMemo)(() => (0, import_theme2.avatarGroup)({ className, isGrid }), [className, isGrid]);
  const validChildren = (0, import_react_utils4.getValidChildren)(children);
  const childrenWithinMax = max ? validChildren.slice(0, max) : validChildren;
  const remainingCount = total ? total : max != null ? validChildren.length - max : -1;
  const clones = childrenWithinMax.map((child, index) => {
    const isFirstAvatar = index === 0;
    const isLastAvatar = index === childrenWithinMax.length - 1;
    const childProps = {
      className: (0, import_shared_utils2.clsx)(
        isFirstAvatar ? "ms-0" : !isGrid ? "-ms-2" : "",
        isLastAvatar && remainingCount < 1 ? "hover:-translate-x-0" : ""
      )
    };
    return (0, import_react3.cloneElement)(child, (0, import_shared_utils2.compact)(childProps));
  });
  const getAvatarGroupProps = () => {
    return {
      ref: domRef,
      className: slots.base({
        class: (0, import_shared_utils2.clsx)(classNames == null ? void 0 : classNames.base, className)
      }),
      role: "group",
      ...otherProps
    };
  };
  const getAvatarGroupCountProps = () => {
    return {
      className: slots.count({
        class: classNames == null ? void 0 : classNames.count
      })
    };
  };
  return {
    Component,
    context,
    remainingCount,
    clones,
    renderCount,
    getAvatarGroupProps,
    getAvatarGroupCountProps
  };
}

// src/avatar-group.tsx
var import_jsx_runtime3 = require("react/jsx-runtime");
var AvatarGroup = (0, import_system3.forwardRef)((props, ref) => {
  const {
    Component,
    clones,
    context,
    remainingCount,
    getAvatarGroupCountProps,
    getAvatarGroupProps,
    renderCount = (count) => /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(avatar_default, { ...getAvatarGroupCountProps(), name: `+${count}` })
  } = useAvatarGroup({
    ...props,
    ref
  });
  return /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(Component, { ...getAvatarGroupProps(), children: /* @__PURE__ */ (0, import_jsx_runtime3.jsxs)(AvatarGroupProvider, { value: context, children: [
    clones,
    remainingCount > 0 && renderCount(remainingCount)
  ] }) });
});
AvatarGroup.displayName = "HeroUI.AvatarGroup";
var avatar_group_default = AvatarGroup;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  Avatar,
  AvatarGroup,
  AvatarGroupProvider,
  AvatarIcon,
  useAvatar,
  useAvatarGroup,
  useAvatarGroupContext
});
