<!DOCTYPE html>
<html lang="nl" class="h-full">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Header - Imators</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');

        :root {
            --primary-color: #3B82F6;
            --secondary-color: #10B981;
        }

        body {
            font-family: 'Inter', sans-serif;
            color: #FFFFFF;
            background-color: #111827;
        }

        .header {
            background-color: rgba(0, 0, 0, 0.8);
            backdrop-filter: blur(10px);
            transition: all 0.3s ease;
            z-index: 1002;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.3);
        }

        .desktop-menu {
            display: none;
        }

        @media (min-width: 1024px) {
            .desktop-menu {
                display: flex;
            }

            .hamburger {
                display: none;
            }

            .desktop-menu-item {
                position: relative;
                padding: 1rem;
                cursor: pointer;
                color: #FFFFFF;
                font-weight: 500;
            }

            .desktop-submenu {
                position: absolute;
                top: 100%;
                left: 0;
                background-color: #1a1a1a;
                min-width: 200px;
                border-radius: 8px;
                box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
                opacity: 0;
                visibility: hidden;
                transform: translateY(10px);
                transition: all 0.3s ease;
            }

            .desktop-menu-item:hover .desktop-submenu {
                opacity: 1;
                visibility: visible;
                transform: translateY(0);
            }

            .desktop-submenu a {
                display: block;
                padding: 0.75rem 1rem;
                color: #FFFFFF;
                transition: all 0.2s ease;
            }

            .desktop-submenu a:hover {
                background-color: rgba(255, 255, 255, 0.1);
                transform: translateX(5px);
            }
        }

        .hamburger {
            width: 30px;
            height: 20px;
            position: relative;
            cursor: pointer;
            z-index: 1003;
        }

        .hamburger span {
            display: block;
            position: absolute;
            height: 3px;
            width: 100%;
            background: #FFFFFF;
            border-radius: 9px;
            opacity: 1;
            left: 0;
            transform: rotate(0deg);
            transition: .25s ease-in-out;
        }

        .hamburger span:nth-child(1) {
            top: 0px;
        }

        .hamburger span:nth-child(2) {
            top: 10px;
        }

        .hamburger.open span:nth-child(1) {
            top: 10px;
            transform: rotate(135deg);
        }

        .hamburger.open span:nth-child(2) {
            top: 10px;
            transform: rotate(-135deg);
        }

        .menu {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.95);
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease-in-out;
            z-index: 1001;
            padding-top: 64px;
        }

        .menu.active {
            opacity: 1;
            visibility: visible;
        }

        .menu-item {
            margin: 10px 0;
            font-size: 28px;
            cursor: pointer;
            color: #FFFFFF;
            transition: all 0.3s ease;
            position: relative;
        }

        .menu-item:hover {
            color: var(--primary-color);
        }

        .menu-item::after {
            content: '';
            position: absolute;
            width: 0;
            height: 2px;
            bottom: -5px;
            left: 50%;
            background-color: var(--primary-color);
            transition: all 0.3s ease;
        }

        .menu-item:hover::after {
            width: 100%;
            left: 0;
        }

        .submenu {
            max-height: 0;
            overflow: hidden;
            transition: max-height 0.5s cubic-bezier(0, 1, 0, 1);
            opacity: 0;
        }

        .submenu.active {
            max-height: 1000px;
            transition: max-height 1s ease-in-out, opacity 0.5s ease-in-out;
            opacity: 1;
        }

        .submenu a {
            display: block;
            padding: 8px 0;
            font-size: 20px;
            color: #FFFFFF;
            text-decoration: none;
            transition: all 0.3s ease;
            opacity: 0;
            transform: translateY(20px);
        }

        .submenu.active a {
            opacity: 1;
            transform: translateY(0);
            transition: opacity 0.5s ease-in-out, transform 0.5s ease-in-out;
        }

        .submenu a:hover {
            color: var(--primary-color);
            transform: translateX(5px);
        }

        .dropdown {
            position: relative;
        }

        .dropdown-content {
            display: none;
            position: absolute;
            right: 0;
            background-color: #1a1a1a;
            min-width: 160px;
            box-shadow: 0px 8px 16px rgba(0, 0, 0, 0.2);
            z-index: 1;
            border-radius: 8px;
            overflow: hidden;
        }

        .dropdown:hover .dropdown-content {
            display: block;
        }

        .dropdown-content a {
            color: #fff;
            padding: 12px 16px;
            text-decoration: none;
            display: block;
            transition: all 0.3s ease;
        }

        .dropdown-content a:hover {
            background-color: #575757;
            transform: translateX(5px);
        }

        html {
            scroll-behavior: smooth;
        }
    </style>
</head>
<body class="h-full">
<header class="header fixed w-full top-0">
    <nav class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between items-center h-20">
            <div class="flex-shrink-0 flex items-center">
                <a href="/nl/" class="flex items-center">
                     <img src="https://cdn.imators.com/logo.png" alt="Logo Peerkinton" class="h-6 w-auto md:h-8">
                </a>
            </div>

            <div class="desktop-menu items-center space-x-6 hidden lg:flex">
                <div class="desktop-menu-item">
                    Producten
                    <div class="desktop-submenu">
                        <a href="/nl/progm">Progm</a>
                        <a href="https://ohmypanel.com">OhMyPanel</a>
                        <a href="https://owtiftt.com">Owtfitt</a>
                        <a href="https://formore.tv">ForMore</a>
                        <a href="https://gemance.com">Gemance</a>
                    </div>
                </div>
                <div class="desktop-menu-item">
                    Ontwikkelaarshulpmiddelen
                    <div class="desktop-submenu">
                        <a href="https://imators.systems">Imators Systemen</a>
                        <a href="https://developer.imators.com">Imators Ontwikkelaar</a>
                    </div>
                </div>
                <div class="desktop-menu-item">
                    Bedrijf
                    <div class="desktop-submenu">
                        <a href="/nl/about-us">Over Imators</a>
                        <a href="/nl/contact-us">Klantenondersteuning</a>
                    </div>
                </div>
            </div>

            <div class="flex items-center space-x-4">
                <a href="https://idsma.imators.com" class="bg-gradient-to-r from-primary-color to-secondary-color text-white px-6 py-3 rounded-full text-sm font-medium transition-all duration-300 ease-in-out transform hover:scale-105 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary-color shadow-lg">
                    Imators Account
                </a>
                <div class="relative dropdown">
                    <button id="language-button" class="bg-white text-black text-sm px-4 py-2 rounded-full shadow hover:bg-gray-100 transition-all font-medium">
                        NL
                    </button>
                    <div class="dropdown-content">
                        <a href="/fr">Fran&ccedil;ais</a>
                        <a href="/nl">Nederlands</a>
                        <a href="/de">Deutsch</a>
                        <a href="/">English</a>
                    </div>
                </div>
                <button id="hamburger" class="hamburger lg:hidden" aria-label="Menu openen">
                    <span></span>
                    <span></span>
                </button>
            </div>
        </div>
    </nav>
</header>

<div id="menu" class="menu lg:hidden">
    <div class="menu-item" data-submenu="products">Producten</div>
    <div class="submenu" id="products">
        <a href="/nl/progm">Progm</a>
        <a href="https://ohmypanel.com">OhMyPanel</a>
        <a href="https://owtiftt.com">Owtfitt</a>
        <a href="https://formore.tv">ForMore</a>
        <a href="https://gemance.com">Gemance</a>
    </div>
    <div class="menu-item" data-submenu="dev-tools">Ontwikkelaarshulpmiddelen</div>
    <div class="submenu" id="dev-tools">
        <a href="https://imators.systems">Imators Systemen</a>
        <a href="https://developer.imators.com">Imators Ontwikkelaar</a>
    </div>
    <div class="menu-item" data-submenu="company">Bedrijf</div>
    <div class="submenu" id="company">
        <a href="/nl/about-us">Over Imators</a>
        <a href="/nl/contact-us">Klantenondersteuning</a>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const hamburger = document.getElementById('hamburger');
        const menu = document.getElementById('menu');
        const header = document.querySelector('.header');
        const menuItems = document.querySelectorAll('.menu-item');
        const submenus = document.querySelectorAll('.submenu');

        hamburger.addEventListener('click', function() {
            this.classList.toggle('open');
            menu.classList.toggle('active');
            document.body.style.overflow = menu.classList.contains('active') ? 'hidden' : '';
        });

        menuItems.forEach(item => {
            item.addEventListener('click', function() {
                const submenuId = this.getAttribute('data-submenu');
                const submenu = document.getElementById(submenuId);
                
                if (submenu.classList.contains('active')) {
                    submenu.classList.remove('active');
                    setTimeout(() => {
                        submenu.style.display = 'none';
                    }, 500);
                } else {
                    submenus.forEach(sub => {
                        if (sub !== submenu) {
                            sub.classList.remove('active');
                            setTimeout(() => {
                                sub.style.display = 'none';
                            }, 500);
                        }
                    });
                    submenu.style.display = 'block';
                    setTimeout(() => {
                        submenu.classList.add('active');
                    }, 10);
                }
            });
        });

        let lastScrollTop = 0;
        const scrollThreshold = 50;

        window.addEventListener('scroll', () => {
            const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
            
            if (scrollTop > 0) {
                header.style.backgroundColor = 'rgba(0, 0, 0, 0.9)';
            } else {
                header.style.backgroundColor = 'rgba(0, 0, 0, 0.8)';
            }

            if (Math.abs(scrollTop - lastScrollTop) > scrollThreshold) {
                if (scrollTop > lastScrollTop && scrollTop > header.offsetHeight) {
                    header.style.transform = 'translateY(-100%)';
                } else {
                    header.style.transform = 'translateY(0)';
                }
                lastScrollTop = scrollTop;
            }
        }, { passive: true });

        async function setLanguageButtonText() {
            try {
                const response = await fetch('https://ipinfo.io?token=5763340b2576b8');
                const data = await response.json();
                const country = data.country;

                const languageButton = document.getElementById('language-button');
                switch (country) {
                    case 'FR':
                        languageButton.innerText = 'FR';
                        break;
                    case 'BE':
                        languageButton.innerText = 'BE';
                        break;
                    case 'NL':
                        languageButton.innerText = 'NL';
                        break;
                    case 'DE':
                        languageButton.innerText = 'DE';
                        break;
                    default:
                        languageButton.innerText = 'EN';
                }
            } catch (error) {
                console.error('Fout bij het ophalen van locatiegegevens:', error);
            }
        }

        setLanguageButtonText();
    });
</script>
</body>
</html>