<?php
require_once 'db.php';

$titre = $_GET['titre'] ?? '';

if(empty($titre)) {
    header('Location: database-directory.php');
    exit;
}

$stmt = $pdo->prepare("SELECT * FROM dossiers WHERE titre = ?");
$stmt->execute([$titre]);
$dossier = $stmt->fetch(PDO::FETCH_ASSOC);

if(!$dossier) {
    header('Location: database-directory.php');
    exit;
}

$stmt_logs = $pdo->prepare("SELECT * FROM logs WHERE dossier_id = ? ORDER BY date_log DESC");
$stmt_logs->execute([$dossier['id']]);
$logs = $stmt_logs->fetchAll(PDO::FETCH_ASSOC);

$stmt_medias = $pdo->prepare("SELECT * FROM medias WHERE dossier_id = ?");
$stmt_medias->execute([$dossier['id']]);
$medias = $stmt_medias->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en-GB">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>The Lord Court - <?php echo htmlspecialchars($dossier['titre']); ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;700&family=Inter:wght@300;400;500&display=swap" rel="stylesheet">
    <style>
        .playfair {
            font-family: 'Playfair Display', serif;
        }
        .inter-light {
            font-family: 'Inter', sans-serif;
            font-weight: 300;
        }
        .inter-medium {
            font-family: 'Inter', sans-serif;
            font-weight: 500;
        }
    </style>
</head>
<body class="bg-white min-h-screen">
    <header class="bg-white/95 backdrop-blur-sm fixed top-0 left-0 right-0 z-50">
        <div class="max-w-5xl mx-auto px-6 py-8 flex justify-between items-center">
            <h1 class="playfair text-2xl tracking-wide text-black">THE LORD COURT</h1>
            <a href="database-directory.php" class="inter-light text-sm text-gray-500 hover:text-black transition-colors flex items-center">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                </svg>
                Back to cases
            </a>
        </div>
    </header>

    <main class="pt-32">
        <section class="max-w-4xl mx-auto px-6 py-20">
            <div class="text-center mb-16">
                <h2 class="playfair text-4xl mb-8 text-black leading-tight"><?php echo htmlspecialchars($dossier['titre']); ?></h2>
                
                <div class="grid md:grid-cols-2 gap-8 max-w-2xl mx-auto mb-12">
                    <div class="text-left">
                        <div class="mb-3">
                            <span class="inter-medium text-xs tracking-widest text-gray-400 block mb-1">OPENING DATE</span>
                            <span class="inter-light text-sm text-black"><?php echo date('d/m/Y', strtotime($dossier['date_ouverture'])); ?></span>
                        </div>
                        <?php if($dossier['date_fermeture']): ?>
                        <div class="mb-3">
                            <span class="inter-medium text-xs tracking-widest text-gray-400 block mb-1">CLOSING DATE</span>
                            <span class="inter-light text-sm text-black"><?php echo date('d/m/Y', strtotime($dossier['date_fermeture'])); ?></span>
                        </div>
                        <?php endif; ?>
                    </div>
                    <div class="text-left">
                        <div class="mb-3">
                            <span class="inter-medium text-xs tracking-widest text-gray-400 block mb-1">AFFECTED SECTORS</span>
                            <span class="inter-light text-sm text-black"><?php echo htmlspecialchars($dossier['secteurs']); ?></span>
                        </div>
                        <div class="mb-3">
                            <span class="inter-medium text-xs tracking-widest text-gray-400 block mb-1">STATUS</span>
                            <span class="inter-light text-sm text-black"><?php echo htmlspecialchars($dossier['statut']); ?></span>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="space-y-16">
                <div class="border border-gray-200 p-8">
                    <h3 class="playfair text-2xl mb-6 text-black text-center">Case Description</h3>
                    <p class="inter-light text-sm text-gray-600 leading-relaxed text-center max-w-3xl mx-auto">
                        <?php echo nl2br(htmlspecialchars($dossier['description'])); ?>
                    </p>
                </div>

                <?php if(!empty($medias)): ?>
                <div>
                    <h3 class="playfair text-2xl mb-8 text-black text-center">Associated Media</h3>
                    <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-6">
                        <?php foreach($medias as $media): ?>
                        <div class="border border-gray-200 p-4">
                            <?php if(strpos($media['type'], 'image') !== false): ?>
                            <img src="<?php echo htmlspecialchars($media['chemin']); ?>" alt="<?php echo htmlspecialchars($media['nom']); ?>" class="w-full h-32 object-cover mb-3">
                            <?php elseif(strpos($media['type'], 'video') !== false): ?>
                            <video controls class="w-full h-32 mb-3">
                                <source src="<?php echo htmlspecialchars($media['chemin']); ?>" type="<?php echo htmlspecialchars($media['type']); ?>">
                            </video>
                            <?php endif; ?>
                            <p class="inter-light text-xs text-gray-600 text-center"><?php echo htmlspecialchars($media['nom']); ?></p>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                <?php endif; ?>

                <?php if(!empty($logs)): ?>
                <div>
                    <h3 class="playfair text-2xl mb-8 text-black text-center">Case Logs</h3>
                    <div class="space-y-4 max-w-3xl mx-auto">
                        <?php foreach($logs as $log): ?>
                        <div class="border border-gray-200 p-6">
                            <div class="flex justify-between items-center mb-4">
                                <span class="inter-medium text-xs tracking-widest text-gray-400">
                                    <?php echo date('d/m/Y H:i', strtotime($log['date_log'])); ?>
                                </span>
                                <span class="px-3 py-1 bg-gray-100 inter-light text-xs text-gray-600">
                                    <?php echo htmlspecialchars($log['type']); ?>
                                </span>
                            </div>
                            <p class="inter-light text-sm text-gray-600 leading-relaxed">
                                <?php echo nl2br(htmlspecialchars($log['contenu'])); ?>
                            </p>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </section>
    </main>
</body>
</html>