<?php
require_once 'db.php';
session_start();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    ob_clean();
    header('Content-Type: application/json');
    
    try {
        switch ($_POST['action']) {
            case 'login':
                $code = trim($_POST['code']);
                
                if (empty($code)) {
                    echo json_encode(['error' => 'Code requis']);
                    exit;
                }
                
                $livreurs = db()->fetchAll("SELECT * FROM vr_livreurs WHERE actif = 1");
                $found = false;
                
                foreach ($livreurs as $livreur) {
                    if (password_verify($code, $livreur['code_acces'])) {
                        $_SESSION['livreur_id'] = $livreur['id'];
                        $_SESSION['livreur_nom'] = $livreur['prenom'] . ' ' . $livreur['nom'];
                        $found = true;
                        break;
                    }
                }
                
                if ($found) {
                    echo json_encode(['success' => true]);
                } else {
                    echo json_encode(['error' => 'Code d\'accès invalide']);
                }
                exit;
                
            case 'get_orders':
                if (!isset($_SESSION['livreur_id'])) {
                    echo json_encode(['error' => 'Non connecté']);
                    exit;
                }
                
                $available = db()->fetchAll("
                    SELECT c.*, co.nom as commerce_nom, r.first_name, r.last_name
                    FROM vr_commandes c 
                    JOIN vr_commerces co ON c.commerce_id = co.id 
                    JOIN residents r ON c.resident_id = r.id 
                    WHERE c.statut = 'en_attente' AND c.livreur_id IS NULL
                    ORDER BY c.date_commande ASC
                ");
                
                $mine = db()->fetchAll("
                    SELECT c.*, co.nom as commerce_nom, r.first_name, r.last_name
                    FROM vr_commandes c 
                    JOIN vr_commerces co ON c.commerce_id = co.id 
                    JOIN residents r ON c.resident_id = r.id 
                    WHERE c.livreur_id = ? AND c.statut IN ('confirmee', 'en_route_commerce', 'commande_recue', 'en_route_client')
                    ORDER BY c.date_confirmation ASC
                ", [$_SESSION['livreur_id']]);
                
                echo json_encode([
                    'available' => $available ?: [],
                    'mine' => $mine ?: []
                ]);
                exit;
                
            case 'accept_order':
                if (!isset($_SESSION['livreur_id'])) {
                    echo json_encode(['error' => 'Non connecté']);
                    exit;
                }
                
                $commandeId = (int)$_POST['commande_id'];
                $livreurId = $_SESSION['livreur_id'];
                
                $current = db()->fetchOne("
                    SELECT COUNT(*) as count FROM vr_commandes 
                    WHERE livreur_id = ? AND statut IN ('confirmee', 'en_route_commerce', 'commande_recue', 'en_route_client')
                ", [$livreurId]);
                
                if ($current['count'] >= 2) {
                    echo json_encode(['error' => 'Maximum 2 commandes simultanées']);
                    exit;
                }
                
                $updated = db()->update('vr_commandes', 
                    [
                        'livreur_id' => $livreurId, 
                        'statut' => 'confirmee',
                        'date_confirmation' => date('Y-m-d H:i:s')
                    ],
                    'id = ? AND statut = "en_attente"',
                    [$commandeId]
                );
                
                echo json_encode(['success' => true]);
                exit;
                
            case 'update_status':
                if (!isset($_SESSION['livreur_id'])) {
                    echo json_encode(['error' => 'Non connecté']);
                    exit;
                }
                
                $commandeId = (int)$_POST['commande_id'];
                $statut = sanitizeInput($_POST['statut']);
                $livreurId = $_SESSION['livreur_id'];
                
                $updateData = ['statut' => $statut];
                if ($statut === 'livree') {
                    $updateData['date_livraison'] = date('Y-m-d H:i:s');
                }
                
                db()->update('vr_commandes', $updateData, 'id = ? AND livreur_id = ?', [$commandeId, $livreurId]);
                
                echo json_encode(['success' => true]);
                exit;
                
            case 'get_stats':
                if (!isset($_SESSION['livreur_id'])) {
                    echo json_encode(['error' => 'Non connecté']);
                    exit;
                }
                
                $stats = db()->fetchOne("
                    SELECT 
                        COALESCE(COUNT(*), 0) as total_commandes,
                        COALESCE(SUM(frais_livraison), 0) as gains_total,
                        COALESCE(AVG(note_client), 0) as note_moyenne,
                        COALESCE(SUM(CASE WHEN date_livraison >= DATE_SUB(NOW(), INTERVAL 7 DAY) THEN frais_livraison ELSE 0 END), 0) as gains_semaine
                    FROM vr_commandes 
                    WHERE livreur_id = ? AND statut = 'livree'
                ", [$_SESSION['livreur_id']]);
                
                echo json_encode($stats ?: [
                    'total_commandes' => 0,
                    'gains_total' => 0,
                    'note_moyenne' => 0,
                    'gains_semaine' => 0
                ]);
                exit;
                
            case 'logout':
                session_destroy();
                echo json_encode(['success' => true]);
                exit;
                
            default:
                echo json_encode(['error' => 'Action inconnue']);
                exit;
        }
        
    } catch (Exception $e) {
        error_log("Erreur livreur AJAX: " . $e->getMessage());
        echo json_encode(['error' => 'Erreur serveur: ' . $e->getMessage()]);
        exit;
    }
}

if (!isset($_SESSION['livreur_id'])) {
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Connexion Livreur - Vert Chasseur</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-white text-stone-900 min-h-screen flex items-center justify-center">
    <div class="w-full max-w-sm bg-white border border-stone-200 rounded-lg p-8 text-center">
        <img src="logo_new.png" alt="Vert Chasseur" class="w-16 h-16 mx-auto mb-4">
        <h1 class="text-2xl font-light text-stone-900 mb-2">Vert Chasseur</h1>
        <p class="text-stone-600 mb-8">Interface Livreur</p>
        
        <form id="login-form" class="space-y-6">
            <div class="text-left">
                <label class="block text-sm text-stone-900 mb-2">Code d'accès</label>
                <input type="password" id="access-code" required 
                       class="w-full px-3 py-2 border border-stone-200 rounded focus:outline-none focus:border-stone-900" 
                       placeholder="Entrez votre code">
            </div>
            <button type="submit" id="login-btn" 
                    class="w-full bg-stone-900 text-white py-2 rounded hover:bg-stone-700 disabled:opacity-50">
                Se connecter
            </button>
            <div id="error-message" class="bg-red-50 text-red-500 p-3 rounded text-sm hidden"></div>
        </form>
    </div>

    <script>
        document.getElementById('login-form').addEventListener('submit', function(e) {
            e.preventDefault();
            
            const code = document.getElementById('access-code').value.trim();
            const btn = document.getElementById('login-btn');
            const errorDiv = document.getElementById('error-message');
            
            if (!code) {
                showError('Veuillez saisir votre code');
                return;
            }
            
            btn.disabled = true;
            btn.textContent = 'Connexion...';
            errorDiv.classList.add('hidden');
            
            fetch('livreur.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: `action=login&code=${encodeURIComponent(code)}`
            })
            .then(response => {
                if (!response.ok) {
                    throw new Error(`Erreur HTTP ${response.status}: ${response.statusText}`);
                }
                return response.json();
            })
            .then(data => {
                if (data.success) {
                    errorDiv.className = 'bg-green-50 text-green-500 p-3 rounded text-sm';
                    errorDiv.classList.remove('hidden');
                    errorDiv.textContent = 'Connexion réussie ! Redirection...';
                    setTimeout(() => window.location.reload(), 1000);
                } else {
                    showError(data.error || 'Erreur de connexion');
                    btn.disabled = false;
                    btn.textContent = 'Se connecter';
                }
            })
            .catch(error => {
                console.error('Erreur de connexion:', error);
                showError(`Erreur de connexion: ${error.message}`);
                btn.disabled = false;
                btn.textContent = 'Se connecter';
            });
        });

        function showError(message) {
            const errorDiv = document.getElementById('error-message');
            errorDiv.textContent = message;
            errorDiv.classList.remove('hidden');
        }

        document.getElementById('access-code').focus();
    </script>
</body>
</html>
<?php exit; } ?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - <?= htmlspecialchars($_SESSION['livreur_nom']) ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-stone-50 text-stone-900 min-h-screen">
    <div id="error-log" class="fixed top-4 right-4 bg-red-500 text-white p-4 rounded max-w-sm z-50 hidden"></div>
    
    <header class="bg-white border-b border-stone-200">
        <div class="max-w-6xl mx-auto px-4 py-4 flex justify-between items-center">
            <div class="flex items-center space-x-3">
                <img src="logo_new.png" alt="Vert Chasseur" class="w-8 h-8">
                <span class="text-xl font-light text-stone-900">Vert Chasseur</span>
            </div>
            <div class="flex items-center space-x-4">
                <span class="text-stone-600">Bonjour <?= htmlspecialchars($_SESSION['livreur_nom']) ?></span>
                <button onclick="logout()" class="bg-stone-900 text-white px-4 py-2 rounded text-sm hover:bg-stone-700">
                    Déconnexion
                </button>
            </div>
        </div>
    </header>

    <main class="max-w-6xl mx-auto px-4 py-8">
        <div class="mb-8">
            <h2 class="text-2xl font-light text-stone-900 mb-6">Statistiques</h2>
            <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                <div class="bg-white border border-stone-200 rounded-lg p-6 text-center">
                    <div id="gains-semaine" class="text-2xl font-light text-stone-900 mb-1">0€</div>
                    <div class="text-sm text-stone-600">Gains 7 jours</div>
                </div>
                <div class="bg-white border border-stone-200 rounded-lg p-6 text-center">
                    <div id="total-commandes" class="text-2xl font-light text-stone-900 mb-1">0</div>
                    <div class="text-sm text-stone-600">Total commandes</div>
                </div>
                <div class="bg-white border border-stone-200 rounded-lg p-6 text-center">
                    <div id="note-moyenne" class="text-2xl font-light text-stone-900 mb-1">-</div>
                    <div class="text-sm text-stone-600">Note moyenne</div>
                </div>
                <div class="bg-white border border-stone-200 rounded-lg p-6 text-center">
                    <div id="gains-total" class="text-2xl font-light text-stone-900 mb-1">0€</div>
                    <div class="text-sm text-stone-600">Gains total</div>
                </div>
            </div>
        </div>

        <div class="bg-white border border-stone-200 rounded-lg p-6">
            <h2 class="text-2xl font-light text-stone-900 mb-6">Commandes</h2>
            <div class="flex space-x-2 mb-6">
                <button data-tab="available" class="tab bg-stone-900 text-white px-4 py-2 rounded text-sm">
                    Disponibles
                </button>
                <button data-tab="mine" class="tab bg-stone-100 text-stone-700 px-4 py-2 rounded text-sm hover:bg-stone-200">
                    Mes commandes
                </button>
            </div>
            
            <div id="available-orders" class="space-y-4">
                <div class="text-center py-8 text-stone-600">Chargement...</div>
            </div>
            
            <div id="mine-orders" class="space-y-4 hidden">
                <div class="text-center py-8 text-stone-600">Chargement...</div>
            </div>
        </div>
    </main>

    <script>
        let currentTab = 'available';
        let refreshInterval;

        document.addEventListener('DOMContentLoaded', function() {
            setupTabs();
            loadStats();
            loadOrders();
            
            refreshInterval = setInterval(() => {
                loadStats();
                loadOrders();
            }, 30000);
        });

        function setupTabs() {
            document.querySelectorAll('.tab').forEach(tab => {
                tab.addEventListener('click', function() {
                    const tabName = this.dataset.tab;
                    switchTab(tabName);
                });
            });
        }

        function switchTab(tabName) {
            document.querySelectorAll('.tab').forEach(tab => {
                if (tab.dataset.tab === tabName) {
                    tab.className = 'tab bg-stone-900 text-white px-4 py-2 rounded text-sm';
                } else {
                    tab.className = 'tab bg-stone-100 text-stone-700 px-4 py-2 rounded text-sm hover:bg-stone-200';
                }
            });
            
            document.getElementById('available-orders').classList.toggle('hidden', tabName !== 'available');
            document.getElementById('mine-orders').classList.toggle('hidden', tabName !== 'mine');
            
            currentTab = tabName;
        }

        function showError(message) {
            const errorLog = document.getElementById('error-log');
            errorLog.textContent = message;
            errorLog.classList.remove('hidden');
            
            setTimeout(() => {
                errorLog.classList.add('hidden');
            }, 5000);
        }

        function loadStats() {
            fetch('livreur.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: 'action=get_stats'
            })
            .then(response => {
                if (!response.ok) {
                    throw new Error(`HTTP ${response.status}: ${response.statusText}`);
                }
                return response.json();
            })
            .then(data => {
                if (data.error) {
                    showError('Stats: ' + data.error);
                    return;
                }
                document.getElementById('gains-semaine').textContent = (data.gains_semaine || 0) + '€';
                document.getElementById('total-commandes').textContent = data.total_commandes || 0;
                document.getElementById('note-moyenne').textContent = data.note_moyenne ? 
                    Math.round(data.note_moyenne * 10) / 10 + '/5' : '-';
                document.getElementById('gains-total').textContent = (data.gains_total || 0) + '€';
            })
            .catch(error => {
                console.error('Erreur stats:', error);
                showError('Erreur stats: ' + error.message);
            });
        }

        function loadOrders() {
            fetch('livreur.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: 'action=get_orders'
            })
            .then(response => {
                if (!response.ok) {
                    throw new Error(`HTTP ${response.status}: ${response.statusText}`);
                }
                return response.json();
            })
            .then(data => {
                if (data.error) {
                    showError('Commandes: ' + data.error);
                    return;
                }
                
                renderAvailableOrders(data.available || []);
                renderMineOrders(data.mine || []);
            })
            .catch(error => {
                console.error('Erreur orders:', error);
                showError('Erreur commandes: ' + error.message);
            });
        }

        function renderAvailableOrders(orders) {
            const container = document.getElementById('available-orders');
            
            if (orders.length === 0) {
                container.innerHTML = `
                    <div class="text-center py-12 text-stone-600">
                        <div class="text-4xl mb-4">📦</div>
                        <p>Aucune commande disponible</p>
                    </div>
                `;
                return;
            }

            container.innerHTML = orders.map(order => `
                <div class="border border-stone-200 rounded-lg p-4 bg-stone-50">
                    <div class="flex justify-between items-start mb-4">
                        <div class="font-medium text-stone-900">#${order.id}</div>
                        <div class="bg-yellow-100 text-yellow-800 px-2 py-1 rounded text-xs">En attente</div>
                    </div>
                    <div class="space-y-2 mb-4 text-sm">
                        <div><span class="text-stone-600">Client:</span> ${order.first_name} ${order.last_name}</div>
                        <div><span class="text-stone-600">Commerce:</span> ${order.commerce_nom}</div>
                        <div><span class="text-stone-600">Adresse:</span> ${order.adresse_livraison}</div>
                        <div><span class="text-stone-600">Total:</span> ${order.total_commande}€ (${order.frais_livraison}€ pour toi)</div>
                    </div>
                    <button onclick="acceptOrder(${order.id})" 
                            class="w-full bg-stone-900 text-white py-2 rounded text-sm hover:bg-stone-700">
                        Accepter cette commande
                    </button>
                </div>
            `).join('');
        }

        function renderMineOrders(orders) {
            const container = document.getElementById('mine-orders');
            
            if (orders.length === 0) {
                container.innerHTML = `
                    <div class="text-center py-12 text-stone-600">
                        <div class="text-4xl mb-4">✅</div>
                        <p>Aucune commande en cours</p>
                    </div>
                `;
                return;
            }

            container.innerHTML = orders.map(order => `
                <div class="border border-stone-200 rounded-lg p-4 bg-stone-50">
                    <div class="flex justify-between items-start mb-4">
                        <div class="font-medium text-stone-900">#${order.id}</div>
                        <div class="bg-blue-100 text-blue-800 px-2 py-1 rounded text-xs">${getStatusLabel(order.statut)}</div>
                    </div>
                    <div class="space-y-2 mb-4 text-sm">
                        <div><span class="text-stone-600">Client:</span> ${order.first_name} ${order.last_name}</div>
                        <div><span class="text-stone-600">Commerce:</span> ${order.commerce_nom}</div>
                        <div><span class="text-stone-600">Adresse:</span> ${order.adresse_livraison}</div>
                        <div><span class="text-stone-600">Total:</span> ${order.total_commande}€</div>
                    </div>
                    <div class="space-y-2">
                        ${getOrderActions(order)}
                    </div>
                </div>
            `).join('');
        }
        
        function getStatusLabel(status) {
            const labels = {
                'confirmee': 'Confirmée',
                'en_route_commerce': 'En route commerce',
                'commande_recue': 'Commande récupérée',
                'en_route_client': 'En route client'
            };
            return labels[status] || status;
        }

        function getOrderActions(order) {
            switch (order.statut) {
                case 'confirmee':
                    return `<button onclick="updateStatus(${order.id}, 'en_route_commerce')" 
                                    class="w-full bg-yellow-500 text-white py-2 rounded text-sm hover:bg-yellow-600">
                                En route vers commerce
                            </button>`;
                case 'en_route_commerce':
                    return `<button onclick="updateStatus(${order.id}, 'commande_recue')" 
                                    class="w-full bg-green-500 text-white py-2 rounded text-sm hover:bg-green-600">
                                Commande récupérée
                            </button>`;
                case 'commande_recue':
                    return `<button onclick="updateStatus(${order.id}, 'en_route_client')" 
                                    class="w-full bg-blue-500 text-white py-2 rounded text-sm hover:bg-blue-600">
                                En route vers client
                            </button>`;
                case 'en_route_client':
                    return `<button onclick="updateStatus(${order.id}, 'livree')" 
                                    class="w-full bg-green-600 text-white py-2 rounded text-sm hover:bg-green-700">
                                Marquer comme livrée
                            </button>`;
                default:
                    return '';
            }
        }

        function acceptOrder(orderId) {
            if (!confirm('Accepter cette commande ?')) return;
            
            const btn = event.target;
            btn.disabled = true;
            btn.textContent = 'Acceptation...';
            
            fetch('livreur.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: `action=accept_order&commande_id=${orderId}`
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    loadOrders();
                } else {
                    showError(data.error || 'Erreur inconnue');
                    btn.disabled = false;
                    btn.textContent = 'Accepter cette commande';
                }
            })
            .catch(error => {
                console.error('Erreur:', error);
                showError('Erreur: ' + error.message);
                btn.disabled = false;
                btn.textContent = 'Accepter cette commande';
            });
        }

        function updateStatus(orderId, status) {
            const confirmMessages = {
                'en_route_commerce': 'En route vers le commerce ?',
                'commande_recue': 'Commande récupérée ?',
                'en_route_client': 'En route vers le client ?',
                'livree': 'Commande livrée ?'
            };
            
            if (!confirm(confirmMessages[status])) return;
            
            const btn = event.target;
            const originalText = btn.textContent;
            btn.disabled = true;
            btn.textContent = 'Mise à jour...';
            
            fetch('livreur.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: `action=update_status&commande_id=${orderId}&statut=${status}`
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    loadOrders();
                } else {
                    showError(data.error || 'Erreur inconnue');
                    btn.disabled = false;
                    btn.textContent = originalText;
                }
            })
            .catch(error => {
                console.error('Erreur:', error);
                showError('Erreur: ' + error.message);
                btn.disabled = false;
                btn.textContent = originalText;
            });
        }

        function logout() {
            if (!confirm('Te déconnecter ?')) return;
            
            clearInterval(refreshInterval);
            
            fetch('livreur.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: 'action=logout'
            })
            .then(() => {
                window.location.reload();
            })
            .catch(() => {
                window.location.reload();
            });
        }
    </script>
</body>
</html>