<?php
session_start();
include 'db.php';
header('Content-Type: application/json');

if (!isset($_SESSION['resident_id'])) {
    echo json_encode(['error' => 'Non connecté']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);
$residentId = $_SESSION['resident_id'];
$storeId = $input['storeId'];
$livreurId = $input['deliveryPersonId'];
$deliveryAddress = $input['address'];
$deliveryTime = $input['deliveryTime'];
$deliveryDate = date('Y-m-d');

$subtotal = 0;
foreach ($input['items'] as $item) {
    $subtotal += $item['price'] * $item['quantity'];
}

$deliveryFeeResponse = file_get_contents('http://' . $_SERVER['HTTP_HOST'] . '/api/calculate-delivery-fee.php', false, stream_context_create([
    'http' => [
        'method' => 'POST',
        'header' => 'Content-Type: application/json',
        'content' => json_encode([
            'storeId' => $storeId,
            'deliveryPersonId' => $livreurId,
            'customerAddress' => $deliveryAddress
        ])
    ]
]));

$deliveryData = json_decode($deliveryFeeResponse, true);
$deliveryFee = $deliveryData['deliveryFee'];
$total = $subtotal + $deliveryFee;

$orderQuery = "INSERT INTO orders (resident_id, store_id, livreur_id, status, delivery_address, delivery_time, delivery_date, subtotal, delivery_fee, total, payment_status) VALUES (?, ?, ?, 'pending', ?, ?, ?, ?, ?, ?, 'paid')";

$stmt = $conn->prepare($orderQuery);
$stmt->bind_param("iiisssdd", $residentId, $storeId, $livreurId, $deliveryAddress, $deliveryTime, $deliveryDate, $subtotal, $deliveryFee, $total);
$stmt->execute();

$orderId = $conn->insert_id;

foreach ($input['items'] as $item) {
    $itemTotal = $item['price'] * $item['quantity'];
    $itemQuery = "INSERT INTO order_items (order_id, product_id, product_name, product_price, quantity, total) VALUES (?, ?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($itemQuery);
    $stmt->bind_param("iisdid", $orderId, $item['id'], $item['name'], $item['price'], $item['quantity'], $itemTotal);
    $stmt->execute();
}

echo json_encode(['orderId' => $orderId]);
?>