<?php
session_start();
include 'db.php';
header('Content-Type: application/json');

if (!isset($_SESSION['resident_id'])) {
    echo json_encode(['error' => 'Non connecté']);
    exit;
}

$resident_id = $_SESSION['resident_id'];
$query = "SELECT address FROM residents WHERE id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $resident_id);
$stmt->execute();
$result = $stmt->get_result()->fetch_assoc();

if ($result) {
    echo json_encode($result);
} else {
    echo json_encode(['error' => 'Adresse non trouvée']);
}
?>