<?php
session_start();

if(isset($_SESSION['user_id'])) {
    header("Location: dashboard.php");
    exit();
}

if(isset($_POST['register'])) {
    require_once 'db.php';
    
    $email = $_POST['email'];
    $password = $_POST['password'];
    $confirm_password = $_POST['confirm_password'];
    
    if($password != $confirm_password) {
        $error = "Les mots de passe ne correspondent pas";
    } else {
        $sql = "SELECT * FROM users WHERE email = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if($result->num_rows > 0) {
            $error = "Cet email est déjà utilisé";
        } else {
            $hashed_password = password_hash($password, PASSWORD_DEFAULT);
            
            $sql = "INSERT INTO users (email, password) VALUES (?, ?)";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("ss", $email, $hashed_password);
            
            if($stmt->execute()) {
                $_SESSION['registered'] = true;
                header("Location: login.php?registered=true");
                exit();
            } else {
                $error = "Erreur lors de l'inscription";
            }
        }
        
        $stmt->close();
    }
    
    $conn->close();
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Peerkinton - Inscription</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
        }
    </style>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'sans': ['Poppins', 'sans-serif'],
                    }
                }
            }
        }
    </script>
</head>
<body class="bg-white text-gray-900 min-h-screen flex items-center justify-center">
    <div class="w-full px-4 sm:px-6 py-8 sm:py-12">
        <div class="max-w-md mx-auto">
            <div class="mb-10 sm:mb-16 text-center">
                <img src="logo.png" alt="Peerkinton Logo" class="h-6 sm:h-8 mx-auto">
            </div>
            
            <div class="text-center mb-6 sm:mb-10">
                <h1 class="text-3xl sm:text-4xl font-medium mb-3 sm:mb-4">Inscription</h1>
                <p class="text-gray-600 font-light">Crée ton compte pour rejoindre Peerkinton.</p>
            </div>
            
            <div class="mb-6">
                <?php if(isset($error)): ?>
                    <div class="bg-red-50 text-red-800 px-4 py-3 rounded mb-4">
                        <?php echo $error; ?>
                    </div>
                <?php endif; ?>
                
                <form action="" method="POST">
                    <div class="mb-4">
                        <input type="email" name="email" required placeholder="Email" class="w-full px-4 py-3 bg-gray-50 border-0 focus:ring-0 rounded">
                    </div>
                    <div class="mb-4">
                        <input type="password" name="password" required placeholder="Mot de passe" class="w-full px-4 py-3 bg-gray-50 border-0 focus:ring-0 rounded">
                    </div>
                    <div class="mb-6">
                        <input type="password" name="confirm_password" required placeholder="Confirmer le mot de passe" class="w-full px-4 py-3 bg-gray-50 border-0 focus:ring-0 rounded">
                    </div>
                    <button type="submit" name="register" class="w-full bg-black text-white px-6 py-3 font-medium text-sm uppercase tracking-wider rounded">
                        S'inscrire
                    </button>
                </form>
            </div>
            
            <p class="text-gray-600 text-center mb-6">
                Tu as déjà un compte? <a href="login.php" class="text-black font-medium">Connecte-toi ici</a>
            </p>
            
            <div class="text-center">
                <button onclick="showHelp()" class="bg-gray-100 text-gray-700 px-4 py-2 rounded-full text-sm font-medium hover:bg-gray-200 transition-colors">
                    <i class="fas fa-question-circle mr-2"></i>Aide
                </button>
            </div>
        </div>
    </div>
    
    <div id="helpModal" class="fixed inset-0 bg-black bg-opacity-50 hidden items-center justify-center z-50 p-4">
        <div class="bg-white rounded-lg max-w-md w-full p-6">
            <div class="flex justify-between items-center mb-4">
                <div class="flex items-center">
                    <img src="logo.png" alt="Peerkinton Logo" class="h-5 mr-3">
                    <h3 class="text-lg font-semibold">Aide à l'inscription</h3>
                </div>
                <button onclick="hideHelp()" class="text-gray-400 hover:text-gray-600">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            <div class="space-y-3 text-sm text-gray-600">
                <div>
                    <h4 class="font-medium text-gray-900 mb-1">Email déjà utilisé ?</h4>
                    <p>Si tu as déjà un compte, utilise le lien "Connecte-toi ici" pour te connecter.</p>
                </div>
                <div>
                    <h4 class="font-medium text-gray-900 mb-1">Mot de passe sécurisé</h4>
                    <p>Utilise un mot de passe fort avec au moins 8 caractères, incluant lettres et chiffres.</p>
                </div>
                <div>
                    <h4 class="font-medium text-gray-900 mb-1">Mots de passe différents ?</h4>
                    <p>Assure-toi que les deux mots de passe saisis sont identiques.</p>
                </div>
                <div>
                    <h4 class="font-medium text-gray-900 mb-1">Problème d'inscription ?</h4>
                    <p>Vérifie que tous les champs sont correctement remplis et réessaye.</p>
                </div>
            </div>
            <div class="mt-6">
                <button onclick="hideHelp()" class="w-full bg-black text-white py-2 px-4 rounded font-medium">
                    Fermer
                </button>
            </div>
        </div>
    </div>

    <script>
        function showHelp() {
            document.getElementById('helpModal').classList.remove('hidden');
            document.getElementById('helpModal').classList.add('flex');
        }

        function hideHelp() {
            document.getElementById('helpModal').classList.add('hidden');
            document.getElementById('helpModal').classList.remove('flex');
        }

        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') {
                hideHelp();
            }
        });
    </script>
</body>
</html>