<?php
$aeroport_depart = $_POST['aeroport_depart'];
$aeroport_arrivee = $_POST['aeroport_arrivee'];
$date_voyage_avion = $_POST['date_voyage_avion'];

$avion_success = false;
$avion_message = "";

if (empty($aeroport_depart) || empty($aeroport_arrivee) || empty($date_voyage_avion)) {
    $avion_message = "Tous les champs sont obligatoires.";
} elseif ($aeroport_depart == $aeroport_arrivee) {
    $avion_message = "L'aéroport de départ et d'arrivée ne peuvent pas être identiques.";
} elseif (strtotime($date_voyage_avion) < strtotime(date('Y-m-d'))) {
    $avion_message = "La date de voyage ne peut pas être dans le passé.";
} else {
    $sql = "SELECT * FROM aeroports WHERE nom IN (?, ?) AND statut = 'ouvert'";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ss", $aeroport_depart, $aeroport_arrivee);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows < 2) {
        $avion_message = "Un ou plusieurs aéroports sont fermés ou inexistants.";
    } else {
        $aeroports_valides = [];
        while ($row = $result->fetch_assoc()) {
            $aeroports_valides[] = $row['nom'];
        }
        
        if (!in_array($aeroport_depart, $aeroports_valides) || !in_array($aeroport_arrivee, $aeroports_valides)) {
            $avion_message = "Aéroports non valides ou fermés.";
        } else {
            $prix_base = [
                'Aéroport international de Folium' => [
                    'Aéroport de Nova' => 350,
                    'Aéroport de Louria' => 520
                ],
                'Aéroport de Nova' => [
                    'Aéroport international de Folium' => 350,
                    'Aéroport de Louria' => 420
                ],
                'Aéroport de Louria' => [
                    'Aéroport international de Folium' => 520,
                    'Aéroport de Nova' => 420
                ]
            ];
            
            $prix = 400;
            if (isset($prix_base[$aeroport_depart][$aeroport_arrivee])) {
                $prix = $prix_base[$aeroport_depart][$aeroport_arrivee];
            }
            
            $variation = rand(-50, 100);
            $prix += $variation;
            $prix = max($prix, 150);
            
            if ($solde < $prix) {
                $avion_message = "Solde insuffisant pour effectuer cette réservation. Solde actuel: " . number_format($solde, 2, ',', ' ') . " F&, Prix requis: " . number_format($prix, 2, ',', ' ') . " F&";
            } else {
                do {
                    $id_reservation = str_pad(rand(1000000, 9999999), 7, '0', STR_PAD_LEFT);
                    $sql_check = "SELECT id FROM reservations WHERE id_reservation = ?";
                    $stmt_check = $conn->prepare($sql_check);
                    $stmt_check->bind_param("s", $id_reservation);
                    $stmt_check->execute();
                } while ($stmt_check->get_result()->num_rows > 0);
                
                $conn->begin_transaction();
                
                try {
                    $sql = "INSERT INTO reservations (id_reservation, user_id, type, aeroport_depart, aeroport_arrivee, date_voyage, prix, statut) VALUES (?, ?, 'avion', ?, ?, ?, ?, 'confirme')";
                    $stmt = $conn->prepare($sql);
                    $stmt->bind_param("sisssd", $id_reservation, $user_id, $aeroport_depart, $aeroport_arrivee, $date_voyage_avion, $prix);
                    
                    if (!$stmt->execute()) {
                        throw new Exception("Erreur lors de l'insertion de la réservation");
                    }
                    
                    $nouveau_solde = $solde - $prix;
                    $sql = "UPDATE comptes_bancaires SET solde = ? WHERE user_id = ?";
                    $stmt = $conn->prepare($sql);
                    $stmt->bind_param("di", $nouveau_solde, $user_id);
                    
                    if (!$stmt->execute()) {
                        throw new Exception("Erreur lors de la mise à jour du solde");
                    }
                    
                    $sql = "INSERT INTO transactions (user_id, destinataire_id, destinataire_nom, emetteur_nom, montant, motif, type) VALUES (?, 1, 'Compagnie Aérienne Peerkinton', ?, ?, 'Billet d\'avion - " . $aeroport_depart . " vers " . $aeroport_arrivee . "', 'paiement')";
                    $stmt = $conn->prepare($sql);
                    $stmt->bind_param("isd", $user_id, $user['email'], $prix);
                    
                    if (!$stmt->execute()) {
                        throw new Exception("Erreur lors de l'enregistrement de la transaction");
                    }
                    
                    $conn->commit();
                    
                    $avion_success = true;
                    $avion_message = "Réservation de vol confirmée avec succès ! Votre ID de réservation est : " . $id_reservation . ". Montant débité : " . number_format($prix, 2, ',', ' ') . " F&";
                    $solde = $nouveau_solde;
                    
                } catch (Exception $e) {
                    $conn->rollback();
                    $avion_message = "Erreur lors de la réservation : " . $e->getMessage();
                }
            }
        }
    }
}
?>