<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="icon.png">
    <title>Waterloo</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

<meta property="og:title" content="MonWaterloo - Wallonie">
<meta property="og:description" content="MonWaterloo est un quartier à Waterloo où vous trouverez de la joie et un havre de paix accueillant. Découvrez les nombreux commerçant du quartier et la joie de vivre du coin.">
<meta property="og:image" content="https://monwaterloo.be/banner.png">
<meta property="og:image:width" content="1200">
<meta property="og:image:height" content="630">
<meta property="og:url" content="https://monwaterloo.be">
<meta property="og:type" content="website">
<meta property="og:site_name" content="MonWaterloo">
<meta property="og:locale" content="fr_BE">

<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="MonWaterloo - Wallonie">
<meta name="twitter:description" content="MonWaterloo est un quartier à Waterloo où vous trouverez de la joie et un havre de paix accueillant. Découvrez les nombreux commerçant du quartier et la joie de vivre du coin.">
<meta name="twitter:image" content="https://monwaterloo.be/banner.png">

<meta name="description" content="MonWaterloo est un quartier à Waterloo où vous trouverez de la joie et un havre de paix accueillant. Découvrez les nombreux commerçant du quartier et la joie de vivre du coin.">
<meta name="keywords" content="MonWaterloo, Waterloo, Wallonie, quartier, commerces, restaurants">
<meta name="author" content="MonWaterloo">

<link rel="canonical" href="https://monwaterloo.be">

<script src="https://cdn.tailwindcss.com"></script>

<script>
    tailwind.config = {
        darkMode: 'class',
        theme: {
            extend: {}
        }
    }
</script>

<script defer src="https://cloud.umami.is/script.js" data-website-id="6ec552ef-4a61-4f71-a55f-4464703af623"></script>

<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600&display=swap" rel="stylesheet">
<link href="https://fonts.googleapis.com/css2?family=Exile&display=swap" rel="stylesheet">
<link href="https://fonts.googleapis.com/css2?family=Abril+Fatface&display=swap" rel="stylesheet">
<link href="https://fonts.googleapis.com/css2?family=Archivo+Black&display=swap" rel="stylesheet">
<style>
    body {
        background-color: #ffffff;
        background-image: none;
    }
    .dark body {
        background-color: #000000;
    }
    .card-hover {
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }
    .card-hover:hover {
        transform: translateY(-6px);
        box-shadow: 0 20px 40px rgba(0,0,0,0.08);
    }
    .dark .card-hover:hover {
        box-shadow: 0 20px 40px rgba(0,0,0,0.3);
    }
    .txt-waterloo {
        font-family: "Exile", serif;
        font-weight: 400;
    }
    .txt-ad-title {
        font-family: "Abril Fatface", serif;
        font-weight: 400;
    }
    .police-sandro {
        font-family: "Archivo Black", sans-serif;
        font-weight: 400;
    }
    .rambo-image-bg {
        background-image: url('https://spgeng.rosselcdn.net/sites/default/files/dpistyles_v2/ena_16_9_extra_big/2024/01/24/node_781333/55340006/public/2024/01/24/capture_decran_2023-11-13_161515.png?itok=wYS4o4Il1706704165');
        background-size: cover;
        background-position: center;
    }
    .scrollable-content {
        overflow-y: auto;
        -webkit-overflow-scrolling: touch;
    }
    .scrollable-content::-webkit-scrollbar {
        width: 4px;
    }
    .scrollable-content::-webkit-scrollbar-track {
        background: transparent;
    }
    .scrollable-content::-webkit-scrollbar-thumb {
        background: rgba(120, 113, 108, 0.3);
        border-radius: 2px;
    }
    .dark .scrollable-content::-webkit-scrollbar-thumb {
        background: rgba(168, 162, 158, 0.3);
    }
    @media (max-width: 767px) {
        .card-rectangle {
            aspect-ratio: 16 / 9;
        }
        .section-image {
            aspect-ratio: 1 / 1;
        }
    }
    @media (min-width: 768px) {
        .section-image {
            aspect-ratio: 16 / 9;
        }
    }
</style>

</head>
<body class="transition-colors duration-300">
<?php 
include 'header.php';
include 'db.php';

$sql = "SELECT id, title, excerpt, category, date_publication FROM articles WHERE status = 'published' AND date_publication >= DATE_SUB(NOW(), INTERVAL 5 DAY) ORDER BY date_publication DESC LIMIT 1";
$result = $conn->query($sql);
$recentArticle = $result->fetch_assoc();

$apiKey = 'YOUR_API_KEY';
$city = 'Waterloo';
$weatherData = null;

$weatherUrl = "https://api.openweathermap.org/data/2.5/weather?q={$city}&appid={$apiKey}&units=metric&lang=fr";
$weatherResponse = @file_get_contents($weatherUrl);

if ($weatherResponse) {
    $weatherData = json_decode($weatherResponse, true);
}

$conn->close();
?>
    <script>
        if (window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches) {
            document.documentElement.classList.add('dark');
        }
        window.matchMedia('(prefers-color-scheme: dark)').addEventListener('change', e => {
            if (e.matches) {
                document.documentElement.classList.add('dark');
            } else {
                document.documentElement.classList.remove('dark');
            }
        });

document.addEventListener('DOMContentLoaded', function() {
    const pubContainer = document.getElementById('pub-container');
    
    pubContainer.href = "https://monwaterloo.be/shop-details.php?id=18";
    pubContainer.classList.add('rambo-image-bg');
    pubContainer.innerHTML = `
        <div class="absolute inset-0 flex flex-col justify-end p-8 bg-gradient-to-t from-black/60 to-transparent">
            <div class="absolute top-6 right-6 bg-white/10 text-white text-sm px-3 py-1.5 rounded-full backdrop-blur-sm">
                <a class="underline" href="https://aktascorp.com/ads">Publicité</a>
            </div>
            <div class="max-w-xs space-y-4">
                <h2 class="text-white text-3xl font-medium leading-tight">
                    Rien de meilleur qu'un Rambo Burger.
                </h2>
                <p class="text-white/90 text-base leading-relaxed">
                    Les meilleurs smash Burger.
                </p>
                <button class="bg-white/15 text-white px-6 py-2.5 rounded-full backdrop-blur-sm hover:bg-white/25 transition-colors">
                    Commander
                </button>
            </div>
        </div>
    `;

    setTimeout(() => {
        const popup = document.getElementById('account-popup');
        popup.classList.remove('hidden');
    }, 3000);
});

function closePopup() {
    const popup = document.getElementById('downloadPopup');
    popup.classList.add('hidden');
}

</script>

<div id="downloadPopup" class="fixed bottom-6 right-6 bg-white rounded-xl shadow-2xl p-6 w-96 z-50 border border-gray-100">
  <button onclick="closePopup()" class="absolute top-3 right-3 text-gray-400 hover:text-gray-600 w-5 h-5 flex items-center justify-center">✕</button>
  <div class="flex gap-4 mt-1">
    <div class="flex-1">
      <h3 class="text-base font-medium text-gray-900 mb-1">Télécharger notre application sur votre téléphone !</h3>
      <p class="text-xs text-gray-500 mb-4">Profitez de ce qu'offres Waterloo sur l'application officielle de Waterloo !</p>
    </div>
    <div class="hidden md:flex items-center">
      <div id="qrcode"></div>
    </div>
  </div>
  <div class="md:hidden">
    <a href="https://monwaterloo.be/download-app" class="block w-full bg-gray-900 text-white text-center py-2 px-4 rounded-lg text-sm">
      Télécharger
    </a>
  </div>
</div>

<style>
@media (max-width: 767px) {
  #downloadPopup {
    bottom: 0;
    right: 0;
    left: 0;
    width: 100%;
    border-radius: 16px 16px 0 0;
    padding: 20px;
  }
}
</style>

<script src="https://cdnjs.cloudflare.com/ajax/libs/qrcode-generator/1.4.4/qrcode.min.js"></script>
<script>
function generateQRCode() {
  if (window.innerWidth >= 768) {
    const qr = qrcode(0, 'M');
    qr.addData('https://monwaterloo.be/download-app');
    qr.make();
    document.getElementById('qrcode').innerHTML = qr.createImgTag(3);
  }
}
function closePopup() {
  document.getElementById('downloadPopup').style.display = 'none';
}
generateQRCode();
window.addEventListener('resize', generateQRCode);
</script>

<main class="min-h-screen px-8 md:px-16 py-32 max-w-7xl mx-auto">

    <div class="mb-24">
        <p class="text-stone-500 dark:text-stone-400 text-xs tracking-widest uppercase mb-4 font-light">Waterloo · Wallonie</p>
        <h1 class="text-4xl md:text-6xl font-light mb-6 text-stone-800 dark:text-white tracking-tight leading-tight">Bienvenue <span class="md:inline block">à <span class="txt-waterloo font-normal">Waterloo</span></span></h1>
        <p class="text-lg text-stone-600 dark:text-stone-400 leading-relaxed max-w-md font-light">
            Bienvenue à Waterloo. Une ville belge avec une histoire célèbre mais surtout, un lieu calme et chaleureux !
        </p>
    </div>

<div class="grid grid-cols-1 md:grid-cols-3 gap-6">
    <a id="pub-container" class="card-hover aspect-square group block rounded-xl overflow-hidden relative">
    </a>

    <a href="https://monwaterloo.be/shop" class="card-hover aspect-square md:aspect-square card-rectangle group block rounded-xl p-6 bg-white dark:bg-stone-900 border border-stone-200 dark:border-stone-800">
        <div class="h-full flex flex-col justify-between">
            <div>
                <h2 class="text-xl font-medium mb-2 text-stone-900 dark:text-white">Commerces & Restaurants</h2>
                <p class="text-stone-600 dark:text-stone-400 text-sm leading-relaxed">Découvrez les établissements qui font la richesse de notre quartier avec une qualité irréprochable dans la majorité, et sachez où aller pour les trouver.</p>
            </div>
            <div class="flex items-center text-stone-900 dark:text-white mt-2 group-hover:translate-x-1 transition-transform">
                <span class="mr-2 text-xs font-medium">Explorer</span>
                <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"/>
                </svg>
            </div>
        </div>
    </a>

    <?php if ($recentArticle): ?>
    <a href="article.php?id=<?php echo $recentArticle['id']; ?>" class="card-hover aspect-square md:aspect-square card-rectangle block rounded-xl p-6 bg-white dark:bg-stone-900 border border-stone-200 dark:border-stone-800">
        <div class="h-full flex flex-col justify-between">
            <div>
                <span class="inline-block px-2 py-1 bg-stone-100 dark:bg-stone-800 text-stone-600 dark:text-stone-400 text-xs rounded mb-3"><?php echo htmlspecialchars($recentArticle['category']); ?></span>
                <h2 class="text-xl font-medium mb-2 text-stone-900 dark:text-white"><?php echo htmlspecialchars($recentArticle['title']); ?></h2>
                <p class="text-stone-600 dark:text-stone-400 text-sm leading-relaxed"><?php echo htmlspecialchars($recentArticle['excerpt']); ?></p>
            </div>
            <div class="flex items-center text-stone-900 dark:text-white mt-2 group-hover:translate-x-1 transition-transform">
                <span class="mr-2 text-xs font-medium">Lire l'article</span>
                <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"/>
                </svg>
            </div>
        </div>
    </a>
    <?php else: ?>
    <div class="card-hover aspect-square md:aspect-square card-rectangle block rounded-xl p-6 bg-white dark:bg-stone-900 border border-stone-200 dark:border-stone-800">
        <div class="h-full flex flex-col justify-between">
            <div class="flex-1 flex flex-col min-h-0">
                <h2 class="text-xl font-medium mb-3 text-stone-900 dark:text-white flex-shrink-0"><span class="txt-waterloo font-normal">Le poème de la semaine</span></h2>
                <?php if ($weatherData && isset($weatherData['main'])): ?>
                <div class="flex items-center gap-3 mb-3">
                    <img src="https://openweathermap.org/img/wn/<?php echo $weatherData['weather'][0]['icon']; ?>@2x.png" alt="Météo" class="w-12 h-12">
                    <div>
                        <p class="text-3xl font-light text-stone-900 dark:text-white"><?php echo round($weatherData['main']['temp']); ?>°C</p>
                        <p class="text-stone-600 dark:text-stone-400 text-xs capitalize"><?php echo $weatherData['weather'][0]['description']; ?></p>
                    </div>
                </div>
                <p class="text-stone-600 dark:text-stone-400 text-sm">Ressenti : <?php echo round($weatherData['main']['feels_like']); ?>°C</p>
                <?php else: ?>
                <div class="scrollable-content flex-1 pr-2">
                    <p class="text-stone-600 dark:text-stone-400 text-sm leading-relaxed">
                        Dans le silence d'un matin pur,<br>
                        La brise chante, douce et sûre.<br>
                        Les arbres dansent, pleins de lumière,<br>
                        Offrant leur paix à l'univers.
                    </p>
                </div>
                <?php endif; ?>
            </div>
            <p class="text-stone-500 dark:text-stone-500 text-xs italic flex-shrink-0 mt-3">Par la nature</p>
        </div>
    </div>
    <?php endif; ?>
</div>

<div class="mt-32">
    <div class="w-full h-px bg-stone-200 dark:bg-stone-800 mb-16"></div>
    
    <div class="max-w-5xl mx-auto">
        <h2 class="text-3xl md:text-4xl font-light mb-16 text-stone-800 dark:text-white">Qu'est-ce qui est prévu pour Waterloo ces prochains mois ?</h2>
        
        <div class="space-y-12">
            <div class="flex gap-8 items-start pb-12 border-b border-stone-200 dark:border-stone-800">
                <span class="text-4xl font-light text-stone-300 dark:text-stone-700 flex-shrink-0">01</span>
                <div class="flex-1">
                    <h3 class="text-xl font-medium mb-2 text-stone-900 dark:text-white">Animer notre belle chaussée !</h3>
                    <p class="text-stone-600 dark:text-stone-400 leading-relaxed mb-3 font-light">Installer des enceintes au abords de la route pour mettre de la musique en fond et également, organiser des événements.</p>
                    <span class="text-xs text-stone-500 dark:text-stone-500 uppercase tracking-widest">Sortie surprise</span>
                </div>
            </div>
            <div class="flex gap-8 items-start pb-12 border-b border-stone-200 dark:border-stone-800">
                <span class="text-4xl font-light text-stone-300 dark:text-stone-700 flex-shrink-0">02</span>
                <div class="flex-1">
                    <h3 class="text-xl font-medium mb-2 text-stone-900 dark:text-white">Waterloo aura son propre magazine !</h3>
                    <p class="text-stone-600 dark:text-stone-400 leading-relaxed mb-3 font-light">Publier un magazine dédiée uniquement à Waterloo pour vous divertir !</p>
                    <span class="text-xs text-stone-500 dark:text-stone-500 uppercase tracking-widest">Sortie · Février 2026</span>
                </div>
            </div>
        </div>
    </div>
</div>

</main>

<footer class="w-full py-6 px-8 md:px-16 border-t border-stone-200 dark:border-stone-800">
    <p class="text-xs text-stone-500 dark:text-stone-400">© 2025 MonWaterloo · A <a href="https://aktascorp.com" class="underline hover:text-stone-700 dark:hover:text-stone-300">aktascorp</a> member · <a href="https://aktascorp.com/privacy" class="hover:text-stone-700 dark:hover:text-stone-300">Confidentialité</a> - <a class="underline" href="https://izhak.me">This website made by Izhak</a></p>
</footer>

</body>
</html>