<?php
$headerBgColor = 'bg-transparent';
$headerTextColor = 'text-white';
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Événements - Vert Chasseur</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { 
            font-family: 'Plus Jakarta Sans', sans-serif;
            overflow: hidden;
        }
        
        .video-container::after {
            content: '';
            position: absolute;
            inset: 0;
            background: linear-gradient(rgba(0,0,0,0.4), rgba(0,0,0,0.4));
        }

        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }

        .animate-fade {
            animation: fadeIn 1s ease-out forwards;
        }
    </style>
</head>
<body>
    <?php include 'header.php'; ?>

    <main class="bg-black relative h-screen w-full">
      

        <div class="relative h-full flex items-center justify-center z-10">
            <div class="text-center px-4 animate-fade">
                <span class="inline-block text-sm md:text-base text-white/80 font-medium tracking-wider mb-4">
                    COMING SOON BY IMATORS
                </span>
                <h1 class="text-4xl md:text-6xl font-bold text-white mb-4">
                    FRAME
                </h1>
                <p class="text-lg text-white/90 max-w-xl mx-auto">
                    Imators à pour objectif que une fois que la possibilité se présente, organisez une parade à Vert Chasseur. Restez à l'écoute pour découvrir tous les événements 
                    qui animeront bientôt le quartier de Vert Chasseur.
                </p>
            </div>
        </div>
    </main>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const video = document.querySelector('video');
            video.play().catch(error => console.log("Autoplay failed:", error));
        });
    </script>
</body>
</html>