<?php
session_start();
require_once 'db.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'error' => 'Non autorisé']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);
$action = $input['action'] ?? '';
$service = $input['service'] ?? '';

if (!in_array($action, ['cancel', 'disconnect']) || !in_array($service, ['academ', 'ohmypanel', 'something'])) {
    echo json_encode(['success' => false, 'error' => 'Paramètres invalides']);
    exit;
}

try {
    $db = new Database();
    $conn = $db->connect();
    
    $stmt = $conn->prepare("UPDATE utilisateurs SET $service = 0 WHERE id = ?");
    $result = $stmt->execute([$_SESSION['user_id']]);
    
    if ($result) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false, 'error' => 'Erreur base de données']);
    }
} catch(Exception $e) {
    echo json_encode(['success' => false, 'error' => 'Erreur serveur']);
}
?>