<?php
session_start();

if (!isset($_SESSION['emails'])) {
    $_SESSION['emails'] = generateInitialEmails();
}

if (!isset($_SESSION['folders'])) {
    $_SESSION['folders'] = [
        'Urgent' => [],
        'Archives' => [],
        'Spam' => [],
        'Personnel' => [],
        'Classifié' => [],
        'Divers' => []
    ];
}

function generateInitialEmails() {
    $emails = [
        [
            'id' => uniqid('email_'),
            'subject' => 'Rapport urgent - Anomalie Secteur 7',
            'sender' => 'dr.mitchell@awpo.sys',
            'date' => date('Y-m-d H:i:s', strtotime('-2 hours')),
            'content' => "Agent,\n\nNous avons détecté une anomalie critique dans le secteur 7. Les capteurs indiquent des fluctuations paranormales dépassant les seuils normaux.\n\nVeuillez traiter ce dossier en priorité absolue. Les détails sont classifiés niveau 4.\n\nProcédure standard:\n1. Vérifier l'intégrité des données\n2. Isoler les fichiers suspects\n3. Exécuter le protocole de containment\n\nTout retard pourrait avoir des conséquences graves.\n\nDr. Mitchell\nChef de la Division Paranormale",
            'isSpam' => false,
            'hasAttachment' => true,
            'attachmentName' => 'anomalie_sector7.pdf',
            'priority' => 5
        ],
        [
            'id' => uniqid('email_'),
            'subject' => '!!! FÉLICITATIONS VOUS AVEZ GAGNÉ 1.000.000€ !!!',
            'sender' => 'winner@lottery-scam.com',
            'date' => date('Y-m-d H:i:s', strtotime('-5 hours')),
            'content' => "FÉLICITATIONS!!!\n\nVOUS ÊTES LE GRAND GAGNANT DE NOTRE LOTERIE INTERNATIONALE!\n\n>>> CLIQUEZ ICI MAINTENANT <<<\n>>> RÉCLAMEZ VOS 1.000.000€ <<<\n\nCeci n'est PAS une arnaque! Agissez VITE!\n\n[LIEN MALVEILLANT DÉTECTÉ]\n\nATTENTION: CE MESSAGE CONTIENT DU CODE MALVEILLANT",
            'isSpam' => true,
            'hasAttachment' => true,
            'attachmentName' => 'totally_not_virus.exe',
            'priority' => 1
        ],
        [
            'id' => uniqid('email_'),
            'subject' => 'Maintenance système prévue',
            'sender' => 'admin@awpo.sys',
            'date' => date('Y-m-d H:i:s', strtotime('-1 day')),
            'content' => "À tout le personnel,\n\nUne maintenance système est prévue ce soir de 23h00 à 02h00.\n\nPendant cette période:\n- Sauvegardez tous vos fichiers importants\n- Fermez toutes les applications\n- Ne tentez pas d'accéder aux serveurs\n\nLe système pourrait présenter des comportements anormaux pendant la maintenance.\n\nSi vous rencontrez des problèmes après la maintenance, contactez immédiatement le support.\n\nAdmin Système\nAWPO IT Department",
            'isSpam' => false,
            'hasAttachment' => false,
            'priority' => 3
        ],
        [
            'id' => uniqid('email_'),
            'subject' => 'Re: Dossier 47 - NE PAS OUVRIR',
            'sender' => 'inconnu@???.???',
            'date' => date('Y-m-d H:i:s', strtotime('-3 days')),
            'content' => "Ils savent que vous avez accès au dossier 47.\n\nNe leur faites pas confiance.\nLes murs ont des yeux.\nLes fichiers sont vivants.\n\n01001000 01000101 01001100 01010000 00100000 01001101 01000101\n\nLa vérité est dans le code.\nRegardez entre les lignes.\n\n[DONNÉES CORROMPUES]\n[ERREUR DE DÉCODAGE]\n\n-- Message tronqué --",
            'isSpam' => false,
            'isCreepy' => true,
            'hasAttachment' => true,
            'attachmentName' => 'dossier_47.corrupted',
            'priority' => 4
        ],
        [
            'id' => uniqid('email_'),
            'subject' => 'Rappel: Formation sécurité obligatoire',
            'sender' => 'rh@awpo.sys',
            'date' => date('Y-m-d H:i:s', strtotime('-1 week')),
            'content' => "Bonjour,\n\nCeci est un rappel concernant la formation sécurité obligatoire.\n\nDate: Vendredi prochain\nHeure: 14h00-16h00\nSalle: B-666\n\nCette formation couvrira:\n- Protocoles d'urgence\n- Gestion des anomalies\n- Procédures d'évacuation\n- Premiers secours paranormaux\n\nLa présence est OBLIGATOIRE.\n\nService RH\nAWPO",
            'isSpam' => false,
            'hasAttachment' => false,
            'priority' => 2
        ]
    ];
    
    return $emails;
}

if (isset($_POST['action'])) {
    header('Content-Type: application/json');
    
    switch($_POST['action']) {
        case 'moveToFolder':
            $emailId = $_POST['emailId'];
            $folder = $_POST['folder'];
            
            foreach ($_SESSION['emails'] as $key => $email) {
                if ($email['id'] == $emailId) {
                    $_SESSION['folders'][$folder][] = $email;
                    unset($_SESSION['emails'][$key]);
                    $_SESSION['emails'] = array_values($_SESSION['emails']);
                    
                    $result = ['success' => true, 'message' => "Email déplacé vers $folder"];
                    
                    if ($email['isSpam'] && $folder !== 'Spam') {
                        $result['warning'] = 'MALWARE_DETECTED';
                        $result['shouldCrash'] = rand(1, 100) <= 70;
                    } elseif (!$email['isSpam'] && $folder === 'Spam') {
                        $result['warning'] = 'LEGITIMATE_FILE_DELETED';
                        $result['score'] = -10;
                    } else {
                        $result['score'] = 10;
                    }
                    
                    echo json_encode($result);
                    exit;
                }
            }
            break;
            
        case 'refreshEmails':
            $_SESSION['emails'] = array_merge($_SESSION['emails'], generateInitialEmails());
            echo json_encode(['success' => true, 'count' => count($_SESSION['emails'])]);
            exit;
    }
}
?>

<div style="height: 100%; display: flex; flex-direction: column; background: #ECE9D8;">
    <div style="background: #F0F0F0; border-bottom: 1px solid #999; padding: 5px;">
        <button onclick="refreshInbox()" style="padding: 2px 8px; margin: 0 2px;">📥 Actualiser</button>
        <button onclick="composeEmail()" style="padding: 2px 8px; margin: 0 2px;">✉️ Nouveau</button>
        <span style="margin-left: 20px; font-size: 11px;">
            <?= count($_SESSION['emails']) ?> message(s) dans la boîte de réception
        </span>
    </div>
    
    <div style="flex: 1; display: flex; overflow: hidden;">
        <div style="width: 200px; background: #F0F0F0; border-right: 1px solid #999; overflow-y: auto;">
            <div style="padding: 5px; font-weight: bold; background: #E0E0E0;">📁 Dossiers</div>
            <?php foreach (array_keys($_SESSION['folders']) as $folder): ?>
                <div class="folder-item" 
                     data-folder="<?= $folder ?>"
                     style="padding: 5px 10px; cursor: pointer; border-bottom: 1px solid #DDD;">
                    📁 <?= $folder ?> (<?= count($_SESSION['folders'][$folder]) ?>)
                </div>
            <?php endforeach; ?>
        </div>
        
        <div style="flex: 1; display: flex; flex-direction: column;">
            <div id="emailList" style="height: 40%; border-bottom: 2px solid #999; overflow-y: auto; background: white;">
                <?php foreach ($_SESSION['emails'] as $email): ?>
                    <div class="email-item" 
                         data-id="<?= $email['id'] ?>"
                         data-spam="<?= $email['isSpam'] ? '1' : '0' ?>"
                         onclick="viewEmail('<?= $email['id'] ?>')"
                         style="padding: 8px; 
                                border-bottom: 1px solid #DDD; 
                                cursor: pointer;
                                background: <?= isset($email['isCreepy']) && $email['isCreepy'] ? '#FFE0E0' : 'white' ?>;">
                        <div style="display: flex; justify-content: space-between;">
                            <div>
                                <strong><?= htmlspecialchars($email['sender']) ?></strong>
                                <?php if ($email['priority'] >= 4): ?>
                                    <span style="color: red;">🔥</span>
                                <?php endif; ?>
                                <?php if ($email['hasAttachment']): ?>
                                    <span>📎</span>
                                <?php endif; ?>
                            </div>
                            <div style="font-size: 10px; color: #666;">
                                <?= $email['date'] ?>
                            </div>
                        </div>
                        <div style="font-size: 12px; margin-top: 2px;">
                            <?= htmlspecialchars($email['subject']) ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
            
            <div id="emailViewer" style="flex: 1; padding: 10px; background: white; overflow-y: auto;">
                <div style="text-align: center; color: #999; margin-top: 50px;">
                    Sélectionnez un email pour le lire
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.email-item:hover {
    background: #E8F4FF !important;
}

.email-item.selected {
    background: #D0E8FF !important;
}

.folder-item:hover {
    background: #D0D0D0;
}

.folder-item.drop-target {
    background: #90EE90;
    font-weight: bold;
}
</style>

<script>
let currentEmail = null;
let selectedEmailElement = null;

function viewEmail(emailId) {
    const emails = <?= json_encode($_SESSION['emails']) ?>;
    const email = emails.find(e => e.id === emailId);
    
    if (!email) return;
    
    currentEmail = email;
    
    if (selectedEmailElement) {
        selectedEmailElement.classList.remove('selected');
    }
    selectedEmailElement = document.querySelector(`[data-id="${emailId}"]`);
    selectedEmailElement.classList.add('selected');
    
    let attachmentHtml = '';
    if (email.hasAttachment) {
        const isDangerous = email.attachmentName.includes('.exe') || email.attachmentName.includes('virus');
        attachmentHtml = `
            <div style="margin-top: 10px; padding: 10px; background: #F0F0F0; border: 1px solid #999;">
                <strong>Pièce jointe:</strong> 
                <span style="color: ${isDangerous ? 'red' : 'blue'}; cursor: pointer;" 
                      onclick="openAttachment('${email.attachmentName}', ${email.isSpam})">
                    📎 ${email.attachmentName}
                </span>
                ${isDangerous ? '<span style="color: red; font-size: 10px;"> ⚠️ SUSPECT</span>' : ''}
            </div>
        `;
    }
    
    document.getElementById('emailViewer').innerHTML = `
        <div style="border-bottom: 1px solid #999; padding-bottom: 10px; margin-bottom: 10px;">
            <div style="margin-bottom: 5px;">
                <button onclick="replyEmail()" style="padding: 2px 8px;">↩️ Répondre</button>
                <button onclick="forwardEmail()" style="padding: 2px 8px;">➡️ Transférer</button>
                <button onclick="deleteEmail('${emailId}')" style="padding: 2px 8px; background: #FFE0E0;">🗑️ Supprimer</button>
                <select onchange="moveToFolder('${emailId}', this.value)" style="margin-left: 10px;">
                    <option value="">📁 Déplacer vers...</option>
                    <option value="Urgent">Urgent</option>
                    <option value="Archives">Archives</option>
                    <option value="Spam">Spam</option>
                    <option value="Personnel">Personnel</option>
                    <option value="Classifié">Classifié</option>
                    <option value="Divers">Divers</option>
                </select>
            </div>
            <div><strong>De:</strong> ${email.sender}</div>
            <div><strong>Date:</strong> ${email.date}</div>
            <div><strong>Objet:</strong> ${email.subject}</div>
            ${attachmentHtml}
        </div>
        <div style="white-space: pre-wrap; font-family: Arial; font-size: 12px; line-height: 1.5;">
${email.content}
        </div>
    `;
    
    if (email.isSpam && Math.random() < 0.2) {
        setTimeout(() => {
            parent.showNotification('⚠️ Alerte', 'Contenu suspect détecté dans cet email', 'warning');
        }, 1000);
    }
}

function openAttachment(filename, isSpam) {
    if (isSpam || filename.includes('.exe') || filename.includes('virus')) {
        if (confirm('⚠️ ATTENTION: Ce fichier semble dangereux. Voulez-vous vraiment l\'ouvrir?')) {
            parent.showNotification('ERREUR CRITIQUE', 'VIRUS DÉTECTÉ!', 'error');
            setTimeout(() => {
                parent.systemCrash();
            }, 500);
        }
    } else {
        parent.showNotification('Téléchargement', `Ouverture de ${filename}...`, 'info');
    }
}

function moveToFolder(emailId, folder) {
    if (!folder) return;
    
    const formData = new FormData();
    formData.append('action', 'moveToFolder');
    formData.append('emailId', emailId);
    formData.append('folder', folder);
    
    fetch('includes/mail.php', {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.warning === 'MALWARE_DETECTED') {
            parent.showNotification('⚠️ ALERTE', 'MALWARE DÉTECTÉ!', 'error');
            if (data.shouldCrash) {
                setTimeout(() => parent.systemCrash(), 500);
            }
        } else {
            document.querySelector(`[data-id="${emailId}"]`).remove();
            document.getElementById('emailViewer').innerHTML = `
                <div style="text-align: center; color: #999; margin-top: 50px;">
                    Email déplacé vers ${folder}
                </div>
            `;
            parent.gameState.score += (data.score || 0);
        }
    });
}

function deleteEmail(emailId) {
    if (confirm('Êtes-vous sûr de vouloir supprimer cet email?')) {
        moveToFolder(emailId, 'Spam');
    }
}

function replyEmail() {
    if (!currentEmail) return;
    alert(`Réponse à: ${currentEmail.sender}\nObjet: Re: ${currentEmail.subject}\n\n[Éditeur de message non implémenté]`);
}

function forwardEmail() {
    if (!currentEmail) return;
    alert(`Transférer: ${currentEmail.subject}\n\n[Éditeur de message non implémenté]`);
}

function composeEmail() {
    alert('Nouveau message\n\n[Éditeur de message non implémenté]');
}

function refreshInbox() {
    const formData = new FormData();
    formData.append('action', 'refreshEmails');
    
    fetch('includes/mail.php', {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        parent.showNotification('Mail', `${data.count} nouveaux messages`, 'info');
        setTimeout(() => location.reload(), 500);
    });
}

document.querySelectorAll('.email-item').forEach(item => {
    item.draggable = true;
    
    item.addEventListener('dragstart', (e) => {
        e.dataTransfer.setData('emailId', e.currentTarget.dataset.id);
        e.currentTarget.style.opacity = '0.5';
    });
    
    item.addEventListener('dragend', (e) => {
        e.currentTarget.style.opacity = '1';
    });
});

document.querySelectorAll('.folder-item').forEach(folder => {
    folder.addEventListener('dragover', (e) => {
        e.preventDefault();
        folder.classList.add('drop-target');
    });
    
    folder.addEventListener('dragleave', (e) => {
        folder.classList.remove('drop-target');
    });
    
    folder.addEventListener('drop', (e) => {
        e.preventDefault();
        folder.classList.remove('drop-target');
        const emailId = e.dataTransfer.getData('emailId');
        const folderName = folder.dataset.folder;
        moveToFolder(emailId, folderName);
    });
});
</script>