const express = require('express');
const nodemailer = require('nodemailer');
const fs = require('fs').promises;
const path = require('path');
const mysql = require('mysql2/promise');
const cors = require('cors');

const app = express();
const port = 3000;

app.use(cors());
app.use(express.json());
app.use(express.static('public'));

const dbConfig = {
  host: 'localhost:3306', 
  user: 'gqdcvggs',
  password: 'IzhakAktas17032010*#@',
  database: 'gqdcvggs_imators-user'
};

const transporter = nodemailer.createTransport({
  host: 'mail.imators.com',
  port: 465,
  secure: true,
  auth: {
    user: 'no-reply@imators.com',
    pass: 'imators.management@imators.com112255'
  }
});

async function getUserEmails() {
  let connection;
  try {
    connection = await mysql.createConnection(dbConfig);
    const [rows] = await connection.execute('SELECT email FROM utilisateurs');
    return rows.map(row => row.email);
  } catch (error) {
    console.error('Error retrieving emails:', error);
    throw error;
  } finally {
    if (connection) await connection.end();
  }
}

async function readHTMLTemplate(templateName) {
  const templatePath = path.join(__dirname, 'templates', `${templateName}.html`);
  try {
    return await fs.readFile(templatePath, 'utf-8');
  } catch (error) {
    console.error(`Error reading template ${templateName}:`, error);
    throw error;
  }
}

app.get('/', (req, res) => {
  res.sendFile(path.join(__dirname, 'public', 'admin.html'));
});

app.get('/templates/:templateName', async (req, res) => {
  try {
    const { templateName } = req.params;
    const htmlContent = await readHTMLTemplate(templateName);
    res.send(htmlContent);
  } catch (error) {
    console.error('Error reading template:', error);
    res.status(500).send('Error reading template');
  }
});

app.post('/send-emails', async (req, res) => {
  const { templateName, subject, testEmail } = req.body;

  res.writeHead(200, {
    'Content-Type': 'text/event-stream',
    'Cache-Control': 'no-cache',
    'Connection': 'keep-alive'
  });

  try {
    const emails = testEmail ? [testEmail] : await getUserEmails();
    const htmlContent = await readHTMLTemplate(templateName);

    res.write(JSON.stringify({ totalEmails: emails.length }) + '\n');

    let sentEmails = 0;
    for (const email of emails) {
      try {
        await transporter.sendMail({
          from: '"Imators" <no-reply@imators.com>',
          to: email,
          subject: subject,
          html: htmlContent
        });
        sentEmails++;
        res.write(JSON.stringify({ sentEmails, message: `Email sent to ${email}` }) + '\n');
      } catch (error) {
        console.error(`Error sending email to ${email}:`, error);
        res.write(JSON.stringify({ error: `Error sending email to ${email}` }) + '\n');
      }
    }

    res.write(JSON.stringify({ message: 'All emails have been sent' }) + '\n');
  } catch (error) {
    console.error('General error:', error);
    res.write(JSON.stringify({ error: 'An error occurred while sending emails' }) + '\n');
  } finally {
    res.end();
  }
});

app.listen(port, () => {
  console.log(`IMATORS SYSTEMS: The mail-imators block is running on port ${port}`);
});