<?php
require_once 'config.php';
if ($_POST) {
   $code = trim($_POST['code']);
   
   $stmt = $pdo->prepare("SELECT * FROM users WHERE code = ?");
   $stmt->execute([$code]);
   $user = $stmt->fetch();
   
   if ($user) {
       $_SESSION['user_id'] = $user['id'];
       $_SESSION['user_type'] = $user['type'];
       $_SESSION['user_nom'] = $user['nom'];
       header('Location: dashboard.php');
       exit;
   } else {
       $error = "Code incorrect";
   }
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
   <meta charset="UTF-8">
   <meta name="viewport" content="width=device-width, initial-scale=1.0">
   <title>Tracking Scolaire</title>
   <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600&display=swap" rel="stylesheet">
   <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
   <script src="https://cdn.tailwindcss.com"></script>
   <script>
       tailwind.config = {
           theme: {
               extend: {
                   fontFamily: {
                       'inter': ['Inter', 'sans-serif'],
                   }
               }
           }
       }
   </script>
</head>
<body class="font-inter bg-gradient-to-br from-black to-gray-900 text-white min-h-screen flex flex-col">
   
   <div class="flex-1 flex items-center justify-center p-8">
       <div class="w-full max-w-md">
           

           <div class="bg-white/5 backdrop-blur-sm border border-white/10 rounded-2xl p-8">
               
               <?php if (isset($error)): ?>
                   <div class="bg-red-500/10 border border-red-500/20 rounded-lg p-4 mb-6 flex items-center">
                       <i class="fas fa-exclamation-triangle text-red-400 mr-3"></i>
                       <span class="text-red-200"><?= $error ?></span>
                   </div>
               <?php endif; ?>

               <form method="POST">
                   <div class="mb-6">
                       <label class="block text-sm font-medium text-gray-300 mb-2">Code d'accès</label>
                       <input type="text" 
                              id="code" 
                              name="code" 
                              placeholder="Entrez votre code..." 
                              required 
                              autofocus
                              class="w-full bg-white/5 border border-white/20 rounded-lg px-4 py-3 text-white placeholder-gray-400 focus:outline-none focus:border-white/40 transition-colors">
                   </div>
                   
                   <button type="submit" 
                           class="w-full bg-white text-black font-medium py-3 px-4 rounded-lg hover:bg-gray-100 transition-colors">
                       Se connecter
                   </button>
               </form>
           </div>
       </div>
   </div>

   <div class="bg-black/20 border-t border-white/10 py-4">
       <div class="text-center text-sm text-gray-400">
           © <?php echo date("Y"); ?> Imators LLC - All right reserved - Customed Version
       </div>
   </div>

   <script>
       document.getElementById('code').addEventListener('input', function(e) {
           e.target.value = e.target.value.toUpperCase();
       });
   </script>
</body>
</html>