import * as react from 'react';
import { ReactNode, Ref } from 'react';
import * as tailwind_variants from 'tailwind-variants';
import * as _heroui_system from '@heroui/system';
import { PropGetter, HTMLHeroUIProps } from '@heroui/system';
import { ToggleVariantProps, SlotsToClasses, ToggleSlots } from '@heroui/theme';
import { AriaSwitchProps } from '@react-aria/switch';

type SwitchThumbIconProps = {
    width: string;
    height: string;
    "data-checked": string;
    isSelected: boolean;
    className: string;
};
interface Props extends HTMLHeroUIProps<"input"> {
    /**
     * Ref to the DOM node.
     */
    ref?: Ref<HTMLInputElement>;
    /**
     * The label of the switch.
     */
    children?: ReactNode;
    /**
     * Whether the switch is disabled.
     * @default false
     */
    isDisabled?: boolean;
    /**
     * The icon to be displayed inside the thumb.
     */
    thumbIcon?: ReactNode | ((props: SwitchThumbIconProps) => ReactNode);
    /**
     * Start icon to be displayed inside the switch.
     */
    startContent?: ReactNode;
    /**
     * End icon to be displayed inside the switch.
     */
    endContent?: ReactNode;
    /**
     * Classname or List of classes to change the classNames of the element.
     * if `className` is passed, it will be added to the base slot.
     *
     * @example
     * ```ts
     * <Switch classNames={{
     *    base:"base-classes",
     *    wrapper: "wrapper-classes",
     *    thumb: "thumb-classes",
     *    thumbIcon: "thumbIcon-classes",
     *    label: "label-classes",
     * }} />
     * ```
     */
    classNames?: SlotsToClasses<ToggleSlots>;
    /**
     * React aria onChange event.
     */
    onValueChange?: AriaSwitchProps["onChange"];
}
type UseSwitchProps = Omit<Props, "defaultChecked"> & Omit<AriaSwitchProps, keyof ToggleVariantProps | "onChange"> & ToggleVariantProps;
declare function useSwitch(originalProps?: UseSwitchProps): {
    Component: _heroui_system.As<any>;
    slots: {
        base: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            isDisabled?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        wrapper: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            isDisabled?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        thumb: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            isDisabled?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        hiddenInput: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            isDisabled?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        startContent: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            isDisabled?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        endContent: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            isDisabled?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        thumbIcon: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            isDisabled?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        label: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            isDisabled?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
    } & {
        base: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            isDisabled?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        wrapper: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            isDisabled?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        thumb: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            isDisabled?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        hiddenInput: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            isDisabled?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        startContent: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            isDisabled?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        endContent: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            isDisabled?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        thumbIcon: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            isDisabled?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        label: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            isDisabled?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
    } & {};
    classNames: SlotsToClasses<"base" | "label" | "wrapper" | "hiddenInput" | "startContent" | "endContent" | "thumbIcon" | "thumb"> | undefined;
    domRef: react.RefObject<HTMLLabelElement>;
    children: ReactNode;
    thumbIcon: ReactNode | ((props: SwitchThumbIconProps) => ReactNode);
    startContent: ReactNode;
    endContent: ReactNode;
    isHovered: boolean;
    isSelected: boolean | undefined;
    isPressed: boolean;
    isFocused: boolean;
    isFocusVisible: boolean;
    isDisabled: boolean | undefined;
    getBaseProps: PropGetter;
    getWrapperProps: PropGetter;
    getInputProps: PropGetter;
    getLabelProps: PropGetter;
    getThumbProps: PropGetter;
    getThumbIconProps: (props?: {
        includeStateProps: boolean;
    }) => SwitchThumbIconProps;
    getStartContentProps: PropGetter;
    getEndContentProps: PropGetter;
};
type UseSwitchReturn = ReturnType<typeof useSwitch>;

export { type SwitchThumbIconProps, type UseSwitchProps, type UseSwitchReturn, useSwitch };
