<?php
require_once 'db.php';

header('Content-Type: application/json');

$serial = filter_input(INPUT_GET, 'serial', FILTER_SANITIZE_STRING);

if (empty($serial)) {
    echo json_encode(['error' => 'Numéro de série manquant']);
    exit;
}

try {
    $stmt = $pdo->prepare("SELECT status, stop_message FROM `imators-systems-billboard` WHERE serial = ?");
    $stmt->execute([$serial]);
    $billboard = $stmt->fetch();
    
    if ($billboard) {
        $stmt = $pdo->prepare("UPDATE `imators-systems-billboard` SET last_seen = NOW() WHERE serial = ?");
        $stmt->execute([$serial]);
        
        echo json_encode([
            'status' => $billboard['status'],
            'stop_message' => $billboard['stop_message'] ?? ''
        ]);
    } else {
        echo json_encode(['error' => 'Panneau non trouvé']);
    }
} catch (PDOException $e) {
    echo json_encode(['error' => 'Erreur de base de données']);
}