<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lord Court of Belgium</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400&family=Inter:wght@300&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Inter', sans-serif;
        }
        .title-font {
            font-family: 'Playfair Display', serif;
        }
    </style>
</head>
<body class="bg-white text-gray-900">
    <header class="py-6 text-center">
        <h1 class="title-font text-xl font-normal">The Lord Court of Belgium</h1>
    </header>

    <main class="flex items-center min-h-[75vh] px-8 md:px-16">
        <div class="max-w-2xl space-y-12">
            <div class="border-t border-b border-gray-300 py-6">
                <div class="flex items-center gap-4">
                    <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/d/d2/Police_of_Belgium_insignia.svg/2048px-Police_of_Belgium_insignia.svg.png" alt="Logo Police Belge" class="h-12">
                    <p class="text-sm font-light text-gray-700">
                        Nous coopérons activement avec la police fédérale Belge pour mener toute intervention.
                    </p>
                </div>
            </div>

            <div>
                <h2 class="text-3xl font-bold mb-4">Protection des données et lutte des spammer dans le royaume de Belgique</h2>
                <p class="text-sm font-light text-gray-700 leading-relaxed">
                    Depuis 1847, nous assurons la préservation et la sécurité des informations sensibles. 
                    Notre expertise en matière de renseignement et de protection contre les intrusions numériques 
                    fait de nous un acteur de référence en Europe.
                </p>
            </div>

            <div>
                <h2 class="text-2xl font-light mb-4">Services</h2>
                <p class="text-sm font-light text-gray-700 leading-relaxed mb-3">
                    Analyse et filtrage avancé des communications indésirables. Surveillance continue 
                    des menaces potentielles. Chiffrement et archivage sécurisé des données critiques.
                </p>
                <p class="text-sm font-light text-gray-700 leading-relaxed">
                    Nos protocoles respectent les normes les plus strictes établies par les instances 
                    européennes de protection des données personnelles.
                </p>
            </div>

            <div>
                <h2 class="text-2xl font-light mb-4">Discrétion absolue</h2>
                <p class="text-sm font-light text-gray-700 leading-relaxed">
                    Chaque dossier est traité avec la plus grande confidentialité. Nos équipes opèrent 
                    selon un code de conduite rigoureux, garantissant l'intégrité de vos informations 
                    en toutes circonstances.
                </p>
            </div>
        </div>
    </main>

    <footer class="py-6 text-center">
        <img src="https://fr.const-court.be/img/logo.webp" alt="Logo" class="h-10 mx-auto mb-3">
        <p class="text-xs font-light text-gray-600">
            The Lord Court of Belgium est protégée par la cour belge est agis en temps que récolter d'informations afin de lutter contre les délits en ligne que la TLC Mondial récolte
        </p>
    </footer>
</body>
</html>