<?php
require_once 'db.php';

$average = 0;
$total = 0;

try {
    $stmt = $pdo->prepare("SELECT AVG(note) as moyenne, COUNT(*) as total FROM avis WHERE approved = 1");
    $stmt->execute();
    $stats = $stmt->fetch(PDO::FETCH_ASSOC);
    
    $average = floatval($stats['moyenne']) ?: 0;
    $total = intval($stats['total']) ?: 0;
} catch(PDOException $e) {
    
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Izhak</title>
<meta name="description" content="this is my portfolio.  With three years of web development experience, I've honed my skills while maintaining a positive and sharing-oriented mindset. I'm known for my contagious joy and ability to make others laugh, believing that happiness and professional excellence go hand in hand.">

<!-- Facebook Meta Tags -->
<meta property="og:url" content="https://Izhak.me">
<meta property="og:type" content="website">
<meta property="og:title" content="Izhak">
<meta property="og:description" content="this is my portfolio.  With three years of web development experience, I've honed my skills while maintaining a positive and sharing-oriented mindset. I'm known for my contagious joy and ability to make others laugh, believing that happiness and professional excellence go hand in hand.">
<meta property="og:image" content="https://opengraph.b-cdn.net/production/images/f178b34d-90c5-4c95-bb5b-f52ca5a93d30.png?token=xNv3cXSElYNsa31JGFdBe2x9Ue7hnAuyGV5h_JQ6JRY&height=675&width=1200&expires=33287723604">

<!-- Twitter Meta Tags -->
<meta name="twitter:card" content="summary_large_image">
<meta property="twitter:domain" content="Izhak.me">
<meta property="twitter:url" content="https://Izhak.me">
<meta name="twitter:title" content="Izhak">
<meta name="twitter:description" content="this is my portfolio.  With three years of web development experience, I've honed my skills while maintaining a positive and sharing-oriented mindset. I'm known for my contagious joy and ability to make others laugh, believing that happiness and professional excellence go hand in hand.">
<meta name="twitter:image" content="https://opengraph.b-cdn.net/production/images/f178b34d-90c5-4c95-bb5b-f52ca5a93d30.png?token=xNv3cXSElYNsa31JGFdBe2x9Ue7hnAuyGV5h_JQ6JRY&height=675&width=1200&expires=33287723604">

<!-- Meta Tags Generated via https://www.opengraph.xyz -->
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="icon" href="icon.png" type="image/png">
    <link href="https://api.fontshare.com/v2/css?f[]=cabinet-grotesk@400,500,700,800&display=swap" rel="stylesheet">
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    <style>
        :root {
    --bg-light: #ffffff;
    --bg-dark: #121212;
    --text-light: #121212;
    --text-dark: #f5f5f5;
    --border-light: rgba(0, 0, 0, 0.1);
    --border-dark: rgba(255, 255, 255, 0.1);
}

@media (prefers-color-scheme: dark) {
    body {
        background-color: var(--bg-dark);
        color: var(--text-dark);
    }
    .header-border {
        border-top: 1px solid var(--text-dark);
        border-bottom: 1px solid var(--text-dark);
        background-color: rgba(18, 18, 18, 0.8);
    }
    .border-custom {
        border-color: var(--border-dark);
    }
    .bg-custom {
        background-color: var(--bg-dark);
    }
    .button-custom {
        background-color: var(--text-dark);
        color: var(--bg-dark);
    }
    .dot-custom {
        background-color: var(--text-dark);
    }
    .card-front, .card-back {
        background-color: var(--bg-dark);
        border-color: var(--border-dark);
    }
    .card-back {
        color: var(--text-dark);
    }
}

@media (prefers-color-scheme: light) {
    body {
        background-color: var(--bg-light);
        color: var(--text-light);
    }
    .header-border {
        border-top: 1px solid var(--text-light);
        border-bottom: 1px solid var(--text-light);
        background-color: rgba(255, 255, 255, 0.8);
    }
    .border-custom {
        border-color: var(--border-light);
    }
    .bg-custom {
        background-color: var(--bg-light);
    }
    .button-custom {
        background-color: var(--text-light);
        color: var(--bg-light);
    }
    .dot-custom {
        background-color: var(--text-light);
    }
    .card-front, .card-back {
        background-color: var(--bg-light);
        border-color: var(--border-light);
    }
    .card-back {
        color: var(--text-light);
    }
}

body {
    font-family: 'Cabinet Grotesk', sans-serif;
    transition: background-color 0.3s ease, color 0.3s ease;
}

.header-border {
    backdrop-filter: blur(10px);
    padding: 2rem 0;
    margin-bottom: 4rem;
}

@keyframes fadeIn {
    from {opacity: 0;transform: translateY(10px);}
    to {opacity: 1;transform: translateY(0);}
}

.fade-in {
    opacity: 0;
    animation: fadeIn 0.8s cubic-bezier(0.4, 0, 0.2, 1) forwards;
}

.delay-1 {animation-delay: 0.2s;}
.delay-2 {animation-delay: 0.4s;}
.delay-3 {animation-delay: 0.6s;}
.delay-4 {animation-delay: 0.8s;}

.main-container {
    max-width: 1200px;
    margin: 0 auto;
    padding: 0 1rem;
}

section {
    border-bottom: 1px solid currentColor;
    padding: 4rem 0;
    margin-bottom: 4rem;
}

.hover-scale {
    transition: transform 0.3s ease;
}

.hover-scale:hover {
    transform: scale(1.02);
}

.skills-badges {
    display: flex;
    flex-wrap: wrap;
    gap: 10px;
    margin: 20px 0;
}

.badge {
    background-color: #333;
    color: white;
    font-weight: bold;
    padding: 8px 16px;
    border-radius: 20px;
    font-size: 14px;
}

.badge:nth-child(1) {
    background-color: #e34c26;
}

.badge:nth-child(2) {
    background-color: #777bb3;
}

.badge:nth-child(3) {
    background-color: #f7df1e;
    color: black;
}

.badge:nth-child(4) {
    background-color: #264de4;
}

.badge:nth-child(5) {
    background-color: #fcb103;
}

.badge:nth-child(6) {
    background-color: #fc5a03;
}

.badge:nth-child(7) {
    background-color: #03bafc;
}

.badge:nth-child(8) {
    background-color: #fce803;
    color: black;
}

.badge:nth-child(9) {
    background-color: rgb(3, 28, 252);
    color: white;
}

.sponsors-grid {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 2rem;
}

.sponsor-card {
    height: 240px;
    perspective: 1000px;
    cursor: pointer;
}

.card-inner {
    position: relative;
    width: 100%;
    height: 100%;
    transition: transform 0.6s cubic-bezier(0.4, 0, 0.2, 1);
    transform-style: preserve-3d;
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    border-radius: 12px;
}

.sponsor-card.is-flipped .card-inner {
    transform: rotateY(180deg);
}

.card-front, .card-back {
    position: absolute;
    width: 100%;
    height: 100%;
    -webkit-backface-visibility: hidden;
    backface-visibility: hidden;
    display: flex;
    flex-direction: column;
    justify-content: center;
    align-items: center;
    padding: 1.5rem;
    border-radius: 12px;
    border: 1px solid var(--border-light);
}

.card-back {
    transform: rotateY(180deg);
    text-align: center;
}

.card-back h3 {
    margin-bottom: 1rem;
    font-size: 1.25rem;
    font-weight: 500;
}

.card-back p {
    font-size: 0.95rem;
    line-height: 1.5;
}

.sponsor-logo {
    max-width: 80%;
    max-height: 80px;
    object-fit: contain;
    transition: all 0.3s ease;
    filter: grayscale(100%);
}

.sponsor-card:hover .sponsor-logo {
    filter: grayscale(0%);
}

@media (min-width: 640px) {
    .main-container {
        padding: 0 2rem;
    }
}

@media (min-width: 768px) {
    .sponsors-grid {
        grid-template-columns: repeat(4, 1fr);
    }
    
    section {
        padding: 6rem 0;
    }
    
    .header-border {
        padding: 2rem 0;
        margin-bottom: 4rem;
    }
}

@media (max-width: 768px) {
    h1 {
        font-size: 2.5rem;
    }
    h2 {
        font-size: 2rem;
    }
    .header-content {
        flex-direction: column;
        align-items: flex-start;
        gap: 1rem;
    }
    
    .header-border {
        padding: 1.5rem 0;
        margin-bottom: 2rem;
    }
    
    #intro {
        margin-bottom: 3rem;
        padding-top: 0;
    }
    
    section {
        padding: 3rem 0;
        margin-bottom: 3rem;
    }
    
    #intro .flex.flex-col.sm\\:flex-row {
        margin-bottom: 2rem;
    }
    
    .main-container {
        padding: 0 1rem;
    }
}
    </style>
</head>
<body class="min-h-screen">
<header class="header-border py-8 mb-16 fade-in sticky top-0 z-50">
    <div class="main-container">
        <div class="flex justify-between items-center">
            <h1 class="text-3xl font-light tracking-tight">
                Izhak
            </h1>
            <div class="text-sm font-light tracking-wide" id="london-time">
                00:00:00 AM
            </div>
        </div>
    </div>
</header>

<script>
function updateLondonTime() {
    const now = new Date();
    const londonTime = new Date(now.toLocaleString("en-US", {timeZone: "Europe/London"}));
    
    let hours = londonTime.getHours();
    const minutes = londonTime.getMinutes().toString().padStart(2, '0');
    const seconds = londonTime.getSeconds().toString().padStart(2, '0');
    
    const ampm = hours >= 12 ? 'PM' : 'AM';
    hours = hours % 12;
    hours = hours ? hours : 12;
    const displayHours = hours.toString().padStart(2, '0');
    
    document.getElementById('london-time').textContent = `${displayHours}:${minutes}:${seconds} ${ampm}`;
}

setInterval(updateLondonTime, 1000);
updateLondonTime();
</script>

    <main class="main-container">
<section id="intro" class="mb-16">
    <div class="max-w-2xl">
        <div class="flex flex-col sm:flex-row gap-4 items-start sm:items-center mb-8">
            <div class="inline-block text-sm font-light tracking-wide px-3 py-1 rounded-full border border-custom">
                <span class="flex items-center">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 mr-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z" />
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z" />
                    </svg>
                    Currently in Brussels
                </span>
            </div>
            <div class="inline-block text-sm font-light tracking-wide px-3 py-1 rounded-full border border-custom">
                <span class="flex items-center gap-1">
                    <div class="flex" id="mini-stars-display">
                        <?php for($i = 1; $i <= 5; $i++): ?>
                            <?php if($i <= floor($average)): ?>
                                <span class="text-yellow-400 text-xs">★</span>
                            <?php elseif($i <= $average): ?>
                                <span class="text-yellow-400 text-xs opacity-50">★</span>
                            <?php else: ?>
                                <span class="text-gray-400 text-xs">☆</span>
                            <?php endif; ?>
                        <?php endfor; ?>
                    </div>
                    <span id="mini-rating-value" class="text-xs"><?php echo number_format($average, 1); ?></span>
                    <span id="mini-reviews-count" class="text-xs opacity-70">(<?php echo $total; ?>)</span>
                </span>
            </div>
        </div>
        <h2 class="text-4xl md:text-5xl font-light tracking-tight mb-6 fade-in delay-2">
            To fascinate, discover and put a smile on your face
        </h2>
        <p class="text-lg font-light leading-relaxed mb-12 fade-in delay-3">
            For me, every day makes us learn something or makes us enjoy everyday life. My goal has always been to share, observe and appreciate the moment day by day
        </p>
        <div class="flex flex-col sm:flex-row gap-4">
            <a href="https://cal.com/forchange/15min?overlayCalendar=true" class="button-custom px-6 py-3 rounded-full text-sm font-light tracking-wide fade-in delay-4 hover:opacity-90 transition-opacity inline-block text-center">
                Get a appointment
            </a>
            <a href="/projects" class="border border-black bg-transparent px-6 py-3 rounded-full text-sm font-light tracking-wide fade-in delay-4 hover:opacity-90 transition-opacity inline-block text-center">
                See my projects
            </a>
            <a href="/post" class="border border-white bg-transparent px-6 py-3 rounded-full text-sm font-light tracking-wide fade-in delay-4 hover:opacity-90 transition-opacity inline-block text-center">
                My blog
            </a>
        </div>
    </div>
</section>
        

        <section id="about" class="mb-16">
            <h2 class="text-4xl font-light mb-12 border-b border-custom pb-4">ABOUT ME</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-16">
                <div class="space-y-6">
                    <p class="text-lg font-light leading-relaxed">
                        I'm a web developer and entrepreneur based in Europe. My journey in tech started with a simple curiosity about how websites work, and it has evolved into a passion for creating digital experiences that matter.
                    </p>
                    <p class="text-lg font-light leading-relaxed">
                        As the CEO of Imators, I lead a team dedicated to developing technology that enhances daily life without compromising human connection. We believe in innovation that serves people, not the other way around.
                    </p>
                </div>
                <div class="space-y-6">
                    <p class="text-lg font-light leading-relaxed">
                        With three years of development experience, I've honed my skills while maintaining a positive and sharing-oriented mindset. I'm known for my contagious joy and ability to make others laugh, believing that happiness and professional excellence go hand in hand.
                    </p>
                    <p class="text-lg font-light leading-relaxed">
                        I approach both work and life with enthusiasm and a genuine desire to share experiences. My minimalist philosophy focuses on what really matters : smiling every day and always expressing my good humour and enthusiasm.
                    </p>
                    
                                   <p class="italic text-lg font-light leading-relaxed">
                       Oh! And this is just for you: the code languages that make my daily life a happiness on a computer : 
                    </p>
                </div>
            </div>
        
        <div class="skills-badges">
    <div class="badge">HTML</div>
    <div class="badge">PHP</div>
    <div class="badge">JavaScript</div>
    <div class="badge">CSS</div>
    <div class="badge">Java</div>
    <div class="badge">Swift</div>
    <div class="badge">C#</div>
    <div class="badge">Python</div>
    <div class="badge">LUA</div>        
</section>



<style>
    .skills-badges {
        display: flex;
        flex-wrap: wrap;
        gap: 10px;
        margin: 20px 0;
    }
    
    .badge {
        background-color: #333;
        color: white;
        font-weight: bold;
        padding: 8px 16px;
        border-radius: 20px;
        font-size: 14px;
    }
    
    .badge:nth-child(1) {
        background-color: #e34c26;
    }
    
    .badge:nth-child(2) {
        background-color: #777bb3;
    }
    
    .badge:nth-child(3) {
        background-color: #f7df1e;
        color: black;
    }
    
    .badge:nth-child(4) {
        background-color: #264de4;
    }
    
    .badge:nth-child(5) {
        background-color: #fcb103;
    }
    
    .badge:nth-child(6) {
        background-color: #fc5a03;
    }
    
    .badge:nth-child(7) {
        background-color: #03bafc;
    }
    
    .badge:nth-child(8) {
        background-color: #fce803;
        color : black;
    }

    .badge:nth-child(9) {
        background-color:rgb(3, 28, 252);
        color : white;
    }
</style>

<section id="sponsors" class="mb-16">
    <h2 class="text-4xl font-light mb-12 border-b border-custom pb-4">TRUSTED BY THE BEST</h2>
    
    <div class="sponsors-grid">
        <div class="sponsor-card" onclick="this.classList.toggle('is-flipped')">
            <div class="card-inner">
                <div class="card-front">
                    <img src="https://theaceclubparis.com/cdn/shop/files/TAC_logo_noir_vert.png?v=1679569052&width=2838" alt="The Ace Club" class="sponsor-logo">
                </div>
                <div class="card-back">
                    <h3>The Ace Club</h3>
                    <p>Sponsored by them, I proudly wear their clothes every day and at Tennis</p>
                </div>
            </div>
        </div>
        
        <div class="sponsor-card" onclick="this.classList.toggle('is-flipped')">
            <div class="card-inner">
                <div class="card-front">
                    <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/1/1b/Apple_logo_grey.svg/1724px-Apple_logo_grey.svg.png" alt="Apple" class="sponsor-logo">
                </div>
                <div class="card-back">
                    <h3>Apple</h3>
                    <p>Having received several gift licenses and privileges at the Apple Store, I use the Apple Developers tools.</p>
                </div>
            </div>
        </div>
        
        <div class="sponsor-card" onclick="this.classList.toggle('is-flipped')">
            <div class="card-inner">
                <div class="card-front">
                    <img src="https://creatorsarea.fr/_next/static/media/logo.79b9e00f.svg" alt="Creators Area" class="sponsor-logo">
                </div>
                <div class="card-back">
                    <h3>Creators Area</h3>
                    <p>Thanks to them, I discovered several developers to complete my teams</p>
                </div>
            </div>
        </div>
        
        <div class="sponsor-card" onclick="this.classList.toggle('is-flipped')">
            <div class="card-inner">
                <div class="card-front">
                    <img src="https://www.ouiheberg.com/assets/img/logoicon-compressor.webp" alt="OuiHeberg" class="sponsor-logo">
                </div>
                <div class="card-back">
                    <h3>OuiHeberg</h3>
                    <p>Host maintained by friends and trusted for all my infrastructures.</p>
                </div>
            </div>
        </div>
    </div>
    
    <style>
        .sponsors-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 2rem;
        }
        
        @media (min-width: 768px) {
            .sponsors-grid {
                grid-template-columns: repeat(4, 1fr);
            }
        }
        
        .sponsor-card {
            height: 240px;
            perspective: 1000px;
            cursor: pointer;
        }
        
        .card-inner {
            position: relative;
            width: 100%;
            height: 100%;
            transition: transform 0.6s cubic-bezier(0.4, 0, 0.2, 1);
            transform-style: preserve-3d;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            border-radius: 12px;
        }
        
        .sponsor-card.is-flipped .card-inner {
            transform: rotateY(180deg);
        }
        
        .card-front, .card-back {
            position: absolute;
            width: 100%;
            height: 100%;
            -webkit-backface-visibility: hidden;
            backface-visibility: hidden;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            padding: 1.5rem;
            border-radius: 12px;
        }
        
        .card-front {
            background-color: var(--bg-light);
            border: 1px solid var(--border-light);
        }
        
        .card-back {
            background-color: var(--bg-light);
            color: var(--text-light);
            transform: rotateY(180deg);
            border: 1px solid var(--border-light);
            text-align: center;
        }
        
        .card-back h3 {
            margin-bottom: 1rem;
            font-size: 1.25rem;
            font-weight: 500;
        }
        
        .card-back p {
            font-size: 0.95rem;
            line-height: 1.5;
        }
        
        .sponsor-logo {
            max-width: 80%;
            max-height: 80px;
            object-fit: contain;
            transition: all 0.3s ease;
            filter: grayscale(100%);
        }
        
        .sponsor-card:hover .sponsor-logo {
            filter: grayscale(0%);
        }
        
        @media (prefers-color-scheme: dark) {
            .card-front, .card-back {
                background-color: var(--bg-dark);
                border-color: var(--border-dark);
            }
            
            .card-back {
                color: var(--text-dark);
            }
        }
    </style>
</section>

        <section id="music" class="mb-16">
            <h2 class="text-4xl font-light mb-12 border-b border-custom pb-4">MY FAVORITE ALBUMS</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-12">
                <div class="hover-scale">
                    <div class="aspect-square overflow-hidden rounded-lg border border-custom shadow-lg mb-4">
                        <img src="https://media.pitchfork.com/photos/6662e6122ce1ce711b18e944/master/w_1280%2Cc_limit/Sabrina-Carpenter-Short-n-Sweet.jpg" 
                             class="w-full h-full object-cover" alt="Short n Sweet album">
                    </div>
                    <div class="space-y-2">
                        <h3 class="text-2xl font-light">Short n' Sweet</h3>
                        <div class="flex items-center gap-2">
                            <span class="w-2 h-2 dot-custom rounded-full"></span>
                            <a href="https://music.apple.com/uk/album/short-n-sweet/1750307020" class="text-sm hover:underline">Listen on Apple Music</a>
                        </div>
                    </div>
                </div>

                <div class="hover-scale">
                    <div class="aspect-square overflow-hidden rounded-lg border border-custom shadow-lg mb-4">
                        <img src="https://i.scdn.co/image/ab67616d0000b273d0bbd3ea2ec554f17a6603cc" 
                             class="w-full h-full object-cover" alt="Silk Sonic album">
                    </div>
                    <div class="space-y-2">
                        <h3 class="text-2xl font-light">An Evening with Silk Sonic</h3>
                        <div class="flex items-center gap-2">
                            <span class="w-2 h-2 dot-custom rounded-full"></span>
                            <a href="https://music.apple.com/album/short-n-sweet/1728313338" class="text-sm hover:underline">Listen on Apple Music</a>
                        </div>
                    </div>
                </div>
                
                <div class="hover-scale">
                    <div class="aspect-square overflow-hidden rounded-lg border border-custom shadow-lg mb-4">
                        <img src="https://is1-ssl.mzstatic.com/image/thumb/Music116/v4/6c/11/d6/6c11d681-aa3a-d59e-4c2e-f77e181026ab/190295092665.jpg/600x600bf-60.jpg" 
                             class="w-full h-full object-cover" alt="Silk Sonic album">
                    </div>
                    <div class="space-y-2">
                        <h3 class="text-2xl font-light">Future Nostalgia</h3>
                        <div class="flex items-center gap-2">
                            <span class="w-2 h-2 dot-custom rounded-full"></span>
                            <a href="https://music.apple.com/be/album/future-nostalgia/1538003494" class="text-sm hover:underline">Listen on Apple Music</a>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section id="media" class="mb-16">
            <h2 class="text-4xl font-light mb-12 border-b border-custom pb-4">MY FAVORITE SERIES & MOVIES</h2>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-12">
                 <div class="hover-scale">
                    <div class="aspect-[2/3] overflow-hidden rounded-lg border border-custom shadow-lg mb-4">
                        <img src="https://static1.srcdn.com/wordpress/wp-content/uploads/2023/06/the-equalizer-franchise-poster.jpg" alt="Sugar">
                    </div>
                    <div class="space-y-2">
                        <h3 class="text-2xl font-light">The Equalizer</h3>
                        <div class="flex items-center gap-2">
                            <span class="w-2 h-2 dot-custom rounded-full"></span>
                            <a href="https://www.netflix.com/watch/70305892?source=35" class="text-sm hover:underline">Watch on Netflix</a>
                        </div>
                    </div>
                </div>
                
                
                <div class="hover-scale">
                    <div class="aspect-[2/3] overflow-hidden rounded-lg border border-custom shadow-lg mb-4">
                        <img src="Apple_TV_Wolfs_key_art_2_3.png" alt="Sugar">
                    </div>
                    <div class="space-y-2">
                        <h3 class="text-2xl font-light">Wolfs</h3>
                        <div class="flex items-center gap-2">
                            <span class="w-2 h-2 dot-custom rounded-full"></span>
                            <a href="https://tv.apple.com/us/movie/wolfs/umc.cmc.c3xhu25rw4jxxxzq4oio6snu" class="text-sm hover:underline">Watch on AppleTV+</a>
                        </div>
                    </div>
                </div>
                
                
                
                
                
              <div class="hover-scale">
                    <div class="aspect-[2/3] overflow-hidden rounded-lg border border-custom shadow-lg mb-4">
                        <img src="f1-cover.png" 
                             class="w-full h-full object-cover" alt="Sugar">
                    </div>
                    <div class="space-y-2">
                        <h3 class="text-2xl font-light">F1 : The Movie</h3>
                        <div class="flex items-center gap-2">
                            <span class="w-2 h-2 dot-custom rounded-full"></span>
                            <a href="https://tv.apple.com/be/movie/f1-the-movie/umc.cmc.3t6dvnnr87zwd4wmvpdx5came" class="text-sm hover:underline">Watch in theater</a>
                        </div>
                    </div>
                </div>
                
                
                <div class="hover-scale">
                    <div class="aspect-[2/3] overflow-hidden rounded-lg border border-custom shadow-lg mb-4">
                        <img src="https://m.media-amazon.com/images/M/MV5BYWI3ODJlMzktY2U5NC00ZjdlLWE1MGItNWQxZDk3NWNjN2RhXkEyXkFqcGc@._V1_.jpg" 
                             class="w-full h-full object-cover" alt="Sugar">
                    </div>
                    <div class="space-y-2">
                        <h3 class="text-2xl font-light">The Last Of Us</h3>
                        <div class="flex items-center gap-2">
                            <span class="w-2 h-2 dot-custom rounded-full"></span>
                            <a href="https://play.hbomax.com/show/93ba22b1-833e-47ba-ae94-8ee7b9eefa9a" class="text-sm hover:underline">Watch on HBO</a>
                        </div>
                    </div>
                </div>
                
                <div class="hover-scale">
                    <div class="aspect-[2/3] overflow-hidden rounded-lg border border-custom shadow-lg mb-4">
                        <img src="https://ravanna.vidangel.com/file/ravanna/5/c/movies-607_0010_05_5cf62a1e518c377a.jpg" 
                             class="w-full h-full object-cover" alt="Sugar">
                    </div>
                    <div class="space-y-2">
                        <h3 class="text-2xl font-light">Men In Black</h3>
                        <div class="flex items-center gap-2">
                            <span class="w-2 h-2 dot-custom rounded-full"></span>
                            <a href="https://www.netflix.com/browse?jbv=60001650" class="text-sm hover:underline">Watch on Netflix</a>
                        </div>
                    </div>
                </div>
            
            
            
            
            
            <div class="hover-scale">
                    <div class="aspect-[2/3] overflow-hidden rounded-lg border border-custom shadow-lg mb-4">
                        <img src="yfn.png" 
                             class="w-full h-full object-cover" alt="Sugar">
                    </div>
                    <div class="space-y-2">
                        <h3 class="text-2xl font-light">Your friends & Neighbors</h3>
                        <div class="flex items-center gap-2">
                            <span class="w-2 h-2 dot-custom rounded-full"></span>
                            <a href="https://tv.apple.com/be/show/your-friends--neighbors/umc.cmc.74o37kzay0yuuub8iumddjsg" class="text-sm hover:underline">Watch on Apple TV+</a>
                        </div>
                    </div>
                </div>
            
            
            
            <div class="hover-scale">
                    <div class="aspect-[2/3] overflow-hidden rounded-lg border border-custom shadow-lg mb-4">
                        <img src="https://m.media-amazon.com/images/S/pv-target-images/aab0322a11698c77fe0dc30131b2ffdba59a73d3544a0b25cf5cb7d20e029f84.jpg
" 
                             class="w-full h-full object-cover" alt="Sugar">
                    </div>
                    <div class="space-y-2">
                        <h3 class="text-2xl font-light">The Gorge</h3>
                        <div class="flex items-center gap-2">
                            <span class="w-2 h-2 dot-custom rounded-full"></span>
                            <a href="https://tv.apple.com/be/movie/the-gorge/umc.cmc.26o403koqo2klixc0jtqy6tmc" class="text-sm hover:underline">Watch on Apple TV+</a>
                        </div>
                    </div>
                </div>
            
            
                <div class="hover-scale">
                    <div class="aspect-[2/3] overflow-hidden rounded-lg border border-custom shadow-lg mb-4">
                        <img src="https://m.media-amazon.com/images/M/MV5BMTAzZDRmN2UtNzY4YS00NmFhLTg4OTMtYjU0NDg5NDZiYWMzXkEyXkFqcGc@._V1_.jpg" 
                             class="w-full h-full object-cover" alt="Sugar">
                    </div>
                    <div class="space-y-2">
                        <h3 class="text-2xl font-light">Sugar</h3>
                        <div class="flex items-center gap-2">
                            <span class="w-2 h-2 dot-custom rounded-full"></span>
                            <a href="https://tv.apple.com/be/show/sugar/umc.cmc.4r6q7tdquewehwvb3rzl0k3dtm" class="text-sm hover:underline">Watch on Apple TV+</a>
                        </div>
                    </div>
                </div>
                
   
                <div class="hover-scale">
                    <div class="aspect-[2/3] overflow-hidden rounded-lg border border-custom shadow-lg mb-4">
                        <img src="https://preview.redd.it/fly-me-to-the-moon-2024-textless-v0-y4htoeerwezc1.jpeg?auto=webp&s=841eca3463d5408f09090df6a2a7e645eee100f9" 
                             class="w-full h-full object-cover" alt="To The Moon">
                    </div>
                    <div class="space-y-2">
                        <h3 class="text-2xl font-light">To The Moon</h3>
                        <div class="flex items-center gap-2">
                            <span class="w-2 h-2 dot-custom rounded-full"></span>
                            <a href="https://tv.apple.com/be/movie/to-the-moon/umc.cmc.7bwrikjdeik56bk49vlr7c1h6" class="text-sm hover:underline">Watch on Apple TV+</a>
                        </div>
                    </div>
                </div>
                
                <div class="hover-scale">
                    <div class="aspect-[2/3] overflow-hidden rounded-lg border border-custom shadow-lg mb-4">
                        <img src="https://images.justwatch.com/poster/306062218/s718/the-idol.jpg" 
                             class="w-full h-full object-cover" alt="To The Moon">
                    </div>
                    <div class="space-y-2">
                        <h3 class="text-2xl font-light">The Idol</h3>
                        <div class="flex items-center gap-2">
                            <span class="w-2 h-2 dot-custom rounded-full"></span>
                            <a href="https://play.max.com/show/8893abd5-1a33-477b-94e4-20329e2d37ef?utm_medium=sharebutton&utm_id=C09D6D18-E52A-4D12-9771-BE175D5DD052" class="text-sm hover:underline">Watch on HBO Max</a>
                        </div>
                    </div>
                </div>

                <div class="hover-scale">
                    <div class="aspect-[2/3] overflow-hidden rounded-lg border border-custom shadow-lg mb-4">
                        <img src="https://resize.elle.fr/original/var/plain_site/storage/images/loisirs/series/ces-films-et-series-a-regarder-si-vous-avez-aime-lupin-dans-l-ombre-d-arsene/94289862-3-fre-FR/7-films-et-series-a-regarder-si-vous-avez-aime-Lupin-dans-l-ombre-d-Arsene.jpg" 
                             class="w-full h-full object-cover" alt="Lupin">
                    </div>
                    <div class="space-y-2">
                        <h3 class="text-2xl font-light">Lupin</h3>
                        <div class="flex items-center gap-2">
                            <span class="w-2 h-2 dot-custom rounded-full"></span>
                            <a href="#" class="text-sm hover:underline">Watch on Netflix</a>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>
    
    <script>
    
    function updateMiniRating(average, total) {
const miniStars = document.querySelectorAll(’#mini-stars-display span’);
const ratingValue = document.getElementById(‘mini-rating-value’);
const reviewsCount = document.getElementById(‘mini-reviews-count’);

if (miniStars && ratingValue && reviewsCount) {
    miniStars.forEach((star, index) => {
        if (index < Math.floor(average)) {
            star.textContent = '★';
            star.className = 'text-yellow-400 text-xs';
        } else if (index < average) {
            star.textContent = '★';
            star.className = 'text-yellow-400 text-xs opacity-50';
        } else {
            star.textContent = '☆';
            star.className = 'text-gray-400 text-xs';
        }
    });
    
    ratingValue.textContent = average.toFixed(1);
    reviewsCount.textContent = `(${total})`;
}

}

function loadReviewStats() {
fetch(‘avis_handler.php?action=get_stats’)
.then(response => response.json())
.then(data => {
const average = parseFloat(data.moyenne) || 0;
const total = parseInt(data.total) || 0;

        if (document.getElementById('average-rating')) {
            document.getElementById('average-rating').textContent = average.toFixed(1);
        }
        if (document.getElementById('total-reviews')) {
            document.getElementById('total-reviews').textContent = `${total} review${total !== 1 ? 's' : ''}`;
        }
        
        const stars = document.querySelectorAll('#rating-display .star-display');
        stars.forEach((star, index) => {
            if (index < Math.floor(average)) {
                star.textContent = '★';
            } else if (index < average) {
                star.textContent = '☆';
            } else {
                star.textContent = '☆';
            }
        });
        
        updateMiniRating(average, total);
    })
    .catch(error => {
        console.error('Error loading stats:', error);
    });

}
    
</script>
<footer class="w-full py-8 text-center text-sm font-light">
    <div class="flex justify-center gap-4 mb-6">
        <a href="https://steamcommunity.com/id/forchange" target="_blank" 
           class="flex items-center justify-center w-12 h-12 bg-blue-600 hover:bg-blue-700 rounded-lg transition-colors duration-300">
            <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/8/83/Steam_icon_logo.svg/768px-Steam_icon_logo.svg.png" alt="Steam" class="w-6 h-6">
        </a>
        
        <a href="https://discord.com/users/866001325657292801" target="_blank" 
           class="flex items-center justify-center w-12 h-12 bg-indigo-600 hover:bg-indigo-700 rounded-lg transition-colors duration-300">
            <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                <path d="M20.317 4.37a19.791 19.791 0 0 0-4.885-1.515.074.074 0 0 0-.079.037c-.211.375-.445.865-.608 1.25a18.27 18.27 0 0 0-5.487 0 12.64 12.64 0 0 0-.617-1.25.077.077 0 0 0-.079-.037A19.736 19.736 0 0 0 3.677 4.37a.07.07 0 0 0-.032.027C.533 9.046-.32 13.58.099 18.057a.082.082 0 0 0 .031.057 19.9 19.9 0 0 0 5.993 3.03.078.078 0 0 0 .084-.028 14.09 14.09 0 0 0 1.226-1.994.076.076 0 0 0-.041-.106 13.107 13.107 0 0 1-1.872-.892.077.077 0 0 1-.008-.128 10.2 10.2 0 0 0 .372-.292.074.074 0 0 1 .077-.01c3.928 1.793 8.18 1.793 12.062 0a.074.074 0 0 1 .078.01c.12.098.246.198.373.292a.077.077 0 0 1-.006.127 12.299 12.299 0 0 1-1.873.892.077.077 0 0 0-.041.107c.36.698.772 1.362 1.225 1.993a.076.076 0 0 0 .084.028 19.839 19.839 0 0 0 6.002-3.03.077.077 0 0 0 .032-.054c.5-5.177-.838-9.674-3.549-13.66a.061.061 0 0 0-.031-.03zM8.02 15.33c-1.183 0-2.157-1.085-2.157-2.419 0-1.333.956-2.419 2.157-2.419 1.21 0 2.176 1.096 2.157 2.42 0 1.333-.956 2.418-2.157 2.418zm7.975 0c-1.183 0-2.157-1.085-2.157-2.419 0-1.333.955-2.419 2.157-2.419 1.21 0 2.176 1.096 2.157 2.42 0 1.333-.946 2.418-2.157 2.418z"/>
            </svg>
        </a>
    </div>
    
    <p>Designed with a smile.</p>
    <p>This website is protected by the <a href="https://aktascorp.com" class="underline">aktascorp group</a></p>
    <p>AppleTV is a brand belonging to Apple Inc. All rights reserved. Netflix is a membership of Netflix Inc. All rights reserved</p>
    <p>The images used are for illustrative purposes and not to pretend to be the producing companies or actors represented on them. These images are even seen to promote the stated content.</p>
</footer>
</body>
</html>