<?php

class CanClient {
    private $can_url = 'https://imators.systems/Can/api';
    
    public function callCan($query) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $this->can_url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode(['query' => $query]));
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        
        $response = curl_exec($ch);
        curl_close($ch);
        
        return json_decode($response, true);
    }
}

$can = new CanClient();

if ($_POST['action'] ?? false) {
    switch ($_POST['action']) {
        case 'add_to_cart':
            $product_id = $_POST['product_id'];
            $quantity = $_POST['quantity'];
            $price = $_POST['price'];
            
            $query = "add line '{$product_id},{$quantity},{$price}' to 'cart.csv', conn to 'file.php'";
            $result = $can->callCan($query);
            break;
            
        case 'calculate_total':
            $query = "get all from 'cart.csv', conn to 'file.php'";
            $cart_items = $can->callCan($query);
            
            $total = 0;
            if ($cart_items['status'] === 'success' && $cart_items['data']) {
                foreach ($cart_items['data'] as $item) {
                    $total += $item['quantity'] * $item['price'];
                }
            }
            break;
            
        case 'clear_cart':
            $query = "update content with '' in 'cart.csv', conn to 'file.php'";
            $result = $can->callCan($query);
            break;
    }
}

$products = [
    ['id' => 1, 'name' => 'iPhone 15', 'price' => 999.99],
    ['id' => 2, 'name' => 'MacBook Pro', 'price' => 2499.99],
    ['id' => 3, 'name' => 'AirPods Pro', 'price' => 249.99],
    ['id' => 4, 'name' => 'iPad Air', 'price' => 599.99],
    ['id' => 5, 'name' => 'Apple Watch', 'price' => 399.99]
];

?>
<!DOCTYPE html>
<html>
<head>
    <title>Imators Shop - Test Can</title>
    <meta charset="utf-8">
    <style>
        body { font-family: Arial, sans-serif; margin: 0; padding: 20px; background: #f5f5f5; }
        .container { max-width: 1200px; margin: 0 auto; background: white; padding: 20px; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        .header { text-align: center; margin-bottom: 30px; }
        .products { display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px; margin-bottom: 30px; }
        .product { border: 1px solid #ddd; padding: 20px; border-radius: 8px; background: #fafafa; }
        .product h3 { margin: 0 0 10px 0; color: #333; }
        .price { font-size: 24px; font-weight: bold; color: #e74c3c; margin: 10px 0; }
        .add-form { display: flex; align-items: center; gap: 10px; }
        .add-form input { padding: 8px; border: 1px solid #ddd; border-radius: 4px; width: 60px; }
        .add-form button { padding: 10px 20px; background: #3498db; color: white; border: none; border-radius: 4px; cursor: pointer; }
        .add-form button:hover { background: #2980b9; }
        .cart-section { background: #ecf0f1; padding: 20px; border-radius: 8px; margin-top: 20px; }
        .cart-actions { display: flex; gap: 10px; margin-top: 15px; }
        .cart-actions button { padding: 12px 24px; border: none; border-radius: 4px; cursor: pointer; font-weight: bold; }
        .calculate-btn { background: #27ae60; color: white; }
        .clear-btn { background: #e74c3c; color: white; }
        .total-display { font-size: 28px; font-weight: bold; color: #27ae60; margin-top: 15px; }
        .can-info { background: #3498db; color: white; padding: 15px; border-radius: 8px; margin-bottom: 20px; }
    </style>
</head>
<body>

<div class="container">
    <div class="header">
        <h1>🛍️ Imators Shop</h1>
        <p>Test de Can - Algorithme de calcul de panier</p>
    </div>
    
    <div class="can-info">
        <strong>Can en action :</strong> Cette page utilise Can pour gérer le panier via des fichiers CSV et calculer les totaux automatiquement.
    </div>

    <div class="products">
        <?php foreach ($products as $product): ?>
        <div class="product">
            <h3><?= htmlspecialchars($product['name']) ?></h3>
            <div class="price">€<?= number_format($product['price'], 2) ?></div>
            
            <form method="post" class="add-form">
                <input type="hidden" name="action" value="add_to_cart">
                <input type="hidden" name="product_id" value="<?= $product['id'] ?>">
                <input type="hidden" name="price" value="<?= $product['price'] ?>">
                <label>Qté:</label>
                <input type="number" name="quantity" value="1" min="1" max="10">
                <button type="submit">Ajouter au panier</button>
            </form>
        </div>
        <?php endforeach; ?>
    </div>

    <div class="cart-section">
        <h2>🛒 Panier (géré par Can)</h2>
        
        <div class="cart-actions">
            <form method="post" style="display: inline;">
                <input type="hidden" name="action" value="calculate_total">
                <button type="submit" class="calculate-btn">Calculer le total avec Can</button>
            </form>
            
            <form method="post" style="display: inline;">
                <input type="hidden" name="action" value="clear_cart">
                <button type="submit" class="clear-btn">Vider le panier</button>
            </form>
        </div>

        <?php if (isset($total)): ?>
        <div class="total-display">
            💰 Total calculé par Can: €<?= number_format($total, 2) ?>
        </div>
        <?php endif; ?>

        <?php if (isset($result)): ?>
        <div style="margin-top: 15px; padding: 10px; background: #d4edda; border-radius: 4px;">
            <strong>Réponse de Can:</strong> <?= htmlspecialchars($result['message']) ?>
            <br><small>Temps d'exécution: <?= $result['execution_time'] ?? 'N/A' ?></small>
        </div>
        <?php endif; ?>
    </div>

    <div style="margin-top: 30px; padding: 15px; background: #f8f9fa; border-radius: 8px; font-size: 14px;">
        <h3>🔧 Requêtes Can utilisées:</h3>
        <ul>
            <li><code>add line '{product_id},{quantity},{price}' to 'cart.csv', conn to 'file.php'</code></li>
            <li><code>get all from 'cart.csv', conn to 'file.php'</code></li>
            <li><code>update content with '' in 'cart.csv', conn to 'file.php'</code></li>
        </ul>
    </div>
</div>

<script>
async function addToCartJS(productId, price) {
    const quantity = prompt('Quantité?', '1');
    if (!quantity) return;
    
    const response = await fetch('http://localhost/can/api', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({
            query: `add line '${productId},${quantity},${price}' to 'cart.csv', conn to 'file.php'`
        })
    });
    
    const result = await response.json();
    console.log('Can response:', result);
    
    if (result.status === 'success') {
        alert('Produit ajouté au panier via Can!');
    }
}
</script>

</body>
</html>