<?php
$transparent_header = true;

require_once 'db.php';
require_once 'imators-systems-scanip.php';

$lang = $_GET['lang'] ?? 'en';
if (!in_array($lang, ['en', 'fr', 'ar', 'nl', 'de'])) {
    $lang = 'en';
}

$translations = json_decode(file_get_contents('translations.json'), true)[$lang];

$sql = "SELECT id, title, content, image_url, DATE_FORMAT(date_created, '%d/%m/%Y') AS formatted_date, 
               author FROM news_blog ORDER BY date_created DESC LIMIT 6";
$stmt = $conn->prepare($sql);
$stmt->execute();
$news = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="<?php echo $lang; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="imators-verification" content="verified">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script defer src="https://cloud.umami.is/script.js" data-website-id="b467e8c1-b13e-4744-80ac-d625ad1403b4"></script>
    <script src="https://imators.statuspage.io/embed/script.js"></script>

<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-MNDDTWSM');</script>
<title>Imators</title>
<meta name="description" content="Imators is a technology company, founded in early 2024 by Izhak Aktas. Our aim is to lay the foundations for the second technological phase the world will experience. It will happen little by little, so that you can enjoy it.">

<meta property="og:url" content="https://imators.com">
<meta property="og:type" content="website">
<meta property="og:title" content="Imators">
<meta property="og:description" content="Imators is a technology company, founded in early 2024 by Izhak Aktas. Our aim is to lay the foundations for the second technological phase the world will experience. It will happen little by little, so that you can enjoy it.">
<meta property="og:image" content="https://opengraph.b-cdn.net/production/images/c2346076-5c2d-4af5-bc04-93187bd10074.png?token=htWPJq1jtmC6T1l0lrysm0HzFmIEpPZpdfjbd2qnjX8&height=630&width=1200&expires=33264233001">

<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:domain" content="imators.com">
<meta name="twitter:url" content="https://imators.com">
<meta name="twitter:title" content="Imators">
<meta name="twitter:description" content="Imators is a technology company, founded in early 2024 by Izhak Aktas. Our aim is to lay the foundations for the second technological phase the world will experience. It will happen little by little, so that you can enjoy it.">
<meta name="twitter:image" content="https://opengraph.b-cdn.net/production/images/c2346076-5c2d-4af5-bc04-93187bd10074.png?token=htWPJq1jtmC6T1l0lrysm0HzFmIEpPZpdfjbd2qnjX8&height=630&width=1200&expires=33264233001">

<meta name="robots" content="index, follow">
<meta name="author" content="Izhak Aktas">
<meta name="keywords" content="Imators, technology company, Izhak Aktas, innovation, second technological phase, future technology">
<link rel="canonical" href="https://imators.com">

<script src="https://cdn.tailwindcss.com"></script>
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;400;500;600;700&display=swap" rel="stylesheet">
<link href="https://imators.com/logo.png" rel="icon" type="image/png" />
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<style>
    body {
        font-family: 'Space Grotesk', sans-serif;
        background-color: #000;
        overflow-x: hidden;
    }

    .header {
        z-index: 1000;
    }

    .zajidhiadj {
        z-index: 1001;
        position: relative;
    }

    .hero-slider {
        width: 100%;
        height: 100vh;
        position: relative;
        overflow: hidden;
    }

    .slider-wrapper {
        width: 400%;
        height: 100%;
        display: flex;
        transition: transform 1.2s cubic-bezier(0.4, 0, 0.2, 1);
    }

    .slide {
        width: 25%;
        height: 100%;
        background-size: cover;
        background-position: center;
        position: relative;
    }

    .slide::before {
        content: '';
        position: absolute;
        inset: 0;
        background: linear-gradient(to bottom, rgba(0,0,0,0.1) 0%, rgba(0,0,0,0.6) 100%);
    }

    .slide-info {
        position: absolute;
        bottom: 10rem;
        left: 50%;
        transform: translateX(-50%);
        text-align: center;
        color: white;
        z-index: 2;
        opacity: 0;
        transform: translateX(-50%) translateY(20px);
        transition: all 0.8s cubic-bezier(0.4, 0, 0.2, 1);
    }

    .slide.active .slide-info {
        opacity: 1;
        transform: translateX(-50%) translateY(0);
    }

    .slide-label {
        font-size: 0.7rem;
        font-weight: 300;
        opacity: 0.7;
        margin-bottom: 0.5rem;
        text-transform: uppercase;
        letter-spacing: 0.15em;
    }

    .slide-title {
        font-size: 2.2rem;
        font-weight: 300;
        margin-bottom: 1rem;
        letter-spacing: -0.02em;
    }

    .slide-desc {
        font-size: 0.95rem;
        font-weight: 300;
        margin-bottom: 2rem;
        opacity: 0.85;
        max-width: 450px;
        line-height: 1.4;
    }

    .slide-link {
        display: inline-block;
        padding: 0.9rem 2.2rem;
        border: 1px solid rgba(255, 255, 255, 0.4);
        color: white;
        text-decoration: none;
        font-size: 0.9rem;
        font-weight: 300;
        border-radius: 50px;
        transition: all 0.4s ease;
        backdrop-filter: blur(10px);
        background: rgba(255, 255, 255, 0.05);
    }

    .slide-link:hover {
        background: rgba(255, 255, 255, 0.1);
        border-color: rgba(255, 255, 255, 0.7);
        transform: translateY(-2px);
    }

    .dots {
        position: absolute;
        bottom: 4rem;
        left: 50%;
        transform: translateX(-50%);
        display: flex;
        gap: 1rem;
        z-index: 10;
    }

    .dot {
        width: 8px;
        height: 8px;
        border-radius: 50%;
        background: rgba(255, 255, 255, 0.3);
        cursor: pointer;
        transition: all 0.4s ease;
    }

    .dot.active {
        background: white;
        transform: scale(1.2);
    }

    .dot:hover {
        background: rgba(255, 255, 255, 0.6);
    }

    @media (max-width: 768px) {
        .slide-title {
            font-size: 1.8rem;
        }
        
        .slide-desc {
            font-size: 0.9rem;
        }
        
        .slide-info {
            bottom: 12rem;
        }
        
        .dots {
            bottom: 8rem;
        }
    }

    @media (min-width: 769px) {
        .desktop-layout {
            display: flex;
            flex-direction: row;
        }
        .desktop-content {
            padding-right: 4rem;
        }
        .desktop-container {
            align-items: center !important;
        }
        .desktop-gradient {
            background: linear-gradient(to bottom, #7c3aed, #ffffff) !important;
        }
    }

    .product-promo {
        display: flex;
        align-items: center;
        gap: 1rem;
        margin-bottom: 2rem;
    }

    .product-logo {
        width: 60px;
        height: 60px;
        border-radius: 12px;
    }

    .promo-button {
        background: linear-gradient(135deg, #7c3aed, #a855f7);
        color: white;
        padding: 0.75rem 1.5rem;
        border-radius: 50px;
        text-decoration: none;
        font-weight: 500;
        font-size: 0.9rem;
        transition: all 0.3s ease;
        border: none;
        cursor: pointer;
    }

    .promo-button:hover {
        transform: translateY(-2px);
        box-shadow: 0 10px 25px rgba(124, 58, 237, 0.3);
        background: linear-gradient(135deg, #8b5cf6, #a855f7);
    }

    .gradient-section {
        min-height: 100vh;
        background: linear-gradient(to bottom, #001f3f, #ffffff, #000000);
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .gradient-content {
        text-align: center;
        max-width: 800px;
        padding: 2rem;
    }

    .gradient-title {
        font-size: 3rem;
        font-weight: 300;
        color: #000000;
        margin-bottom: 1.5rem;
        letter-spacing: -0.02em;
    }

    .gradient-description {
        font-size: 1.1rem;
        font-weight: 300;
        color: #333333;
        line-height: 1.6;
    }

    @media (max-width: 768px) {
        .gradient-title {
            font-size: 2rem;
        }
        
        .gradient-description {
            font-size: 1rem;
        }
    }
</style>
    <script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "Organization",
    "name": "Imators",
    "url": "https://imators.com",
    "logo": "https://imators.com/logo.png",
    "description": "Technology company founded by Izhak Aktas, laying foundations for the second technological phase",
    "founder": {
        "@type": "Person",
        "name": "Izhak Aktas",
        "jobTitle": "CEO & Founder"
    },
    "foundingDate": "2024"
}
</script>

</head>
<body>
    <?php include 'src/header.php'; ?>
    
<section class="gradient-section">
    <div class="gradient-content">
        <h2 class="gradient-title"><?php echo $translations['changing_lives']; ?><br> <?php echo $translations['without_harm']; ?></h2>
        <p class="gradient-description"><?php echo $translations['shape_future']; ?></p>
    </div>
</section>

<footer>
    <div class="max-w-6xl mx-auto px-4 py-6 flex flex-wrap justify-between">
        <div class="w-full md:w-1/3 p-4">
            <h5 class="text-xs uppercase font-medium mb-4"><?php echo $translations['need_help']; ?></h5>
            <a href="/support" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
                <?php echo $translations['support']; ?>
            </a>
            <a href="/contact-us" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
                <?php echo $translations['contact_us']; ?>
            </a>
        </div>
        <div class="w-full md:w-1/3 p-4">
            <h5 class="text-xs uppercase font-medium mb-4"><?php echo $translations['discover']; ?></h5>
            <a href="/privacy" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
                <?php echo $translations['privacy_policy']; ?>
            </a>
            <a href="/terms-of-use" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
                <?php echo $translations['terms_of_use']; ?>
            </a>
            <a href="/refund-policy" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
                <?php echo $translations['refund_policy']; ?>
            </a>
            <a href="/legal-notice" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
                <?php echo $translations['legal_notice']; ?>
            </a>
            <a href="/" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
                <?php echo $translations['home']; ?>
            </a>
            <a href="/about-us" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
                <?php echo $translations['about_us']; ?>
            </a>
        </div>
        <div class="w-full md:w-1/3 p-4">

            <p class="text-sm">
                <?php echo $translations['all_images']; ?>
            </p>
        </div>
    </div>

    <div class="text-center py-3 border-t border-gray-800">
        <p class="text-sm">
            &copy; <?php echo date("Y"); ?> <?php echo $translations['copyright']; ?>
        </p>
        <p class="text-xs mt-2">
            <a href="https://aktascorp.com"><?php echo $translations['imators_aktascorp']; ?></a>
        </p>
        <p class="text-xs">
            <?php echo $translations['registered_llc']; ?>
        </p>
    </div>
</footer>

</body>
</html>