<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="imators-verification" content="verified">
    
    <!-- Google Tag Manager -->
    <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
    new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
    j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
    'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
    })(window,document,'script','dataLayer','GTM-MNDDTWSM');</script>
    <!-- End Google Tag Manager -->
    
    <!-- HTML Meta Tags -->
    <title>Imators</title>
    <meta name="description" content="Imators is a technology company, founded in early 2024 by Izhak Aktas. Our aim is to lay the foundations for the second technological phase the world will experience. It will happen little by little, so that you can enjoy it.">

    <!-- Facebook Meta Tags -->
    <meta property="og:url" content="https://imators.com">
    <meta property="og:type" content="website">
    <meta property="og:title" content="Imators">
    <meta property="og:description" content="Imators is a technology company, founded in early 2024 by Izhak Aktas. Our aim is to lay the foundations for the second technological phase the world will experience. It will happen little by little, so that you can enjoy it.">
    <meta property="og:image" content="https://opengraph.b-cdn.net/production/images/c2346076-5c2d-4af5-bc04-93187bd10074.png?token=htWPJq1jtmC6T1l0lrysm0HzFmIEpPZpdfjbd2qnjX8&height=630&width=1200&expires=33264233001">

    <!-- Twitter Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta property="twitter:domain" content="imators.com">
    <meta property="twitter:url" content="https://imators.com">
    <meta name="twitter:title" content="Imators">
    <meta name="twitter:description" content="Imators is a technology company, founded in early 2024 by Izhak Aktas. Our aim is to lay the foundations for the second technological phase the world will experience. It will happen little by little, so that you can enjoy it.">
    <meta name="twitter:image" content="https://opengraph.b-cdn.net/production/images/c2346076-5c2d-4af5-bc04-93187bd10074.png?token=htWPJq1jtmC6T1l0lrysm0HzFmIEpPZpdfjbd2qnjX8&height=630&width=1200&expires=33264233001">

    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.1.2/dist/tailwind.min.css" rel="stylesheet" />
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Princess+Sofia&family=Space+Grotesk:wght@300;400;500;600;700&family=Fredoka:wght@300..700&family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
    <link href="https://cdn.imators.com/logo.png" rel="icon" type="image/png" />

    <style>

.section-espacer {
    padding-top: 50px;
}

        body {
            font-family: 'Space Grotesk', sans-serif;
            background-color: #000;
        }

                .Poppins {
        font-family: "Poppins", serif;
        font-weight: 400;
        font-style: normal;
        }

        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        .animate-fade-in {
            animation: fadeIn 0.5s ease-out forwards;
        }

        .fredoka {
            font-family: "Fredoka", sans-serif;
            font-optical-sizing: auto;
            font-style: normal;
            font-variation-settings: "wdth" 100;
        }

        .Montserrat {
            font-family: "Montserrat", sans-serif;
            font-optical-sizing: auto;
            font-style: normal;
        }
		        
        .gemance {
            font-family: "Princess Sofia", cursive;
            font-weight: 400;
            font-style: normal;
        }

        .header {
            z-index: 1000;
        }

        .zajidhiadj {
            z-index: 1001;
            position: relative;
        }
    </style>
  
    <script type="text/javascript" src="https://cs.iubenda.com/autoblocking/3689846.js"></script>
    <script type="text/javascript" src="//cdn.iubenda.com/cs/gpp/stub.js"></script>
    <script type="text/javascript" src="//cdn.iubenda.com/cs/iubenda_cs.js" charset="UTF-8" async></script>
</head>
<body class="bg-black">
    <!-- Google Tag Manager (noscript) -->
    <noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-MNDDTWSM"
    height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
    <!-- End Google Tag Manager (noscript) -->
    
    <?php include 'src/header.php'; ?>
         <?php include 'src/content.php'; ?> 
<div id="slider" class="w-full min-h-screen">
   <div class="container relative mx-auto pt-32 pb-24 px-8">
       
       <!-- Loading Spinner -->
       <div id="loader" class="absolute inset-0 bg-black z-50 flex items-center justify-center">
           <div class="loader-spin"></div>
       </div>

       <!-- Slides Container -->
       <div class="slides-container h-[750px] relative">

           <!-- Academ -->
           <div class="slide absolute inset-0 invisible opacity-0">
               <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 lg:gap-24 h-full">
                   <div class="flex flex-col justify-center slide-content">
                       <span class="text-purple-500 text-sm font-semibold tracking-[0.2em] uppercase">Available December 25</span>
                       <h1 class="text-6xl lg:text-7xl text-white font-bold mt-4">Academ</h1>
                       <p class="text-lg text-gray-400 mt-6 max-w-xl">Change school learning forever so you'll never be in trouble again</p>
                       <div class="flex flex-wrap gap-4 mt-8">
                           <a href="/waitlist/academ" class="inline-flex items-center gap-2 border border-purple-500/20 text-purple-500 hover:bg-purple-500/10 px-8 py-4 rounded-xl transition-all hover:-translate-y-0.5">Join the waitlist</a>
                       </div>
                   </div>
                   <div class="relative h-full rounded-2xl overflow-hidden">
                       <div class="absolute inset-0 bg-gradient-to-t from-black/80 to-transparent z-10"></div>
                       <img src="design5.png" class="w-full h-full object-cover scale-110" alt="Academ">
                   </div>
               </div>
           </div>
           
                     <!-- Something -->
           <div class="slide absolute inset-0 invisible opacity-0">
               <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 lg:gap-24 h-full">
                   <div class="flex flex-col justify-center slide-content">
                       <span class="text-sm font-semibold tracking-[0.2em] uppercase">Available March 10</span>
                       <h1 class="text-6xl lg:text-7xl text-white font-bold mt-4">Something</h1>
                       <p class="text-lg text-gray-400 mt-6 max-w-xl">Enable each club to be accessible to parents, organizers and children in the same place</p>
                       <div class="flex flex-wrap gap-4 mt-8">
                           <a href="/waitlist/something" class="inline-flex items-center gap-2 border border-white text-white hover:bg-yellow-500/10 px-8 py-4 rounded-xl transition-all hover:-translate-y-0.5">Join the waitlist</a>
                       </div>
                   </div>
                   <div class="relative h-full rounded-2xl overflow-hidden">
                       <div class="absolute inset-0 bg-gradient-to-t from-black/80 to-transparent z-10"></div>
                       <img src="Something_cube.png" class="w-full h-full object-cover scale-110" alt="Something">
                   </div>
               </div>
           </div>

           <!-- Progm -->
           <div class="slide absolute inset-0 invisible opacity-0">
               <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 lg:gap-24 h-full">
                   <div class="flex flex-col justify-center slide-content">
                       <span class="text-teal-500 text-sm font-semibold tracking-[0.2em] uppercase">Windows & MacOS</span>
                       <h1 class="text-6xl lg:text-7xl text-white font-bold mt-4">Progm</h1>
                       <p class="text-lg text-gray-400 mt-6 max-w-xl">A modern, minimalist temp program on a screen</p>
                       <div class="flex flex-wrap gap-4 mt-8">
                           <a href="/progm" class="group inline-flex items-center gap-2 bg-teal-500 hover:bg-teal-400 px-8 py-4 rounded-xl text-white font-medium transition-all hover:-translate-y-0.5">
                               <span>Download Now</span>
                               <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4"/></svg>
                           </a>
                           <a href="/progm" class="inline-flex items-center gap-2 border border-teal-500/20 text-teal-500 hover:bg-teal-500/10 px-8 py-4 rounded-xl transition-all hover:-translate-y-0.5">Features</a>
                       </div>
                   </div>
                   <div class="relative h-full rounded-2xl overflow-hidden">
                       <div class="absolute inset-0 bg-gradient-to-t from-black/80 to-transparent z-10"></div>
                       <img src="https://cdn.imators.com/Progm_Cube.png" class="w-full h-full object-cover scale-110" alt="Progm">
                   </div>
               </div>
           </div>

           <!-- OhMyPanel -->
           <div class="slide absolute inset-0 invisible opacity-0">
               <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 lg:gap-24 h-full">
                   <div class="flex flex-col justify-center slide-content">
                       <span class="text-indigo-500 text-sm font-semibold tracking-[0.2em] uppercase">Coming Soon</span>
                       <h1 class="text-6xl lg:text-7xl text-white font-bold mt-4">OhMyPanel</h1>
                       <p class="text-lg text-gray-400 mt-6 max-w-xl">One thing that could revolutionize commerce forever</p>
                       <div class="flex flex-wrap gap-4 mt-8">
                           <button class="group inline-flex items-center gap-2 bg-indigo-500/50 px-8 py-4 rounded-xl text-white font-medium transition-all cursor-not-allowed opacity-75">
                               <span>Coming Soon</span>
                           </button>
                           <a href="/waitlist/ohmypanel" class="inline-flex items-center gap-2 border border-indigo-500/20 text-indigo-500 hover:bg-indigo-500/10 px-8 py-4 rounded-xl transition-all hover:-translate-y-0.5">Join Waitlist</a>
                       </div>
                   </div>
                   <div class="relative h-full rounded-2xl overflow-hidden">
                       <div class="absolute inset-0 bg-gradient-to-t from-black/80 to-transparent z-10"></div>
                       <img src="design3.png" class="w-full h-full object-cover scale-110" alt="OhMyPanel">
                   </div>
               </div>
           </div>
       </div>

       <!-- Navigation -->
       <div class="flex gap-4 mt-12">
           <button class="w-3 h-3 rounded-full bg-white/20 hover:bg-white/40 transition-all" data-slide="0"></button>
           <button class="w-3 h-3 rounded-full bg-white/20 hover:bg-white/40 transition-all" data-slide="1"></button>
           <button class="w-3 h-3 rounded-full bg-white/20 hover:bg-white/40 transition-all" data-slide="2"></button>
           <button class="w-3 h-3 rounded-full bg-white/20 hover:bg-white/40 transition-all" data-slide="3"></button>
       </div>

       <!-- Arrows -->
       <button id="prevSlide" class="absolute top-1/2 -translate-y-1/2 -left-16 p-2 text-white/50 hover:text-white transition-all hover:scale-110">
           <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
               <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
           </svg>
       </button>
       <button id="nextSlide" class="absolute top-1/2 -translate-y-1/2 -right-16 p-2 text-white/50 hover:text-white transition-all hover:scale-110">
           <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
               <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
           </svg>
       </button>
   </div>
</div>

<style>
.loader-spin {
   width: 48px;
   height: 48px;
   border: 5px solid #fff;
   border-bottom-color: transparent;
   border-radius: 50%;
   animation: rotation 1s linear infinite;
}

@keyframes rotation {
   0% { transform: rotate(0deg) }
   100% { transform: rotate(360deg) }
}

.slide {
   opacity: 0;
   visibility: hidden;
   transition: all 0.6s cubic-bezier(0.4, 0, 0.2, 1);
}

.slide.active {
   opacity: 1;
   visibility: visible;
   z-index: 1;
}

.slide-content > * {
   opacity: 0;
   transform: translateY(20px);
   transition: all 0.6s cubic-bezier(0.4, 0, 0.2, 1);
}

.slide.active .slide-content > * {
   opacity: 1;
   transform: translateY(0);
}

.slide.active .slide-content > *:nth-child(1) { transition-delay: 200ms; }
.slide.active .slide-content > *:nth-child(2) { transition-delay: 300ms; }
.slide.active .slide-content > *:nth-child(3) { transition-delay: 400ms; }
.slide.active .slide-content > *:nth-child(4) { transition-delay: 500ms; }

.slide img {
   transform: scale(1.1);
   transition: transform 1.2s cubic-bezier(0.4, 0, 0.2, 1);
}

.slide.active img {
   transform: scale(1);
}

@media (max-width: 1024px) {
   .slides-container {
       height: auto;
       min-height: 600px;
   }
   
   #prevSlide, #nextSlide {
       display: none;
   }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', () => {
   class Slider {
       constructor() {
           // Elements
           this.slider = document.querySelector('#slider');
           this.slidesContainer = document.querySelector('.slides-container');
           this.slides = document.querySelectorAll('.slide');
           this.dots = document.querySelectorAll('[data-slide]');
           this.prevBtn = document.getElementById('prevSlide');
           this.nextBtn = document.getElementById('nextSlide');
           this.loader = document.getElementById('loader');

           // tat
           this.currentSlide = 0;
           this.isAnimating = false;
           this.autoplayInterval = null;
           this.touchStartX = 0;
           this.touchEndX = 0;

           // Config
           this.autoplayDelay = 5000;
           this.animationDuration = 600;

           // Init
           this.init();
       }

       init() {
           // Preload images
           this.preloadImages().then(() => {
               // Cache le loader une fois les images charges
               if (this.loader) this.loader.style.display = 'none';
               
               // Active le premier slide
               this.slides[0].classList.add('active', 'visible');
               this.dots[0].classList.add('bg-white');

               // Dmarre l'autoplay
               this.startAutoplay();

               // Bind events
               this.bindEvents();
           });
       }

       async preloadImages() {
           const images = Array.from(this.slidesContainer.getElementsByTagName('img'));
           const imagePromises = images.map(img => {
               return new Promise((resolve) => {
                   if (img.complete) resolve();
                   img.onload = () => resolve();
                   img.onerror = () => resolve();
               });
           });
           return Promise.all(imagePromises);
       }

       showSlide(index, direction = 'next') {
           if (this.isAnimating) return;
           this.isAnimating = true;

           // Reset classes
           this.slides[this.currentSlide].classList.remove('active', 'visible');
           this.dots[this.currentSlide].classList.remove('bg-white');

           // Update current slide
           this.currentSlide = index;

           // Add new classes
           this.slides[this.currentSlide].classList.add('active', 'visible');
           this.dots[this.currentSlide].classList.add('bg-white');

           // Reset animation lock
           setTimeout(() => {
               this.isAnimating = false;
           }, this.animationDuration);
       }

       next() {
           const nextIndex = (this.currentSlide + 1) % this.slides.length;
           this.showSlide(nextIndex, 'next');
       }

       prev() {
           const prevIndex = (this.currentSlide - 1 + this.slides.length) % this.slides.length;
           this.showSlide(prevIndex, 'prev');
       }

       startAutoplay() {
           if (this.autoplayInterval) this.stopAutoplay();
           this.autoplayInterval = setInterval(() => this.next(), this.autoplayDelay);
       }

       stopAutoplay() {
           if (this.autoplayInterval) {
               clearInterval(this.autoplayInterval);
               this.autoplayInterval = null;
           }
       }

       handleTouchStart(e) {
           this.touchStartX = e.touches[0].clientX;
       }

       handleTouchMove(e) {
           if (!this.touchStartX) return;
           this.touchEndX = e.touches[0].clientX;
       }

       handleTouchEnd() {
           if (!this.touchStartX || !this.touchEndX) return;

           const diff = this.touchStartX - this.touchEndX;
           const threshold = 50;

           if (Math.abs(diff) > threshold) {
               if (diff > 0) this.next();
               else this.prev();
           }

           this.touchStartX = 0;
           this.touchEndX = 0;
       }

       bindEvents() {
           // Navigation dots
           this.dots.forEach((dot, index) => {
               dot.addEventListener('click', () => {
                   if (index === this.currentSlide) return;
                   this.stopAutoplay();
                   this.showSlide(index);
                   this.startAutoplay();
               });
           });

           // Prev/Next buttons
           this.prevBtn.addEventListener('click', () => {
               this.stopAutoplay();
               this.prev();
               this.startAutoplay();
           });

           this.nextBtn.addEventListener('click', () => {
               this.stopAutoplay();
               this.next();
               this.startAutoplay();
           });

           // Keyboard navigation
           document.addEventListener('keydown', (e) => {
               if (e.key === 'ArrowRight') {
                   this.stopAutoplay();
                   this.next();
                   this.startAutoplay();
               }
               if (e.key === 'ArrowLeft') {
                   this.stopAutoplay();
                   this.prev();
                   this.startAutoplay();
               }
           });

           // Touch events
           this.slider.addEventListener('touchstart', (e) => this.handleTouchStart(e), { passive: true });
           this.slider.addEventListener('touchmove', (e) => this.handleTouchMove(e), { passive: true });
           this.slider.addEventListener('touchend', () => this.handleTouchEnd());

           // Mouse hover pause
           this.slidesContainer.addEventListener('mouseenter', () => this.stopAutoplay());
           this.slidesContainer.addEventListener('mouseleave', () => this.startAutoplay());

           // Visibility change
           document.addEventListener('visibilitychange', () => {
               if (document.hidden) this.stopAutoplay();
               else this.startAutoplay();
           });

           // Window blur/focus
           window.addEventListener('blur', () => this.stopAutoplay());
           window.addEventListener('focus', () => this.startAutoplay());
       }
   }

   // Initialize slider
   new Slider();
});
</script>

    <footer class="bg-black text-white">
        <div class="max-w-6xl mx-auto px-4 py-10 flex flex-wrap justify-between">
            <div class="w-full md:w-1/3 p-5">
            <h5 class="text-xs uppercase font-medium mb-6">Follow Us</h5>
                <div class="flex items-center space-x-4">
                    <a href="https://instagram.com/this.is.imators" class="text-sm font-medium duration-700 hover:text-gray-100 flex items-center">
                        <img src="https://uxwing.com/wp-content/themes/uxwing/download/brands-and-social-media/instagram-white-icon.png" alt="Instagram" class="w-6 h-6 mr-2">
                        <span>Instagram</span>
                    </a>
                </div>
            </div>
            <div class="w-full md:w-1/3 p-5">
                <h5 class="text-xs uppercase font-medium mb-6">Discover</h5>
                <a href="/privacy" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">Privacy Policy</a>
                <a href="/terms-of-use" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">Terms of Use</a>
                <a href="/" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">Home</a>
                <a href="/about-us" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">About Us</a>
                <a href="/contact-us" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">Contact Us</a>
            </div>
            <div class="w-full md:w-1/3 p-5">
                <h5 class="text-xs uppercase font-medium mb-6">Possible reality</h5>
                <p class="text-sm">All images, videos, and content on this site are the property of Imators.</p>
            </div>
        </div>
        <div class="text-center py-4 border-t border-gray-800">
            <p class="text-sm mb-2">&copy; 2024 Imators. All rights reserved.</p>
            <p class="text-xs">Imators is a registered LLC (Limited Liability Company). All our products, whether technologically physical or simply online, are subject to our rules, which you can access.</p>
        </div>
    </footer>
  
</body>
</html>