<?php
require_once 'db.php';

function getVisitorIP() {
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        return $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        return $_SERVER['HTTP_X_FORWARDED_FOR'];
    } else {
        return $_SERVER['REMOTE_ADDR'];
    }
}

function getCountryFromIP($ip) {
    $url = "http://ip-api.com/json/{$ip}";
    $response = file_get_contents($url);
    $data = json_decode($response, true);
    return $data['country'] ?? 'Unknown';
}

function getBrowserLanguage() {
    $languages = $_SERVER['HTTP_ACCEPT_LANGUAGE'] ?? '';
    $primary_language = explode(',', $languages)[0] ?? 'Unknown';
    return explode(';', $primary_language)[0];
}

function getVisitorTimezone($ip) {
    $url = "http://ip-api.com/json/{$ip}";
    $response = file_get_contents($url);
    $data = json_decode($response, true);
    $timezone = $data['timezone'] ?? 'UTC';
    
    $date = new DateTime('now', new DateTimeZone($timezone));
    return $date->format('Y-m-d H:i:s');
}

$visitor_ip = getVisitorIP();
$country = getCountryFromIP($visitor_ip);
$language = getBrowserLanguage();
$local_time = getVisitorTimezone($visitor_ip);

try {
    $stmt = $conn->prepare("INSERT INTO visitors (ip_address, country, language, local_time, visit_date) VALUES (?, ?, ?, ?, NOW())");
    $stmt->execute([$visitor_ip, $country, $language, $local_time]);
} catch (PDOException $e) {
}
?>