<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Vérification réussie</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        .success-icon {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            background: linear-gradient(135deg, #10B981, #34D399);
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 24px;
        }
    </style>
</head>
<body class="bg-black text-white min-h-screen">
    <div class="container mx-auto px-6 py-8 max-w-lg">
        <div class="mb-8">
            <div class="flex items-center justify-between mb-4">
                <h1 class="text-2xl font-light">Imators Identity</h1>
                <span class="text-sm text-gray-400" id="service-name">Service</span>
            </div>
            <div class="w-full bg-gray-800 rounded-full h-1">
                <div class="bg-white h-1 rounded-full" style="width: 100%"></div>
            </div>
        </div>

        <div class="text-center space-y-6">
            <div class="success-icon">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-12 w-12 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                </svg>
            </div>

            <h2 class="text-3xl font-light">Vérification réussie !</h2>
            <p class="text-gray-400 text-sm">
                Votre vérification d'identité a été envoyée avec succès.<br>
                Vous recevrez une confirmation de la part du service envoyeur sous 48 heures.
            </p>

            <div class="mt-12">
                <button class="w-full bg-white text-black py-4 rounded-2xl font-medium hover:bg-gray-100 transition-colors" id="return-btn">
                    Retour à l'accueil
                </button>
            </div>
        </div>
    </div>

    <script>
        const urlParams = new URLSearchParams(window.location.search);
        const service = Object.keys(Object.fromEntries(urlParams))[0] || 'Service';
        document.getElementById('service-name').textContent = service.charAt(0).toUpperCase() + service.slice(1);

        document.getElementById('return-btn').addEventListener('click', () => {
            window.location.href = 'index.html';
        });
    </script>
</body>
</html>
