<!DOCTYPE html>

<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>AktasCorp Hotel</title>
    <link rel="icon" type="image/png" href="ac.png">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Raleway:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Raleway', sans-serif;
        }
    </style>
</head>
<body class="bg-white text-gray-900">
    <div class="min-h-screen flex items-center justify-center px-6">
        <div class="text-center">
            <h1 class="text-4xl font-light mb-8">aktascorp hotel</h1>
            <p class="text-sm font-light mb-8">the simple place for cool vacation</p>

        <button onclick="openMenu()" class="bg-black text-white px-8 py-3 rounded-full hover:bg-gray-800 transition-colors">
            Discover our resorts
        </button>
    </div>
</div>

<div id="menu-overlay" class="fixed inset-0 bg-white z-50 hidden">
    <div class="min-h-screen flex flex-col">
        <div class="flex justify-between items-center p-6">
            <h2 class="text-2xl font-light">Our Resorts</h2>
            <button onclick="closeMenu()" class="text-gray-400 hover:text-gray-600">
                <span class="text-3xl">×</span>
            </button>
        </div>
        
        <div class="flex-1 flex items-center justify-center">
            <div class="text-center space-y-8">
                <div class="space-y-6">
                    <a href="#" class="block text-xl text-gray-700 hover:text-black transition-colors">
                        aktas turkish attitude resort
                    </a>
                    <a href="#" class="block text-xl text-gray-700 hover:text-black transition-colors">
                       aktas marrakech resort
                    </a>
                    <a href="/aktashomeresort" class="block text-xl text-gray-700 hover:text-black transition-colors">
                        aktas home resort
                    </a>
                    <a href="#" class="block text-xl text-gray-700 hover:text-black transition-colors">
                        aktas mijas resort
                    </a>
                    <a href="#" class="block text-xl text-gray-700 hover:text-black transition-colors">
                        aktas dubai resort
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    function openMenu() {
        document.getElementById('menu-overlay').classList.remove('hidden');
    }

    function closeMenu() {
        document.getElementById('menu-overlay').classList.add('hidden');
    }

    document.getElementById('menu-overlay').addEventListener('click', function(e) {
        if (e.target === this) {
            closeMenu();
        }
    });
</script>

</body>
</html>