<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

require_once 'config.php';

$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

if ($conn->connect_error) {
    echo json_encode(['success' => false, 'error' => 'Database connection failed']);
    exit;
}

$userId = intval($_GET['userId']);

$sql = "SELECT id, title, description, left_score, right_score, duration, satisfaction, DATE_FORMAT(created_at, '%d/%m/%Y') as date
        FROM sessions
        WHERE user_id = $userId
        ORDER BY created_at DESC";

$result = $conn->query($sql);

$sessions = [];

if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $minutes = floor($row['duration'] / 60);
        $seconds = $row['duration'] % 60;
        $durationFormatted = sprintf("%02d:%02d", $minutes, $seconds);
        
        $sessions[] = [
            'id' => intval($row['id']),
            'title' => $row['title'],
            'description' => $row['description'] ?? '',
            'leftScore' => intval($row['left_score']),
            'rightScore' => intval($row['right_score']),
            'duration' => $durationFormatted,
            'satisfaction' => intval($row['satisfaction']),
            'date' => $row['date']
        ];
    }
}

echo json_encode(['sessions' => $sessions]);

$conn->close();
?>