<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

require_once 'config.php';

$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

if ($conn->connect_error) {
    echo json_encode(['success' => false, 'error' => 'Database connection failed']);
    exit;
}

$userId = intval($_GET['userId']);

error_log("Getting profile for userId: " . $userId);

$sql = "SELECT first_name, last_name, profile_image, years_playing, hours_per_week, DATE_FORMAT(created_at, '%Y') as member_since FROM users WHERE id = $userId";

$result = $conn->query($sql);

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    error_log("Profile found: " . json_encode($row));
    echo json_encode([
        'firstName' => $row['first_name'] ?? '',
        'lastName' => $row['last_name'] ?? '',
        'profileImage' => $row['profile_image'],
        'yearsPlaying' => intval($row['years_playing']),
        'hoursPerWeek' => intval($row['hours_per_week']),
        'memberSince' => $row['member_since']
    ]);
} else {
    error_log("No profile found for userId: " . $userId);
    echo json_encode([
        'firstName' => '',
        'lastName' => '',
        'profileImage' => null,
        'yearsPlaying' => 0,
        'hoursPerWeek' => 0,
        'memberSince' => date('Y')
    ]);
}

$conn->close();
?>