<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

require_once 'config.php';

$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

if ($conn->connect_error) {
    echo json_encode(['success' => false, 'error' => 'Database connection failed']);
    exit;
}

$userId = intval($_GET['userId']);

$sql = "SELECT g.id, g.name, g.invite_code,
        (SELECT COUNT(*) FROM group_members WHERE group_id = g.id) as members_count,
        (SELECT message FROM announcements WHERE group_id = g.id ORDER BY created_at DESC LIMIT 1) as last_announcement,
        gm.is_admin
        FROM groups_table g
        INNER JOIN group_members gm ON gm.group_id = g.id
        WHERE gm.user_id = $userId
        ORDER BY g.created_at DESC";

$result = $conn->query($sql);

$groups = [];

if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $groups[] = [
            'id' => intval($row['id']),
            'name' => $row['name'],
            'membersCount' => intval($row['members_count']),
            'lastAnnouncement' => $row['last_announcement'] ?? '',
            'inviteCode' => $row['invite_code'],
            'isAdmin' => (bool)$row['is_admin']
        ];
    }
}

echo json_encode(['groups' => $groups]);

$conn->close();
?>