<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

require_once 'config.php';

$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

if ($conn->connect_error) {
    echo json_encode(['success' => false, 'error' => 'Database connection failed']);
    exit;
}

$groupId = intval($_GET['groupId']);

$sql = "SELECT gp.id, gp.photo_url, CONCAT(u.first_name, ' ', u.last_name) as uploaded_by, DATE_FORMAT(gp.created_at, '%d/%m/%Y') as date
        FROM group_photos gp
        INNER JOIN users u ON u.id = gp.user_id
        WHERE gp.group_id = $groupId
        ORDER BY gp.created_at DESC";

$result = $conn->query($sql);

$photos = [];

if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $photos[] = [
            'id' => intval($row['id']),
            'url' => $row['photo_url'],
            'uploadedBy' => $row['uploaded_by'],
            'date' => $row['date']
        ];
    }
}

echo json_encode(['photos' => $photos]);

$conn->close();
?>