<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

require_once 'config.php';

$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

if ($conn->connect_error) {
    echo json_encode(['success' => false, 'error' => 'Database connection failed']);
    exit;
}

$groupId = intval($_GET['groupId']);

$sql = "SELECT u.id, u.first_name, u.last_name, u.profile_image, gm.is_admin, DATE_FORMAT(gm.joined_at, '%d/%m/%Y') as joined_date
        FROM users u
        INNER JOIN group_members gm ON gm.user_id = u.id
        WHERE gm.group_id = $groupId
        ORDER BY gm.is_admin DESC, u.first_name";

$result = $conn->query($sql);

$members = [];

if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $members[] = [
            'id' => intval($row['id']),
            'firstName' => $row['first_name'],
            'lastName' => $row['last_name'],
            'profileImage' => $row['profile_image'],
            'isAdmin' => (bool)$row['is_admin'],
            'joinedDate' => $row['joined_date']
        ];
    }
}

echo json_encode(['members' => $members]);

$conn->close();
?>