<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

require_once 'config.php';

$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

if ($conn->connect_error) {
    echo json_encode(['success' => false, 'error' => 'Database connection failed']);
    exit;
}

$groupId = intval($_GET['groupId']);
$userId = intval($_GET['userId']);

$sql = "SELECT e.id, e.title, e.description, DATE_FORMAT(e.event_date, '%d/%m/%Y %H:%i') as date,
        (SELECT COUNT(*) FROM event_participants WHERE event_id = e.id AND status = 'going') as participants_count,
        (SELECT status FROM event_participants WHERE event_id = e.id AND user_id = $userId) as user_status
        FROM events e
        WHERE e.group_id = $groupId
        ORDER BY e.event_date DESC";

$result = $conn->query($sql);

$events = [];

if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $events[] = [
            'id' => intval($row['id']),
            'title' => $row['title'],
            'description' => $row['description'] ?? '',
            'date' => $row['date'],
            'participantsCount' => intval($row['participants_count']),
            'userStatus' => $row['user_status']
        ];
    }
}

echo json_encode(['events' => $events]);

$conn->close();
?>