<?php
require_once 'config.php';

header('Content-Type: application/json');

if(isset($_GET['video_id'])) {
    $video_id = (int)$_GET['video_id'];
    
    $stmt = $pdo->prepare("
        SELECT 
            i.id,
            i.user_id,
            i.comment_text,
            i.created_at,
            u.username,
            u.avatar_url
        FROM interactions i
        JOIN users u ON i.user_id = u.id
        WHERE i.content_id = ? 
        AND i.type = 'comment'
        ORDER BY i.created_at DESC
    ");
    $stmt->execute([$video_id]);
    $comments = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Formater la date pour chaque commentaire
    foreach($comments as &$comment) {
        $date = new DateTime($comment['created_at']);
        $comment['created_at'] = $date->format('d M Y, H:i');
        $comment['username'] = htmlspecialchars($comment['username']);
        $comment['comment_text'] = htmlspecialchars($comment['comment_text']);
    }

    echo json_encode($comments);
} else {
    http_response_code(400);
    echo json_encode(['error' => 'Video ID required']);
}
?>