<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

require_once 'config.php';

$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

if ($conn->connect_error) {
    echo json_encode(['success' => false, 'error' => 'Database connection failed']);
    exit;
}

$groupId = intval($_GET['groupId']);
$userId = intval($_GET['userId']);

$sql = "SELECT a.id, a.message, DATE_FORMAT(a.created_at, '%d/%m/%Y %H:%i') as date,
        CONCAT(u.first_name, ' ', u.last_name) as author_name,
        u.profile_image as author_image,
        (SELECT COUNT(*) FROM announcement_reactions WHERE announcement_id = a.id AND reaction = 'like') as likes_count,
        (SELECT COUNT(*) FROM announcement_reactions WHERE announcement_id = a.id AND reaction = 'dislike') as dislikes_count,
        (SELECT reaction FROM announcement_reactions WHERE announcement_id = a.id AND user_id = $userId) as user_reaction
        FROM announcements a
        INNER JOIN users u ON u.id = a.user_id
        WHERE a.group_id = $groupId
        ORDER BY a.created_at DESC";

$result = $conn->query($sql);

$announcements = [];

if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $announcements[] = [
            'id' => intval($row['id']),
            'authorName' => $row['author_name'],
            'authorImage' => $row['author_image'],
            'message' => $row['message'],
            'date' => $row['date'],
            'likesCount' => intval($row['likes_count']),
            'dislikesCount' => intval($row['dislikes_count']),
            'userReaction' => $row['user_reaction']
        ];
    }
}

echo json_encode(['announcements' => $announcements]);

$conn->close();
?>