<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Parade Display - Imators</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(to bottom, white, #e0f0ff);
            min-height: 100vh;
        }
        .fade-transition {
            transition: all 1s ease;
        }
        .fade-transition.hidden {
            opacity: 0;
        }
        .presentation-overlay {
            opacity: 0;
            transform: translateY(20px);
            transition: all 0.5s ease;
            background: black;
        }
        .presentation-overlay.visible {
            opacity: 1;
            transform: translateY(0);
        }
    </style>
</head>
<body>
    <div id="defaultContent" class="fade-transition flex flex-col items-center justify-center min-h-screen p-8">
        <img src="theframe_remove.png" alt="Image centrale" class="w-96 h-auto mb-8">
    </div>

    <div id="presentationOverlay" class="presentation-overlay fixed inset-0 flex items-center justify-center">
        <div class="flex items-center space-x-4">
            <span class="text-2xl text-white">Presented by</span>
            <img src="https://cdn.imators.com/logo.png" alt="Imators Logo" class="w-32 h-auto">
        </div>
    </div>

    <video id="videoPlayer" class="hidden fixed inset-0 w-full h-full object-cover" autoplay muted playsinline></video>

    <script>
    async function checkSchedule() {
        try {
            const response = await fetch('data.json');
            const data = await response.json();
            
            if (data.url && data.startTime) {
                const now = new Date();
                const startTime = new Date(data.startTime);
                const prepTime = (data.prepTime || 15) * 1000;
                const timeUntilStart = startTime - now;

                if (timeUntilStart <= prepTime && timeUntilStart > 0) {
                    const defaultContent = document.getElementById('defaultContent');
                    const presentationOverlay = document.getElementById('presentationOverlay');
                    const videoPlayer = document.getElementById('videoPlayer');

                    defaultContent.classList.add('hidden');

                    setTimeout(() => {
                        presentationOverlay.classList.add('visible');
                    }, 500);

                    videoPlayer.src = data.url;
                    videoPlayer.load();

                    setTimeout(() => {
                        presentationOverlay.classList.remove('visible');
                        setTimeout(() => {
                            videoPlayer.classList.remove('hidden');
                            videoPlayer.play().catch(error => console.error('Erreur de lecture:', error));
                            
                            videoPlayer.onended = () => {
                                videoPlayer.classList.add('hidden');
                                defaultContent.classList.remove('hidden');
                                presentationOverlay.classList.remove('visible');
                            };
                        }, 500);
                    }, timeUntilStart - 500);
                }
            }
        } catch (error) {
            console.error('Erreur lors de la lecture du fichier data.json:', error);
        }
    }

    setInterval(checkSchedule, 1000);
    checkSchedule();
    </script>
</body>
</html>