<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Imators</title>
    <link href="https://cdn.imators.com/logo.png" rel="icon" type="image/png" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/tailwindcss@2.1.2/dist/tailwind.min.css">
    <link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.min.css" />
    <script src="https://cdn.jsdelivr.net/npm/alpinejs@2.8.0/dist/alpine.min.js" defer></script>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;400;500;600;700&display=swap');
        body {
            font-family: 'Space Grotesk', sans-serif;
        }
        
        .gradient-background {
            background: rgb(34,193,195);
            background: linear-gradient(0deg, rgba(34,193,195,1) 0%, rgba(167,45,253,1) 100%);
            color: #FFFFFF;
        }

        header {
            background-color: rgba(0, 0, 0, 0.8); 
            transition: background-color 0.5s;
        }
        .menu-link {
            transition: color 0.3s ease-in-out;
            color: #FFF !important; 
        }
        .footer, .mobile-menu {
            background-color: #111827;
            color: #FFF;
        }

        .coc {
            background-color: #111827;
        }

        .timeline {
            position: relative;
        }
        .timeline::before {
            content: '';
            position: absolute;
            left: 50%;
            transform: translateX(-50%);
            top: 0;
            bottom: 0;
            width: 2px;
            background: #D1D5DB;
        }
        .timeline-item {
            position: relative;
            width: 100%;
            padding: 10px 40px;
            margin-bottom: 20px;
        }
        .timeline-marker {
            position: absolute;
            top: 15px;
            left: 50%;
            transform: translateX(-50%);
            height: 20px;
            width: 20px;
            border-radius: 50%;
            background: #3B82F6;
        }
        .timeline-content {
            max-width: 40%;
            padding: 20px;
            background: #F9FAFB;
            border-radius: 8px;
        }
        .timeline-item:nth-child(even) .timeline-content {
            margin-left: auto;
            background: #EFF6FF;
        }

        .parallax-container {
            perspective: 2px;
        }
        .parallax-background {
            transform: translateZ(-1px) scale(2);
            min-height: 100vh;
            background-size: cover;
            background-position: center;
        }
        .content {
            position: relative;
        }
        
        .fade-in-section {
            transition: opacity 0.6s ease-out, transform 1s ease-out;
            opacity: 0;
            transform: translateY(20px);
            visibility: hidden;
        }
        .fade-in-section.is-visible {
            opacity: 1;
            transform: none;
            visibility: visible;
        }

        @keyframes gradient {
            0% {
                background-position: 0% 50%;
            }
            50% {
                background-position: 100% 50%;
            }
            100% {
                background-position: 0% 50%;
            }
        }

        .gradient-bg {
            background: linear-gradient(-45deg, #6b1839, #1c4b82, #076b3b);
            background-size: 400% 400%;
            animation: gradient 15s ease infinite;
        }

        .rounded-image {
            border-radius: 1rem;
            overflow: hidden;
        }
    </style>
</head>
<body class="bg-black text-white">
<?php include 'src/header.php'; ?>
    <section class="py-20">
        <div class="container px-4 mx-auto">
            <div class="max-w-xl lg:max-w-2xl mx-auto text-center"></div>
        </div>
        <div class="h-96 mb-12 lg:mb-16">
            <img class="w-full h-full object-cover" src="banner.png" alt="">
        </div>
        <div class="container px-4 mx-auto">
            <div class="max-w-2xl mx-auto">
                <p class="mb-6 lg:mb-8 text-lg leading-loose lg:text-xl lg:leading-relaxed text-gray-500">Depuis les ann&eacute;es 2000, le monde technologique a &eacute;t&eacute; marqu&eacute; par une phase caract&eacute;ris&eacute;e par l'&eacute;mergence et la cr&eacute;ation de technologies innovantes et nouvelles, comme la sortie de t&eacute;l&eacute;phones et d'ordinateurs puissants, et le d&eacute;veloppement de r&eacute;seaux internationaux. Cette &egrave;re a fondamentalement transform&eacute; notre fa&ccedil;on de communiquer et d'interagir &agrave; l'&eacute;chelle mondiale.
</p>
                <p class="mb-6 lg:mb-8 text-lg leading-loose lg:text-xl lg:leading-relaxed text-gray-500">Imators aspire &agrave; cr&eacute;er la deuxi&egrave;me phase que le monde va conna&icirc;tre. Bien que nous puissions &ecirc;tre accompagn&eacute;s ou devanc&eacute;s par d'autres, notre objectif reste unique : &ecirc;tre omnipr&eacute;sent dans l'enti&egrave;ret&eacute; des activit&eacute;s quotidiennes de l'humain tout en apportant quelque chose de r&eacute;ellement b&eacute;n&eacute;fique sans les s&eacute;parer du monde r&eacute;el. Nous visons &agrave; int&eacute;grer la technologie de mani&egrave;re fluide tout en pr&eacute;servant l'authenticit&eacute; et la connexion humaine.
</p>
                <p class="text-lg leading-loose lg:text-xl lg:leading-relaxed text-gray-500">Nous nous concentrons sur l'impl&eacute;mentation de la technologie dans un quotidien b&eacute;n&eacute;fique et &eacute;volutif pour permettre un mode de vie plus confortable tout en restant les administrateurs de notre vie, veillant &agrave; ne pas nous laisser contr&ocirc;ler par les machines. Notre vision met l'accent sur l'autonomisation humaine par la technologie plut&ocirc;t que sur la d&eacute;pendance. La fain&eacute;antise est un fl&eacute;au qu'Imators veut repousser en fondant un empire de c&eacute;r&eacute;braux, o&ugrave; tout le monde m&eacute;rite d'en faire partie. Nous croyons en la promotion de l'engagement actif et de l'apprentissage continu dans notre avenir technologique.</p>
            </div>
        </div>
    </section>

    <script src="https://unpkg.com/swiper/swiper-bundle.min.js"></script>
    <script>
        var swiper = new Swiper('.swiper-container', {
            slidesPerView: 1,
            spaceBetween: 30,
            pagination: {
                el: '.swiper-pagination',
                clickable: true,
            },
            breakpoints: {
                640: {
                    slidesPerView: 2,
                    spaceBetween: 20,
                },
                768: {
                    slidesPerView: 3,
                    spaceBetween: 40,
                },
                1024: {
                    slidesPerView: 4,
                    spaceBetween: 50,
                },
            }
        });

        window.addEventListener('scroll', () => {
            document.querySelectorAll('.fade-in-section').forEach((el) => {
                const scrollY = window.scrollY + window.innerHeight;
                const elementTop = el.getBoundingClientRect().top + window.scrollY;
                const isVisible = scrollY > elementTop + 100;

                if (isVisible) {
                    el.classList.add('is-visible');
                }
            });
        });

        document.getElementById('mobile-menu-button').addEventListener('click', function() {
            document.getElementById('mobile-menu').classList.remove('hidden');
        });
        
        document.getElementById('mobile-menu-close').addEventListener('click', function() {
            document.getElementById('mobile-menu').classList.add('hidden');
        });
    </script>

    <script src="https://cdn.jsdelivr.net/npm/aos@2.3.4/dist/aos.js"></script>
    <script>
        AOS.init();

        document.addEventListener("DOMContentLoaded", function() {
            const triggers = document.querySelectorAll('.slide-trigger');

            triggers.forEach(trigger => {
                trigger.addEventListener('click', function(e) {
                    e.preventDefault();
                    const targetId = this.getAttribute('href');
                    const targetElement = document.querySelector(targetId);
                    
                    if (targetElement) {
                        targetElement.scrollIntoView({
                            behavior: 'smooth',
                            block: 'start'
                        });
                    }
                });
            });
        });
    </script>

    <footer class="bg-black text-white">
        <div class="max-w-6xl mx-auto px-4 py-10 flex flex-wrap justify-between">
            <div class="w-full md:w-1/3 p-5">
                <h5 class="text-xs uppercase font-medium mb-6">Suivez-nous</h5>
                <div class="flex items-center space-x-4">
                    <a href="https://instagram.com/this.is.imators" class="text-sm font-medium duration-700 hover:text-gray-100 flex items-center">
                        <img src="https://uxwing.com/wp-content/themes/uxwing/download/brands-and-social-media/instagram-white-icon.png" alt="Instagram" class="w-6 h-6 mr-2">
                        <span>Instagram</span>
                    </a>
                </div>
            </div>
            <div class="w-full md:w-1/3 p-5">
                <h5 class="text-xs uppercase font-medium mb-6">D&eacute;couvrir</h5>
                <a href="/fr/privacy" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
                    Politique de confidentialit&eacute;
                </a>
                <a href="fr/terms-of-use" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
                    Conditions d&apos;utilisation
                </a>
                <a href="/" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
                    Accueil
                </a>
                <a href="/fr/about-us" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
                    &Agrave; propos de nous
                </a>
                <a href="/fr/contact-us" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
                    Contactez-nous
                </a>
            </div>
            <div class="w-full md:w-1/3 p-5">
                <h5 class="text-xs uppercase font-medium mb-6">Because it's possible</h5>
                <p class="text-sm">
                    Toutes les images, vid&eacute;os et contenus de ce site sont la propri&eacute;t&eacute; d&apos;Imators.
                </p>
            </div>
        </div>
    
        <div class="text-center py-4 border-t border-gray-800">
            <p class="text-sm mb-2">
                &copy; 2024 Imators. Tous droits r&eacute;serv&eacute;s.
            </p>
            <p class="text-xs">
                Imators est une SARL (Soci&eacute;t&eacute; &agrave; Responsabilit&eacute; Limit&eacute;e) enregistr&eacute;e. Tous nos produits, qu&apos;ils soient technologiquement physiques ou simplement en ligne, sont soumis &agrave; nos r&egrave;gles, auxquelles vous pouvez acc&eacute;der.
            </p>
        </div>
    </footer>
</body>
</html>