<?php
session_start();

$planningId = $_GET['id'];
$plannings = json_decode(file_get_contents('data/plannings.json'), true);
$planning = $plannings[$planningId];

if (!$planning) {
    die('Planning non trouv');
}

$today = strtolower(date('l')); // jour actuel en minuscules
?>

<!DOCTYPE html>
<html>
<head>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-[#f5f5dc]">
    <div class="min-h-screen p-8">
        <div class="max-w-2xl mx-auto bg-white p-8 rounded-lg shadow-lg">
            <h1 class="text-2xl mb-6">Objectifs du jour</h1>
            
            <div class="mb-4">
                <h2 class="text-xl mb-2">Objectifs:</h2>
                <p class="whitespace-pre-line"><?= htmlspecialchars($planning['objectives'][$today]) ?></p>
            </div>
            
            <div class="mb-4">
                <h2 class="text-xl mb-2">Tches importantes:</h2>
                <p class="whitespace-pre-line"><?= htmlspecialchars($planning['tasks'][$today]) ?></p>
            </div>
        </div>
    </div>
</body>
</html>