<?php
session_start();

if ($_POST['name']) {
    $users = json_decode(file_get_contents('data/users.json'), true);
    $userId = uniqid();
    $users[$userId] = [
        'name' => htmlspecialchars($_POST['name']),
        'created_at' => date('Y-m-d H:i:s')
    ];
    file_put_contents('data/users.json', json_encode($users));
    $_SESSION['user_id'] = $userId;
    header('Location: home.php');
}
?>

<!DOCTYPE html>
<html>
<head>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-[#f5f5dc]">
    <div class="min-h-screen flex items-center justify-center">
        <form method="POST" class="bg-white p-8 rounded-lg shadow-lg">
            <h1 class="text-2xl mb-4">Bienvenue sur Daily</h1>
            <input type="text" name="name" placeholder="Votre nom" required 
                   class="w-full p-2 border rounded">
            <button type="submit" 
                    class="mt-4 w-full bg-blue-500 text-white p-2 rounded">
                Commencer
            </button>
        </form>
    </div>
</body>
</html>