<?php
require_once 'generate_pdf.php';
require_once 'save_program.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $program_data = $_POST;
    $filename = save_program($program_data);
    generate_pdf($program_data, $filename);
    header("Location: success.php?file=" . urlencode($filename));
    exit;
}

$days = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday'];
?>

<!DOCTYPE html>
<html lang="en">
 <link rel="icon" type="image/x-icon" href="../profile_picture.png">
<head>
<meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="apple-mobile-web-app-title" content="Program Planner">
    
    <!-- Icons pour iOS -->
    <link rel="apple-touch-icon" href="icons/icon-180.png">
    <link rel="apple-touch-icon" sizes="152x152" href="icons/icon-152.png">
    <link rel="apple-touch-icon" sizes="180x180" href="icons/icon-180.png">
    <link rel="apple-touch-icon" sizes="167x167" href="icons/icon-167.png">
    
    <!-- Splash Screens pour différentes tailles d'iPhone -->
    <link rel="apple-touch-startup-image" href="splashscreens/iPhone_14_Pro_Max_portrait.png" media="(device-width: 430px) and (device-height: 932px) and (-webkit-device-pixel-ratio: 3)">
    <link rel="apple-touch-startup-image" href="splashscreens/iPhone_14_Pro_portrait.png" media="(device-width: 393px) and (device-height: 852px) and (-webkit-device-pixel-ratio: 3)">
    <link rel="apple-touch-startup-image" href="splashscreens/iPhone_14_Plus_portrait.png" media="(device-width: 428px) and (device-height: 926px) and (-webkit-device-pixel-ratio: 3)">
    <link rel="apple-touch-startup-image" href="splashscreens/iPhone_13_Pro_Max_portrait.png" media="(device-width: 428px) and (device-height: 926px) and (-webkit-device-pixel-ratio: 3)">
    
    <!-- Manifest pour PWA -->
    <link rel="manifest" href="manifest.json">
    
    <!-- Thème et couleurs -->
    <meta name="theme-color" content="#000000">
</head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Weekly Program Planner</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-black text-white min-h-screen">
    <!-- Header avec logo -->
    <header class="fixed top-0 w-full bg-black/90 backdrop-blur-sm border-b border-gray-800 z-50">
        <div class="container mx-auto px-4 py-4 flex items-center justify-between">
            <a href="/" class="flex items-center space-x-3 group">
                <svg class="w-6 h-6 text-white group-hover:-translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"/>
                </svg>
                <span class="font-light">A Imators Systems</span>
            </a>
        </div>
    </header>

    <div class="container mx-auto px-4 pt-24 pb-12 max-w-5xl">
        <!-- Menu de sélection du type de programme -->
        <div class="text-center mb-12">
            <h1 class="text-4xl font-light mb-6">Hey Izhak ! Il est l'heure de s'organiser 😚💪</h1>
            <div class="inline-flex bg-gray-900 rounded-full p-1">
                <button type="button" 
                        class="mode-switch px-6 py-2 rounded-full bg-white text-black transition-all"
                        data-mode="school">
                    School Mode
                </button>
                <button type="button" 
                        class="mode-switch px-6 py-2 rounded-full text-gray-400 transition-all"
                        data-mode="vacation">
                    Vacation Mode
                </button>
            </div>
        </div>

        <!-- Formulaire -->
        <form method="POST" id="programForm" class="space-y-8">
            <input type="hidden" name="schedule_type" id="scheduleType" value="school">
            
            <div id="formContent" class="space-y-8">
                <!-- Le contenu sera chargé dynamiquement via JavaScript -->
            </div>

            <!-- Bouton de soumission -->
            <div class="flex justify-center pt-8">
                <button type="submit" 
                        class="bg-white text-black px-12 py-4 rounded-full hover:bg-gray-100 transition-all transform hover:scale-105 duration-200 flex items-center space-x-2 shadow-lg">
                    <span>Generate Program</span>
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                    </svg>
                </button>
            </div>
        </form>
    </div>

    <script>
    document.addEventListener('DOMContentLoaded', function() {
        const modeButtons = document.querySelectorAll('.mode-switch');
        const scheduleTypeInput = document.getElementById('scheduleType');
        const formContent = document.getElementById('formContent');

        // Style initial
        loadSchedule('school');

        modeButtons.forEach(button => {
            button.addEventListener('click', function() {
                const mode = this.dataset.mode;
                updateModeButtons(mode);
                scheduleTypeInput.value = mode;
                loadSchedule(mode);
            });
        });

        function updateModeButtons(activeMode) {
            modeButtons.forEach(button => {
                if (button.dataset.mode === activeMode) {
                    button.classList.add('bg-white', 'text-black');
                    button.classList.remove('text-gray-400');
                } else {
                    button.classList.remove('bg-white', 'text-black');
                    button.classList.add('text-gray-400');
                }
            });
        }

        function loadSchedule(mode) {
            fetch(`get_schedule.php?mode=${mode}`)
                .then(response => response.text())
                .then(html => {
                    formContent.innerHTML = html;
                    setupKeyboardNavigation();
                });
        }

        function setupKeyboardNavigation() {
            const inputs = document.querySelectorAll('input[type="text"]');
            inputs.forEach(input => {
                input.addEventListener('keypress', function(e) {
                    if (e.key === 'Enter') {
                        e.preventDefault();
                        const currentIndex = Array.from(inputs).indexOf(this);
                        if (currentIndex < inputs.length - 1) {
                            inputs[currentIndex + 1].focus();
                        }
                    }
                });
            });
        }
    });
    </script>
</body>
</html>