<?php
function generate_time_slots($type = 'school') {
    $slots = [];
    $current = strtotime("8:10");
    $end = strtotime("19:00");
    
    while ($current <= $end) {
        $timeStart = date('H:i', $current);
        $timeEnd = date('H:i', strtotime("+50 minutes", $current));
        $timeSlot = $timeStart . ' - ' . $timeEnd;
        
        if (strpos($timeStart, '10:40') === 0) {
            $slots[] = '10:40 - 11:00 [Pause]';
            $current = strtotime("11:00");
            continue;
        }
        
        if (strpos($timeStart, '12:40') === 0) {
            $slots[] = '12:40 - 13:40 [Déjeuner]';
            $current = strtotime("13:40");
            continue;
        }
        
        $slots[] = $timeSlot;
        $current = strtotime("+50 minutes", $current);
    }
    
    return $slots;
}

$mode = $_GET['mode'] ?? 'school';
$days = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday'];
$timeSlots = generate_time_slots($mode);
?>

<div class="md:hidden text-center p-4 bg-red-500/10 rounded-lg mb-4">
    <p class="text-red-400">⚠️ Pour une meilleure expérience, utilisez un ordinateur ou une tablette</p>
</div>

<div class="flex flex-col md:flex-row space-y-4 md:space-y-0 md:space-x-4">
    <?php foreach ($days as $day): ?>
    <div class="flex-1">
        <div class="bg-gradient-to-r from-indigo-600 to-purple-600 p-3 rounded-t-xl">
            <h2 class="text-lg font-bold text-white text-center"><?= $day ?></h2>
        </div>
        
        <div class="border border-gray-800 rounded-b-xl overflow-hidden">
            <?php foreach ($timeSlots as $slot): 
                $isPause = strpos($slot, '[Pause]') !== false;
                $isLunch = strpos($slot, '[Déjeuner]') !== false;
            ?>
            <div class="border-b border-gray-800 last:border-b-0">
                <div class="text-xs text-gray-400 bg-gray-900/50 px-3 py-1">
                    <?= str_replace(['[Pause]', '[Déjeuner]'], '', $slot) ?>
                </div>
                
                <?php if ($isPause || $isLunch): ?>
                    <div class="px-3 py-2 bg-gray-800/50 text-center">
                        <span class="text-xs text-gray-400">
                            <?= $isLunch ? '🍽️ Déjeuner' : '☕ Pause' ?>
                        </span>
                    </div>
                <?php else: ?>
                    <input type="text" 
                           name="program[<?= $day ?>][<?= $slot ?>]" 
                           class="w-full px-3 py-2 bg-transparent border-0 focus:ring-0 text-sm placeholder-gray-600"
                           placeholder="Activité...">
                <?php endif; ?>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
    <?php endforeach; ?>
</div>

<div class="mt-8 text-center text-sm text-gray-500">
    <p>💡 Utilisez Tab ou Enter pour naviguer entre les champs</p>
</div>
